/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import io.confluent.kafka.clients.AlterCellMigrationOptions;
import io.confluent.kafka.clients.AlterCellMigrationResult;
import io.confluent.kafka.clients.AlterCellOptions;
import io.confluent.kafka.clients.AlterCellResult;
import io.confluent.kafka.clients.AssignBrokersToCellOptions;
import io.confluent.kafka.clients.AssignBrokersToCellResult;
import io.confluent.kafka.clients.AssignTenantsToCellOptions;
import io.confluent.kafka.clients.AssignTenantsToCellResult;
import io.confluent.kafka.clients.CellLoadResult;
import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.CreateCellOptions;
import io.confluent.kafka.clients.CreateCellResult;
import io.confluent.kafka.clients.DeleteCellOptions;
import io.confluent.kafka.clients.DeleteCellResult;
import io.confluent.kafka.clients.DeleteTenantsOptions;
import io.confluent.kafka.clients.DeleteTenantsResult;
import io.confluent.kafka.clients.DescribeCellLoadOptions;
import io.confluent.kafka.clients.DescribeCellMigrationOptions;
import io.confluent.kafka.clients.DescribeCellMigrationResult;
import io.confluent.kafka.clients.DescribeCellsOptions;
import io.confluent.kafka.clients.DescribeCellsResult;
import io.confluent.kafka.clients.DescribeNetworkOptions;
import io.confluent.kafka.clients.DescribeNetworkResult;
import io.confluent.kafka.clients.DescribeTenantsOptions;
import io.confluent.kafka.clients.DescribeTenantsResult;
import io.confluent.kafka.clients.UnassignBrokersFromCellOptions;
import io.confluent.kafka.clients.UnassignBrokersFromCellResult;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AbortTransactionOptions;
import org.apache.kafka.clients.admin.AbortTransactionResult;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.AddRaftVoterOptions;
import org.apache.kafka.clients.admin.AddRaftVoterResult;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthResult;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ComputeEvenClusterLoadPlanOptions;
import org.apache.kafka.clients.admin.ComputeEvenClusterLoadPlanResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateClusterLinksResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeBalancerStatusOptions;
import org.apache.kafka.clients.admin.DescribeBalancerStatusResult;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsResult;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.clients.admin.DescribeBrokerHealthResult;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsResult;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.DescribeClassicGroupsOptions;
import org.apache.kafka.clients.admin.DescribeClassicGroupsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusOptions;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeFeaturesResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.DescribeProducersOptions;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeShareGroupsOptions;
import org.apache.kafka.clients.admin.DescribeShareGroupsResult;
import org.apache.kafka.clients.admin.DescribeSwitchoverStatusResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeTransactionsOptions;
import org.apache.kafka.clients.admin.DescribeTransactionsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FenceProducersOptions;
import org.apache.kafka.clients.admin.FenceProducersResult;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesOptions;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.ListTransactionsOptions;
import org.apache.kafka.clients.admin.ListTransactionsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.RaftVoterEndpoint;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.clients.admin.RemoveBrokersResult;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RemoveRaftVoterOptions;
import org.apache.kafka.clients.admin.RemoveRaftVoterResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.ResolveOffsetRangeOptions;
import org.apache.kafka.clients.admin.ResolveOffsetRangeResult;
import org.apache.kafka.clients.admin.ResolveOffsetRangeSpec;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.TransactionListing;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.clients.admin.TriggerEvenClusterLoadOptions;
import org.apache.kafka.clients.admin.TriggerEvenClusterLoadResult;
import org.apache.kafka.clients.admin.UnregisterBrokerOptions;
import org.apache.kafka.clients.admin.UnregisterBrokerResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicIdAndPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkDisabledException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.ConcurrentTransactionsException;
import org.apache.kafka.common.errors.DelegationTokenNotFoundException;
import org.apache.kafka.common.errors.InvalidPrincipalTypeException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;

public class MockAdminClient
extends AdminClient
implements CloudAdmin {
    public static final String DEFAULT_CLUSTER_ID = "I4ZmrWqfT2e-upky_4fdPA";
    public static final List<String> DEFAULT_LOG_DIRS = Collections.singletonList("/tmp/kafka-logs");
    private final List<Node> brokers;
    private final Map<String, TopicMetadata> allTopics = new HashMap<String, TopicMetadata>();
    private final Map<String, Uuid> topicIds = new HashMap<String, Uuid>();
    private final Map<Uuid, String> topicNames = new HashMap<Uuid, String>();
    private final Map<String, TopicType> topicTypes = new HashMap<String, TopicType>();
    private final Map<TopicPartition, NewPartitionReassignment> reassignments = new HashMap<TopicPartition, NewPartitionReassignment>();
    private final Map<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> replicaMoves = new HashMap<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo>();
    private final Map<TopicPartition, Long> beginningOffsets;
    private final Map<TopicPartition, Long> endOffsets;
    private final Map<TopicPartition, Long> committedOffsets;
    private final Map<TopicPartition, Map<Long, Long>> offsetsByTimestamp;
    private final Map<TopicPartition, Exception> offsetsWithExceptions;
    private final Map<String, ClusterLinkDescription> allClusterLinks = new HashMap<String, ClusterLinkDescription>();
    private final Map<String, TransactionListing> allTransactions = new HashMap<String, TransactionListing>();
    private final Map<String, Long> allTransactionStartTimes = new HashMap<String, Long>();
    private final boolean usingRaftController;
    private final Map<String, Short> featureLevels;
    private final Map<String, Short> minSupportedFeatureLevels;
    private final Map<String, Short> maxSupportedFeatureLevels;
    private final String clusterId;
    private final List<List<String>> brokerLogDirs;
    private final List<Map<String, String>> brokerConfigs;
    private Map<String, String> clusterConfigs;
    private final Map<String, Map<String, String>> clientMetricsConfigs;
    private final Map<String, Map<String, String>> groupConfigs;
    private final Map<String, String> defaultGroupConfigs;
    private final Map<ClientQuotaEntity, Map<String, Double>> clientQuotaData;
    private final List<KafkaMetric> addedMetrics = new ArrayList<KafkaMetric>();
    private Node controller;
    private int timeoutNextRequests = 0;
    private int numCreateTopicsInvocation = 0;
    private final int defaultPartitions;
    private final int defaultReplicationFactor;
    private boolean telemetryDisabled = false;
    private Uuid clientInstanceId;
    private int injectTimeoutExceptionCounter;
    private long blockingTimeMs;
    private Time mockTime = new MockTime();
    private boolean throwClusterLinkDisabledException = false;
    private final Map<MetricName, Metric> mockMetrics = new HashMap<MetricName, Metric>();
    private final List<DelegationToken> allTokens = new ArrayList<DelegationToken>();
    private QuorumInfo quorumInfo = null;

    public static Builder create() {
        return new Builder();
    }

    public DescribeNetworkResult describeNetwork(String tenant, String listenerName, Collection<String> ipAddresses, Collection<String> clientApiKeyList, Collection<Integer> brokerIds, DescribeNetworkOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public CellLoadResult describeCellLoad(Collection<Integer> cellIds, DescribeCellLoadOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeCellsResult describeCells(Collection<Integer> cellIds, DescribeCellsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DeleteCellResult deleteCell(int cellId, DeleteCellOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public CreateCellResult createCell(int cellId, CellState state, CreateCellOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterCellResult alterCell(int cellId, CellState state, AlterCellOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AssignBrokersToCellResult assignBrokersToCell(Collection<Integer> brokers, int cellId, boolean force, AssignBrokersToCellOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public UnassignBrokersFromCellResult unassignBrokersFromCell(Collection<Integer> brokers, UnassignBrokersFromCellOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeTenantsResult describeTenants(Collection<String> tenantIds, DescribeTenantsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DeleteTenantsResult deleteTenants(Collection<String> tenantIds, DeleteTenantsOptions options) {
        return new DeleteTenantsResult(KafkaFutureImpl.completedFuture(Collections.emptyList()));
    }

    public AssignTenantsToCellResult assignTenantsToCells(Collection<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments, AssignTenantsToCellOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterBrokerHealthResult alterBrokerHealth(AlterBrokerHealthSpec spec, AlterBrokerHealthOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeBrokerHealthResult describeBrokerHealth(DescribeBrokerHealthOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterCellMigrationResult alterCellMigration(CellMigrationState state, AlterCellMigrationOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeCellMigrationResult describeCellMigration(DescribeCellMigrationOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public MockAdminClient() {
        this(Collections.singletonList(Node.noNode()), Node.noNode());
    }

    public MockAdminClient(List<Node> brokers, Node controller) {
        this(brokers, controller, DEFAULT_CLUSTER_ID, 1, brokers.size(), Collections.nCopies(brokers.size(), DEFAULT_LOG_DIRS), false, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private MockAdminClient(List<Node> brokers, Node controller, String clusterId, int defaultPartitions, int defaultReplicationFactor, List<List<String>> brokerLogDirs, boolean usingRaftController, Map<String, Short> featureLevels, Map<String, Short> minSupportedFeatureLevels, Map<String, Short> maxSupportedFeatureLevels, Map<String, String> defaultGroupConfigs) {
        this.brokers = brokers;
        this.controller(controller);
        this.clusterId = clusterId;
        this.defaultPartitions = defaultPartitions;
        this.defaultReplicationFactor = defaultReplicationFactor;
        this.brokerLogDirs = brokerLogDirs;
        this.brokerConfigs = new ArrayList<Map<String, String>>();
        this.clientMetricsConfigs = new HashMap<String, Map<String, String>>();
        this.groupConfigs = new HashMap<String, Map<String, String>>();
        this.defaultGroupConfigs = new HashMap<String, String>(defaultGroupConfigs);
        this.clientQuotaData = new HashMap<ClientQuotaEntity, Map<String, Double>>();
        for (int i = 0; i < brokers.size(); ++i) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("default.replication.factor", String.valueOf(defaultReplicationFactor));
            this.brokerConfigs.add(config);
        }
        this.clusterConfigs = new HashMap<String, String>();
        this.beginningOffsets = new HashMap<TopicPartition, Long>();
        this.endOffsets = new HashMap<TopicPartition, Long>();
        this.committedOffsets = new HashMap<TopicPartition, Long>();
        this.offsetsByTimestamp = new HashMap<TopicPartition, Map<Long, Long>>();
        this.offsetsWithExceptions = new HashMap<TopicPartition, Exception>();
        this.usingRaftController = usingRaftController;
        this.featureLevels = new HashMap<String, Short>(featureLevels);
        this.minSupportedFeatureLevels = new HashMap<String, Short>(minSupportedFeatureLevels);
        this.maxSupportedFeatureLevels = new HashMap<String, Short>(maxSupportedFeatureLevels);
    }

    public final synchronized void controller(Node controller) {
        if (!this.brokers.contains(controller)) {
            throw new IllegalArgumentException("The controller node must be in the list of brokers");
        }
        this.controller = controller;
    }

    public void addTopic(boolean internal, String name, List<TopicPartitionInfo> partitions, Map<String, String> configs) {
        this.addTopic(internal, name, partitions, configs, true);
    }

    public synchronized void addVirtualTopic(String name, TopicPartitionInfo partition) {
        if (this.allTopics.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Topic %s was already added.", name));
        }
        Uuid topicId = Uuid.randomUuid();
        this.topicIds.put(name, topicId);
        this.topicNames.put(topicId, name);
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("confluent.topic.type", TopicType.VIRTUAL.logConfigValue());
        this.allTopics.put(name, new TopicMetadata(topicId, false, Collections.singletonList(partition), Collections.emptyList(), topicConfigs));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addTopic(boolean internal, String name, List<TopicPartitionInfo> partitions, Map<String, String> configs, boolean usesTopicId) {
        void var7_11;
        if (this.allTopics.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Topic %s was already added.", name));
        }
        for (TopicPartitionInfo topicPartitionInfo : partitions) {
            if (!this.brokers.contains(topicPartitionInfo.leader())) {
                throw new IllegalArgumentException("Leader broker unknown");
            }
            if (!this.brokers.containsAll(topicPartitionInfo.replicas())) {
                throw new IllegalArgumentException("Unknown brokers in replica list");
            }
            if (this.brokers.containsAll(topicPartitionInfo.isr())) continue;
            throw new IllegalArgumentException("Unknown brokers in isr list");
        }
        ArrayList<String> logDirs = new ArrayList<String>();
        for (TopicPartitionInfo partition : partitions) {
            if (partition.leader() == null) continue;
            logDirs.add(this.brokerLogDirs.get(partition.leader().id()).get(0));
        }
        if (usesTopicId) {
            Uuid uuid = Uuid.randomUuid();
            this.topicIds.put(name, uuid);
            this.topicNames.put(uuid, name);
            this.topicTypes.put(name, TopicType.forLogConfigValue((String)((String)((Map)Optional.ofNullable(configs).orElse(new HashMap())).get("confluent.topic.type"))).orElse(TopicType.STANDARD));
        } else {
            Uuid uuid = Uuid.ZERO_UUID;
        }
        this.allTopics.put(name, new TopicMetadata((Uuid)var7_11, internal, partitions, logDirs, configs));
    }

    public synchronized void markTopicForDeletion(String name) {
        if (!this.allTopics.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Topic %s did not exist.", name));
        }
        this.allTopics.get((Object)name).markedForDeletion = true;
    }

    public synchronized void timeoutNextRequest(int numberOfRequest) {
        this.timeoutNextRequests = numberOfRequest;
    }

    public synchronized DescribeClusterResult describeCluster(DescribeClusterOptions options) {
        KafkaFutureImpl nodesFuture = new KafkaFutureImpl();
        KafkaFutureImpl controllerFuture = new KafkaFutureImpl();
        KafkaFutureImpl brokerIdFuture = new KafkaFutureImpl();
        KafkaFutureImpl authorizedOperationsFuture = new KafkaFutureImpl();
        if (this.timeoutNextRequests > 0) {
            nodesFuture.completeExceptionally((Throwable)new TimeoutException());
            controllerFuture.completeExceptionally((Throwable)new TimeoutException());
            brokerIdFuture.completeExceptionally((Throwable)new TimeoutException());
            authorizedOperationsFuture.completeExceptionally((Throwable)new TimeoutException());
            --this.timeoutNextRequests;
        } else {
            nodesFuture.complete(this.brokers);
            controllerFuture.complete((Object)this.controller);
            brokerIdFuture.complete((Object)this.clusterId);
            authorizedOperationsFuture.complete(Collections.emptySet());
        }
        return new DescribeClusterResult((KafkaFuture)nodesFuture, (KafkaFuture)controllerFuture, (KafkaFuture)brokerIdFuture, (KafkaFuture)authorizedOperationsFuture);
    }

    public synchronized CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        ++this.numCreateTopicsInvocation;
        HashMap<String, KafkaFutureImpl> createTopicResult = new HashMap<String, KafkaFutureImpl>();
        if (this.timeoutNextRequests > 0) {
            for (NewTopic newTopic : newTopics) {
                String topicName = newTopic.name();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                createTopicResult.put(topicName, future);
            }
            --this.timeoutNextRequests;
            return new CreateTopicsResult(createTopicResult);
        }
        for (NewTopic newTopic : newTopics) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            String topicName = newTopic.name();
            if (this.allTopics.containsKey(topicName)) {
                future.completeExceptionally((Throwable)new TopicExistsException(String.format("Topic %s exists already.", topicName)));
                createTopicResult.put(topicName, future);
                continue;
            }
            int replicationFactor = newTopic.replicationFactor();
            if (replicationFactor == -1) {
                replicationFactor = this.defaultReplicationFactor;
            }
            if (replicationFactor > this.brokers.size()) {
                future.completeExceptionally((Throwable)new InvalidReplicationFactorException(String.format("Replication factor: %d is larger than brokers: %d", newTopic.replicationFactor(), this.brokers.size())));
                createTopicResult.put(topicName, future);
                continue;
            }
            ArrayList<Node> replicas = new ArrayList<Node>(replicationFactor);
            for (int i = 0; i < replicationFactor; ++i) {
                replicas.add(this.brokers.get(i));
            }
            int numberOfPartitions = newTopic.numPartitions();
            if (numberOfPartitions == -1) {
                numberOfPartitions = this.defaultPartitions;
            }
            ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>(numberOfPartitions);
            ArrayList<String> logDirs = new ArrayList<String>(numberOfPartitions);
            for (int i = 0; i < numberOfPartitions; ++i) {
                partitions.add(new TopicPartitionInfo(i, this.brokers.get(0), replicas, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
                logDirs.add(this.brokerLogDirs.get(((TopicPartitionInfo)partitions.get(i)).leader().id()).get(0));
            }
            Uuid topicId = Uuid.randomUuid();
            this.topicIds.put(topicName, topicId);
            this.topicNames.put(topicId, topicName);
            this.topicTypes.put(topicName, TopicType.forLogConfigValue((String)((String)((Map)Optional.ofNullable(newTopic.configs()).orElse(new HashMap())).get("confluent.topic.type"))).orElse(TopicType.STANDARD));
            this.allTopics.put(topicName, new TopicMetadata(topicId, false, partitions, logDirs, newTopic.configs()));
            future.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(topicId, numberOfPartitions, replicationFactor, MockAdminClient.config(newTopic)));
            createTopicResult.put(topicName, future);
        }
        return new CreateTopicsResult(createTopicResult);
    }

    private static Config config(NewTopic newTopic) {
        ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
        if (newTopic.configs() != null) {
            for (Map.Entry entry : newTopic.configs().entrySet()) {
                configEntries.add(new ConfigEntry((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return new Config(configEntries);
    }

    public synchronized ListTopicsResult listTopics(ListTopicsOptions options) {
        HashMap<String, TopicListing> topicListings = new HashMap<String, TopicListing>();
        if (this.timeoutNextRequests > 0) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new TimeoutException());
            --this.timeoutNextRequests;
            return new ListTopicsResult((KafkaFuture)future);
        }
        for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
            String topicName = topicDescription.getKey();
            if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                --topicDescription.getValue().fetchesRemainingUntilVisible;
                continue;
            }
            TopicType topicType = TopicType.forLogConfigValue((String)((String)((Map)Optional.ofNullable(topicDescription.getValue().configs).orElse(new HashMap())).get("confluent.topic.type"))).orElse(TopicType.VIRTUAL);
            topicListings.put(topicName, new TopicListing(topicName, topicDescription.getValue().topicId, topicDescription.getValue().isInternalTopic, topicType));
        }
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(topicListings);
        return new ListTopicsResult((KafkaFuture)future);
    }

    public synchronized DescribeTopicsResult describeTopics(TopicCollection topics, DescribeTopicsOptions options) {
        if (topics instanceof TopicCollection.TopicIdCollection) {
            return DescribeTopicsResult.ofTopicIds(new HashMap<Uuid, KafkaFuture<TopicDescription>>(this.handleDescribeTopicsUsingIds(((TopicCollection.TopicIdCollection)topics).topicIds(), options)));
        }
        if (topics instanceof TopicCollection.TopicNameCollection) {
            return DescribeTopicsResult.ofTopicNames(new HashMap<String, KafkaFuture<TopicDescription>>(this.handleDescribeTopicsByNames(((TopicCollection.TopicNameCollection)topics).topicNames(), options)));
        }
        throw new IllegalArgumentException("The TopicCollection provided did not match any supported classes for describeTopics.");
    }

    private Map<String, KafkaFuture<TopicDescription>> handleDescribeTopicsByNames(Collection<String> topicNames, DescribeTopicsOptions options) {
        HashMap<String, KafkaFuture<TopicDescription>> topicDescriptions = new HashMap<String, KafkaFuture<TopicDescription>>();
        if (this.timeoutNextRequests > 0) {
            for (String requestedTopic : topicNames) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                topicDescriptions.put(requestedTopic, (KafkaFuture<TopicDescription>)future);
            }
            --this.timeoutNextRequests;
            return topicDescriptions;
        }
        for (String requestedTopic : topicNames) {
            for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
                String topicName = topicDescription.getKey();
                Uuid topicId = this.topicIds.getOrDefault(topicName, Uuid.ZERO_UUID);
                TopicType topicType = this.topicTypes.getOrDefault(topicName, TopicType.STANDARD);
                if (!topicName.equals(requestedTopic) || topicDescription.getValue().markedForDeletion) continue;
                if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                    --topicDescription.getValue().fetchesRemainingUntilVisible;
                    continue;
                }
                TopicMetadata topicMetadata = topicDescription.getValue();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.complete((Object)new TopicDescription(topicName, topicMetadata.isInternalTopic, topicMetadata.partitions, Collections.emptySet(), topicId, topicType));
                topicDescriptions.put(topicName, (KafkaFuture<TopicDescription>)future);
                break;
            }
            if (topicDescriptions.containsKey(requestedTopic)) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Topic " + requestedTopic + " not found."));
            topicDescriptions.put(requestedTopic, (KafkaFuture<TopicDescription>)future);
        }
        return topicDescriptions;
    }

    public synchronized Map<Uuid, KafkaFuture<TopicDescription>> handleDescribeTopicsUsingIds(Collection<Uuid> topicIds, DescribeTopicsOptions options) {
        HashMap<Uuid, KafkaFuture<TopicDescription>> topicDescriptions = new HashMap<Uuid, KafkaFuture<TopicDescription>>();
        if (this.timeoutNextRequests > 0) {
            for (Uuid requestedTopicId : topicIds) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                topicDescriptions.put(requestedTopicId, (KafkaFuture<TopicDescription>)future);
            }
            --this.timeoutNextRequests;
            return topicDescriptions;
        }
        for (Uuid requestedTopicId : topicIds) {
            for (Map.Entry<String, TopicMetadata> topicDescription : this.allTopics.entrySet()) {
                String topicName = topicDescription.getKey();
                Uuid topicId = this.topicIds.get(topicName);
                TopicType topicType = this.topicTypes.getOrDefault(topicName, TopicType.STANDARD);
                if (topicId == null || !topicId.equals((Object)requestedTopicId) || topicDescription.getValue().markedForDeletion) continue;
                if (topicDescription.getValue().fetchesRemainingUntilVisible > 0) {
                    --topicDescription.getValue().fetchesRemainingUntilVisible;
                    continue;
                }
                TopicMetadata topicMetadata = topicDescription.getValue();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.complete((Object)new TopicDescription(topicName, topicMetadata.isInternalTopic, topicMetadata.partitions, Collections.emptySet(), topicId, topicType));
                topicDescriptions.put(requestedTopicId, (KafkaFuture<TopicDescription>)future);
                break;
            }
            if (topicDescriptions.containsKey(requestedTopicId)) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally((Throwable)new UnknownTopicIdException("Topic id" + String.valueOf(requestedTopicId) + " not found."));
            topicDescriptions.put(requestedTopicId, (KafkaFuture<TopicDescription>)future);
        }
        return topicDescriptions;
    }

    public synchronized DeleteTopicsResult deleteTopics(TopicCollection topics, DeleteTopicsOptions options) {
        DeleteTopicsResult result;
        if (topics instanceof TopicCollection.TopicIdCollection) {
            result = DeleteTopicsResult.ofTopicIds(new HashMap<Uuid, KafkaFuture<Void>>(this.handleDeleteTopicsUsingIds(((TopicCollection.TopicIdCollection)topics).topicIds(), options)));
        } else if (topics instanceof TopicCollection.TopicNameCollection) {
            result = DeleteTopicsResult.ofTopicNames(new HashMap<String, KafkaFuture<Void>>(this.handleDeleteTopicsUsingNames(((TopicCollection.TopicNameCollection)topics).topicNames(), options)));
        } else {
            throw new IllegalArgumentException("The TopicCollection provided did not match any supported classes for deleteTopics.");
        }
        return result;
    }

    private Map<String, KafkaFuture<Void>> handleDeleteTopicsUsingNames(Collection<String> topicNameCollection, DeleteTopicsOptions options) {
        HashMap<String, KafkaFuture<Void>> deleteTopicsResult = new HashMap<String, KafkaFuture<Void>>();
        ArrayList<String> topicNames = new ArrayList<String>(topicNameCollection);
        if (this.timeoutNextRequests > 0) {
            for (String topicName : topicNames) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                deleteTopicsResult.put(topicName, (KafkaFuture<Void>)future);
            }
            --this.timeoutNextRequests;
            return deleteTopicsResult;
        }
        for (String topicName : topicNames) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (this.allTopics.remove(topicName) == null) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(String.format("Topic %s does not exist.", topicName)));
            } else {
                this.topicNames.remove(this.topicIds.remove(topicName));
                future.complete(null);
            }
            deleteTopicsResult.put(topicName, (KafkaFuture<Void>)future);
        }
        return deleteTopicsResult;
    }

    private Map<Uuid, KafkaFuture<Void>> handleDeleteTopicsUsingIds(Collection<Uuid> topicIdCollection, DeleteTopicsOptions options) {
        HashMap<Uuid, KafkaFuture<Void>> deleteTopicsResult = new HashMap<Uuid, KafkaFuture<Void>>();
        ArrayList<Uuid> topicIds = new ArrayList<Uuid>(topicIdCollection);
        if (this.timeoutNextRequests > 0) {
            for (Uuid topicId : topicIds) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                deleteTopicsResult.put(topicId, (KafkaFuture<Void>)future);
            }
            --this.timeoutNextRequests;
            return deleteTopicsResult;
        }
        for (Uuid topicId : topicIds) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            String name = this.topicNames.remove(topicId);
            if (name == null || this.allTopics.remove(name) == null) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(String.format("Topic %s does not exist.", topicId)));
            } else {
                this.topicIds.remove(name);
                future.complete(null);
            }
            deleteTopicsResult.put(topicId, (KafkaFuture<Void>)future);
        }
        return deleteTopicsResult;
    }

    public synchronized CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete, DeleteRecordsOptions options) {
        HashMap deletedRecordsResult = new HashMap();
        if (recordsToDelete.isEmpty()) {
            return new DeleteRecordsResult(deletedRecordsResult);
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        for (KafkaPrincipal renewer : options.renewers()) {
            if (renewer.getPrincipalType().equals("User")) continue;
            future.completeExceptionally((Throwable)new InvalidPrincipalTypeException(""));
            return new CreateDelegationTokenResult((KafkaFuture)future);
        }
        String tokenId = Uuid.randomUuid().toString();
        TokenInformation tokenInfo = new TokenInformation(tokenId, (KafkaPrincipal)options.renewers().get(0), (Collection)options.renewers(), System.currentTimeMillis(), options.maxLifetimeMs(), -1L);
        DelegationToken token = new DelegationToken(tokenInfo, tokenId.getBytes());
        this.allTokens.add(token);
        future.complete((Object)token);
        return new CreateDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized RenewDelegationTokenResult renewDelegationToken(byte[] hmac, RenewDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        boolean tokenFound = false;
        long expiryTimestamp = options.renewTimePeriodMs();
        for (DelegationToken token : this.allTokens) {
            if (!Arrays.equals(token.hmac(), hmac)) continue;
            token.tokenInfo().setExpiryTimestamp(expiryTimestamp);
            tokenFound = true;
        }
        if (tokenFound) {
            future.complete((Object)expiryTimestamp);
        } else {
            future.completeExceptionally((Throwable)new DelegationTokenNotFoundException(""));
        }
        return new RenewDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized ExpireDelegationTokenResult expireDelegationToken(byte[] hmac, ExpireDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        long expiryTimestamp = options.expiryTimePeriodMs();
        ArrayList<DelegationToken> tokensToRemove = new ArrayList<DelegationToken>();
        boolean tokenFound = false;
        for (DelegationToken token : this.allTokens) {
            if (!Arrays.equals(token.hmac(), hmac)) continue;
            if (expiryTimestamp == -1L || expiryTimestamp < System.currentTimeMillis()) {
                tokensToRemove.add(token);
            }
            tokenFound = true;
        }
        if (tokenFound) {
            this.allTokens.removeAll(tokensToRemove);
            future.complete((Object)expiryTimestamp);
        } else {
            future.completeExceptionally((Throwable)new DelegationTokenNotFoundException(""));
        }
        return new ExpireDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (options.owners().isEmpty()) {
            future.complete(this.allTokens);
        } else {
            ArrayList<DelegationToken> tokensResult = new ArrayList<DelegationToken>();
            for (DelegationToken token : this.allTokens) {
                if (!options.owners().contains(token.tokenInfo().owner())) continue;
                tokensResult.add(token);
            }
            future.complete(tokensResult);
        }
        return new DescribeDelegationTokenResult((KafkaFuture)future);
    }

    public synchronized ListGroupsResult listGroups(ListGroupsOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)this.groupConfigs.keySet().stream().map(g -> new GroupListing(g, Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE))).collect(Collectors.toList()));
        return new ListGroupsResult((KafkaFuture)future);
    }

    public synchronized DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds, DescribeConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)this.groupConfigs.keySet().stream().map(g -> new ConsumerGroupListing(g, false)).collect(Collectors.toList()));
        return new ListConsumerGroupsResult((KafkaFuture)future);
    }

    public synchronized ListConsumerGroupOffsetsResult listConsumerGroupOffsets(Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, ListConsumerGroupOffsetsOptions options) {
        if (groupSpecs.size() != 1) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        String group = groupSpecs.keySet().iterator().next();
        Collection topicPartitions = groupSpecs.get(group).topicPartitions();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(this.committedOffsets.entrySet().stream().filter(entry -> topicPartitions.isEmpty() || topicPartitions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> new OffsetAndMetadata(((Long)entry.getValue()).longValue()))));
        return new ListConsumerGroupOffsetsResult(Collections.singletonMap(CoordinatorKey.byGroupId((String)group), future));
    }

    public synchronized DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds, DeleteConsumerGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, DeleteConsumerGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions, ElectLeadersOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String groupId, RemoveMembersFromConsumerGroupOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DescribeAclsResult describeAcls(AclBindingFilter filter, DescribeAclsOptions options) {
        throw new UnsupportedOperationException((Throwable)new InvalidRequestException("Not implemented yet"));
    }

    public synchronized DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
        if (this.timeoutNextRequests > 0) {
            HashMap<ConfigResource, KafkaFutureImpl> configs = new HashMap<ConfigResource, KafkaFutureImpl>();
            for (ConfigResource requestedResource : resources) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                configs.put(requestedResource, future);
            }
            --this.timeoutNextRequests;
            return new DescribeConfigsResult(configs);
        }
        HashMap<ConfigResource, KafkaFutureImpl> results = new HashMap<ConfigResource, KafkaFutureImpl>();
        for (ConfigResource resource : resources) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            results.put(resource, future);
            try {
                future.complete((Object)this.getResourceDescription(resource));
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        }
        return new DescribeConfigsResult(results);
    }

    private synchronized Config getResourceDescription(ConfigResource resource) {
        switch (resource.type()) {
            case BROKER: {
                if (resource.name().isEmpty()) {
                    return MockAdminClient.toConfigObject(this.clusterConfigs);
                }
                int brokerId = Integer.parseInt(resource.name());
                if (brokerId >= this.brokerConfigs.size()) {
                    throw new InvalidRequestException("Broker " + resource.name() + " not found.");
                }
                return MockAdminClient.toConfigObject(this.brokerConfigs.get(brokerId));
            }
            case TOPIC: {
                TopicMetadata topicMetadata = this.allTopics.get(resource.name());
                if (topicMetadata != null && !topicMetadata.markedForDeletion) {
                    if (topicMetadata.fetchesRemainingUntilVisible > 0) {
                        topicMetadata.fetchesRemainingUntilVisible = Math.max(0, topicMetadata.fetchesRemainingUntilVisible - 1);
                    } else {
                        return MockAdminClient.toConfigObject(topicMetadata.configs);
                    }
                }
                throw new UnknownTopicOrPartitionException("Resource " + String.valueOf(resource) + " not found.");
            }
            case CLIENT_METRICS: {
                String resourceName = resource.name();
                if (resourceName.isEmpty()) {
                    throw new InvalidRequestException("Empty resource name");
                }
                return MockAdminClient.toConfigObject(this.clientMetricsConfigs.get(resourceName));
            }
            case GROUP: {
                String resourceName = resource.name();
                if (resourceName.isEmpty()) {
                    throw new InvalidRequestException("Empty resource name");
                }
                Map groupConfig = this.groupConfigs.getOrDefault(resourceName, new HashMap());
                this.defaultGroupConfigs.forEach(groupConfig::putIfAbsent);
                return MockAdminClient.toConfigObject(groupConfig);
            }
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private static Config toConfigObject(Map<String, String> map) {
        ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configEntries.add(new ConfigEntry(entry.getKey(), entry.getValue()));
        }
        return new Config(configEntries);
    }

    public synchronized AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        HashMap<ConfigResource, KafkaFutureImpl> futures = new HashMap<ConfigResource, KafkaFutureImpl>();
        for (Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry : configs.entrySet()) {
            ConfigResource resource = entry.getKey();
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(resource, future);
            Throwable throwable = this.handleIncrementalResourceAlteration(resource, entry.getValue());
            if (throwable == null) {
                future.complete(null);
                continue;
            }
            future.completeExceptionally(throwable);
        }
        return new AlterConfigsResult(futures);
    }

    private synchronized Throwable handleIncrementalResourceAlteration(ConfigResource resource, Collection<AlterConfigOp> ops) {
        switch (resource.type()) {
            case BROKER: {
                int brokerId;
                HashMap<String, String> newMap;
                if (resource.name().isEmpty()) {
                    newMap = new HashMap<String, String>(this.clusterConfigs);
                    brokerId = -1;
                } else {
                    try {
                        brokerId = Integer.parseInt(resource.name());
                    }
                    catch (NumberFormatException e) {
                        return e;
                    }
                    if (brokerId >= this.brokerConfigs.size()) {
                        return new InvalidRequestException("no such broker as " + brokerId);
                    }
                    newMap = new HashMap<String, String>(this.brokerConfigs.get(brokerId));
                }
                block24: for (AlterConfigOp op : ops) {
                    switch (op.opType()) {
                        case SET: {
                            newMap.put(op.configEntry().name(), op.configEntry().value());
                            continue block24;
                        }
                        case DELETE: {
                            newMap.remove(op.configEntry().name());
                            continue block24;
                        }
                    }
                    return new InvalidRequestException("Unsupported op type " + String.valueOf(op.opType()));
                }
                if (resource.name().isEmpty()) {
                    this.clusterConfigs = newMap;
                } else {
                    this.brokerConfigs.set(brokerId, newMap);
                }
                return null;
            }
            case TOPIC: {
                TopicMetadata topicMetadata = this.allTopics.get(resource.name());
                if (topicMetadata == null) {
                    return new UnknownTopicOrPartitionException("No such topic as " + resource.name());
                }
                HashMap<String, String> newMap = new HashMap<String, String>(topicMetadata.configs);
                block25: for (AlterConfigOp op : ops) {
                    switch (op.opType()) {
                        case SET: {
                            newMap.put(op.configEntry().name(), op.configEntry().value());
                            continue block25;
                        }
                        case DELETE: {
                            newMap.remove(op.configEntry().name());
                            continue block25;
                        }
                    }
                    return new InvalidRequestException("Unsupported op type " + String.valueOf(op.opType()));
                }
                topicMetadata.configs = newMap;
                return null;
            }
            case CLIENT_METRICS: {
                String resourceName = resource.name();
                if (resourceName.isEmpty()) {
                    return new InvalidRequestException("Empty resource name");
                }
                if (!this.clientMetricsConfigs.containsKey(resourceName)) {
                    this.clientMetricsConfigs.put(resourceName, new HashMap());
                }
                HashMap<String, String> newMap = new HashMap<String, String>(this.clientMetricsConfigs.get(resourceName));
                block26: for (AlterConfigOp op : ops) {
                    switch (op.opType()) {
                        case SET: {
                            newMap.put(op.configEntry().name(), op.configEntry().value());
                            continue block26;
                        }
                        case DELETE: {
                            newMap.remove(op.configEntry().name());
                            continue block26;
                        }
                    }
                    return new InvalidRequestException("Unsupported op type " + String.valueOf(op.opType()));
                }
                this.clientMetricsConfigs.put(resourceName, newMap);
                return null;
            }
            case GROUP: {
                String resourceName = resource.name();
                if (resourceName.isEmpty()) {
                    return new InvalidRequestException("Empty resource name");
                }
                if (!this.groupConfigs.containsKey(resourceName)) {
                    this.groupConfigs.put(resourceName, new HashMap());
                }
                HashMap<String, String> newMap = new HashMap<String, String>(this.groupConfigs.get(resourceName));
                block27: for (AlterConfigOp op : ops) {
                    switch (op.opType()) {
                        case SET: {
                            newMap.put(op.configEntry().name(), op.configEntry().value());
                            continue block27;
                        }
                        case DELETE: {
                            newMap.remove(op.configEntry().name());
                            continue block27;
                        }
                    }
                    return new InvalidRequestException("Unsupported op type " + String.valueOf(op.opType()));
                }
                this.groupConfigs.put(resourceName, newMap);
                return null;
            }
        }
        return new UnsupportedOperationException();
    }

    public synchronized AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment, AlterReplicaLogDirsOptions options) {
        HashMap<TopicPartitionReplica, KafkaFutureImpl> results = new HashMap<TopicPartitionReplica, KafkaFutureImpl>();
        for (Map.Entry<TopicPartitionReplica, String> entry : replicaAssignment.entrySet()) {
            TopicPartitionReplica replica = entry.getKey();
            String newLogDir = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            results.put(replica, future);
            List<String> dirs = this.brokerLogDirs.get(replica.brokerId());
            if (dirs == null) {
                future.completeExceptionally((Throwable)new ReplicaNotAvailableException("Can't find " + String.valueOf(replica)));
                continue;
            }
            if (!dirs.contains(newLogDir)) {
                future.completeExceptionally((Throwable)new KafkaStorageException("Log directory " + newLogDir + " is offline"));
                continue;
            }
            TopicMetadata metadata = this.allTopics.get(replica.topic());
            if (metadata == null || metadata.partitions.size() <= replica.partition()) {
                future.completeExceptionally((Throwable)new ReplicaNotAvailableException("Can't find " + String.valueOf(replica)));
                continue;
            }
            String currentLogDir = metadata.partitionLogDirs.get(replica.partition());
            this.replicaMoves.put(replica, new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(currentLogDir, 0L, newLogDir, 0L));
            future.complete(null);
        }
        return new AlterReplicaLogDirsResult(results);
    }

    public synchronized DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers, DescribeLogDirsOptions options) {
        HashMap unwrappedResults = new HashMap();
        for (Integer n : brokers) {
            unwrappedResults.putIfAbsent(n, new HashMap());
        }
        for (Map.Entry entry : this.allTopics.entrySet()) {
            String topicName = (String)entry.getKey();
            TopicMetadata topicMetadata = (TopicMetadata)entry.getValue();
            List<String> partitionLogDirs = topicMetadata.partitionLogDirs;
            List<TopicPartitionInfo> topicPartitionInfos = topicMetadata.partitions;
            for (TopicPartitionInfo topicPartitionInfo : topicPartitionInfos) {
                List nodes = topicPartitionInfo.replicas();
                for (Node node : nodes) {
                    Map logDirDescriptionMap = (Map)unwrappedResults.get(node.id());
                    LogDirDescription logDirDescription = logDirDescriptionMap.getOrDefault(partitionLogDirs.get(0), new LogDirDescription(null, new HashMap()));
                    HashMap<TopicPartition, ReplicaInfo> topicPartitionReplicaInfoMap = new HashMap<TopicPartition, ReplicaInfo>(logDirDescription.replicaInfos());
                    topicPartitionReplicaInfoMap.put(new TopicPartition(topicName, topicPartitionInfo.partition()), new ReplicaInfo(0L, 0L, false));
                    logDirDescriptionMap.put(partitionLogDirs.get(0), new LogDirDescription(logDirDescription.error(), topicPartitionReplicaInfoMap, logDirDescription.totalBytes().orElse(-1L), logDirDescription.usableBytes().orElse(-1L)));
                }
            }
        }
        HashMap<Integer, KafkaFutureImpl> results = new HashMap<Integer, KafkaFutureImpl>();
        for (Map.Entry entry : unwrappedResults.entrySet()) {
            KafkaFutureImpl kafkaFuture = new KafkaFutureImpl();
            kafkaFuture.complete((Object)((Map)entry.getValue()));
            results.put((Integer)entry.getKey(), kafkaFuture);
        }
        return new DescribeLogDirsResult(results);
    }

    public synchronized DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas, DescribeReplicaLogDirsOptions options) {
        HashMap<TopicPartitionReplica, KafkaFutureImpl> results = new HashMap<TopicPartitionReplica, KafkaFutureImpl>();
        for (TopicPartitionReplica replica : replicas) {
            TopicMetadata topicMetadata = this.allTopics.get(replica.topic());
            if (topicMetadata == null) continue;
            KafkaFutureImpl future = new KafkaFutureImpl();
            results.put(replica, future);
            String currentLogDir = this.currentLogDir(replica);
            if (currentLogDir == null) {
                future.complete((Object)new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(null, -1L, null, -1L));
                continue;
            }
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo info = this.replicaMoves.get(replica);
            if (info == null) {
                future.complete((Object)new DescribeReplicaLogDirsResult.ReplicaLogDirInfo(currentLogDir, 0L, null, 0L));
                continue;
            }
            future.complete((Object)info);
        }
        return new DescribeReplicaLogDirsResult(results);
    }

    private synchronized String currentLogDir(TopicPartitionReplica replica) {
        TopicMetadata topicMetadata = this.allTopics.get(replica.topic());
        if (topicMetadata == null) {
            return null;
        }
        if (topicMetadata.partitionLogDirs.size() <= replica.partition()) {
            return null;
        }
        return topicMetadata.partitionLogDirs.get(replica.partition());
    }

    public synchronized AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> newReassignments, AlterPartitionReassignmentsOptions options) {
        HashMap<TopicPartition, KafkaFutureImpl> futures = new HashMap<TopicPartition, KafkaFutureImpl>();
        for (Map.Entry<TopicPartition, Optional<NewPartitionReassignment>> entry : newReassignments.entrySet()) {
            TopicPartition partition = entry.getKey();
            Optional<NewPartitionReassignment> newReassignment = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(partition, future);
            TopicMetadata topicMetadata = this.allTopics.get(partition.topic());
            if (partition.partition() < 0 || topicMetadata == null || topicMetadata.partitions.size() <= partition.partition()) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
                continue;
            }
            if (newReassignment.isPresent()) {
                this.reassignments.put(partition, newReassignment.get());
                future.complete(null);
                continue;
            }
            this.reassignments.remove(partition);
            future.complete(null);
        }
        return new AlterPartitionReassignmentsResult(futures);
    }

    public synchronized ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> partitions, ListPartitionReassignmentsOptions options) {
        HashMap<TopicPartition, PartitionReassignment> map = new HashMap<TopicPartition, PartitionReassignment>();
        for (TopicPartition partition : partitions.isPresent() ? partitions.get() : this.reassignments.keySet()) {
            PartitionReassignment reassignment = this.findPartitionReassignment(partition);
            if (reassignment == null) continue;
            map.put(partition, reassignment);
        }
        return new ListPartitionReassignmentsResult(KafkaFutureImpl.completedFuture(map));
    }

    private synchronized PartitionReassignment findPartitionReassignment(TopicPartition partition) {
        NewPartitionReassignment reassignment = this.reassignments.get(partition);
        if (reassignment == null) {
            return null;
        }
        TopicMetadata metadata = this.allTopics.get(partition.topic());
        if (metadata == null) {
            throw new RuntimeException("Internal MockAdminClient logic error: found reassignment for " + String.valueOf(partition) + ", but no TopicMetadata");
        }
        TopicPartitionInfo info = metadata.partitions.get(partition.partition());
        if (info == null) {
            throw new RuntimeException("Internal MockAdminClient logic error: found reassignment for " + String.valueOf(partition) + ", but no TopicPartitionInfo");
        }
        ArrayList<Integer> replicas = new ArrayList<Integer>();
        ArrayList<Integer> removingReplicas = new ArrayList<Integer>();
        ArrayList addingReplicas = new ArrayList(reassignment.targetReplicas());
        for (Node node : info.replicas()) {
            replicas.add(node.id());
            if (!reassignment.targetReplicas().contains(node.id())) {
                removingReplicas.add(node.id());
            }
            addingReplicas.remove((Object)node.id());
        }
        return new PartitionReassignment(replicas, addingReplicas, removingReplicas);
    }

    public synchronized AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, AlterConsumerGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    public synchronized ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions options) {
        HashMap<TopicPartition, KafkaFutureImpl> futures = new HashMap<TopicPartition, KafkaFutureImpl>();
        for (Map.Entry<TopicPartition, OffsetSpec> entry : topicPartitionOffsets.entrySet()) {
            TopicPartition tp = entry.getKey();
            OffsetSpec spec = entry.getValue();
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (this.offsetsWithExceptions.containsKey(tp)) {
                future.completeExceptionally((Throwable)this.offsetsWithExceptions.get(tp));
            } else if (spec instanceof OffsetSpec.TimestampSpec) {
                long timestamp;
                Map timestampOffsets = this.offsetsByTimestamp.getOrDefault(tp, Collections.emptyMap());
                if (!timestampOffsets.containsKey(timestamp = ((OffsetSpec.TimestampSpec)spec).timestamp())) {
                    throw new RuntimeException("Internal MockAdminClient logic error: Missing offset for timestamp.");
                }
                future.complete((Object)new ListOffsetsResult.ListOffsetsResultInfo(((Long)timestampOffsets.get(timestamp)).longValue(), timestamp, Optional.empty()));
            } else if (spec instanceof OffsetSpec.EarliestSpec) {
                future.complete((Object)new ListOffsetsResult.ListOffsetsResultInfo(this.beginningOffsets.get(tp).longValue(), -1L, Optional.empty()));
            } else {
                future.complete((Object)new ListOffsetsResult.ListOffsetsResultInfo(this.endOffsets.get(tp).longValue(), -1L, Optional.empty()));
            }
            futures.put(tp, future);
        }
        return new ListOffsetsResult(futures);
    }

    public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
        HashMap<String, String> exactMatch = new HashMap<String, String>();
        HashSet<String> typeMatch = new HashSet<String>();
        for (ClientQuotaFilterComponent component : filter.components()) {
            if (component.match() == null) {
                typeMatch.add(component.entityType());
                continue;
            }
            if (component.match().isPresent()) {
                exactMatch.put(component.entityType(), (String)component.match().get());
                continue;
            }
            exactMatch.put(component.entityType(), null);
        }
        HashMap<ClientQuotaEntity, Map<String, Double>> result = new HashMap<ClientQuotaEntity, Map<String, Double>>();
        for (Map.Entry<ClientQuotaEntity, Map<String, Double>> entry : this.clientQuotaData.entrySet()) {
            ClientQuotaEntity entity = entry.getKey();
            if (!MockAdminClient.matches(entity, exactMatch, typeMatch, filter.strict())) continue;
            result.put(entity, entry.getValue());
        }
        return new DescribeClientQuotasResult(KafkaFuture.completedFuture(result));
    }

    private static boolean matches(ClientQuotaEntity entity, Map<String, String> exactMatch, Set<String> typeMatch, boolean strict) {
        if (strict && entity.entries().size() != exactMatch.size() + typeMatch.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : exactMatch.entrySet()) {
            if (!entity.entries().containsKey(entry.getKey())) {
                return false;
            }
            if (Objects.equals(entity.entries().get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        for (String type : typeMatch) {
            if (entity.entries().containsKey(type)) continue;
            return false;
        }
        return true;
    }

    public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
        HashMap<ClientQuotaEntity, KafkaFutureImpl> futures = new HashMap<ClientQuotaEntity, KafkaFutureImpl>();
        for (ClientQuotaAlteration alteration : entries) {
            ClientQuotaEntity entity = alteration.entity();
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (!options.validateOnly()) {
                Collection alterOps = alteration.ops();
                if (!this.clientQuotaData.containsKey(entity)) {
                    this.clientQuotaData.put(entity, new HashMap());
                }
                for (ClientQuotaAlteration.Op alterOp : alterOps) {
                    this.clientQuotaData.get(entity).put(alterOp.key(), alterOp.value());
                }
            }
            future.complete(null);
            futures.put(entity, future);
        }
        return new AlterClientQuotasResult(futures);
    }

    @Confluent
    public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, ReplicaStatusOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public CreateAclsResult createCentralizedAcls(Collection<AclBinding> acls, CreateAclsOptions options, String clusterId, int writerBrokerId) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public DeleteAclsResult deleteCentralizedAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options, String clusterId, int writerBrokerId) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public RemoveBrokersResult removeBrokers(List<Integer> brokersToRemove, RemoveBrokersOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public DescribeBrokerRemovalsResult describeBrokerRemovals(DescribeBrokerRemovalsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public DescribeBrokerAdditionsResult describeBrokerAdditions(DescribeBrokerAdditionsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public DescribeBalancerStatusResult describeBalancerStatus(DescribeBalancerStatusOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Confluent
    public TriggerEvenClusterLoadResult triggerEvenClusterLoad(List<String> goalList, TriggerEvenClusterLoadOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Confluent
    public ComputeEvenClusterLoadPlanResult computeEvenClusterLoadPlan(List<String> goalList, ComputeEvenClusterLoadPlanOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Confluent
    public DescribeEvenClusterLoadStatusResult describeEvenClusterLoadStatus(DescribeEvenClusterLoadStatusOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterBrokerReplicaExclusionsResult alterBrokerReplicaExclusions(Map<Integer, ExclusionOp> operations, AlterBrokerReplicaExclusionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeBrokerReplicaExclusionsResult describeBrokerReplicaExclusions(DescribeBrokerReplicaExclusionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Confluent
    public CreateClusterLinksResult createClusterLinks(Collection<NewClusterLink> newClusterLinks, CreateClusterLinksOptions options) {
        HashMap<String, KafkaFutureImpl> createLinkResult = new HashMap<String, KafkaFutureImpl>();
        if (this.timeoutNextRequests > 0) {
            for (NewClusterLink newClusterLink : newClusterLinks) {
                String linkName = newClusterLink.linkName();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                createLinkResult.put(linkName, future);
            }
            --this.timeoutNextRequests;
            return new CreateClusterLinksResult(createLinkResult);
        }
        if (this.throwClusterLinkDisabledException) {
            for (NewClusterLink newClusterLink : newClusterLinks) {
                String linkName = newClusterLink.linkName();
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new ClusterLinkDisabledException("Disabled"));
                createLinkResult.put(linkName, future);
            }
            return new CreateClusterLinksResult(createLinkResult);
        }
        for (NewClusterLink newClusterLink : newClusterLinks) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            String linkName = newClusterLink.linkName();
            if (this.allClusterLinks.containsKey(linkName)) {
                future.completeExceptionally((Throwable)new ClusterLinkExistsException(String.format("Cluster link %s exists already.", linkName)));
                createLinkResult.put(linkName, future);
                continue;
            }
            this.allClusterLinks.put(linkName, new ClusterLinkDescription.Builder().setLinkName(linkName).setLinkId(Uuid.randomUuid()).setRemoteClusterId(newClusterLink.clusterId()).setLocalClusterId("local-cluster").setTopics(null).setLinkState(ClusterLinkDescription.LinkState.ACTIVE).setLinkMode(ClusterLinkDescription.LinkMode.DESTINATION).setConnectionMode(ClusterLinkDescription.ConnectionMode.OUTBOUND).setClusterLinkError(ClusterLinkError.NO_ERROR).setLinkErrorMessage(null).setLinkCoordinator(Node.noNode()).build());
            future.complete(null);
        }
        return new CreateClusterLinksResult(createLinkResult);
    }

    @Confluent
    public ListClusterLinksResult listClusterLinks(ListClusterLinksOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (this.timeoutNextRequests > 0) {
            --this.timeoutNextRequests;
            future.completeExceptionally((Throwable)new TimeoutException());
            return new ListClusterLinksResult((KafkaFuture)future);
        }
        if (this.throwClusterLinkDisabledException) {
            future.completeExceptionally((Throwable)new ClusterLinkDisabledException("Disabled"));
            return new ListClusterLinksResult((KafkaFuture)future);
        }
        HashSet<ClusterLinkListing> listing = new HashSet<ClusterLinkListing>();
        for (ClusterLinkDescription description : this.allClusterLinks.values()) {
            boolean linkAvailable = description.linkState() != ClusterLinkDescription.LinkState.UNAVAILABLE && description.linkState() != ClusterLinkDescription.LinkState.FAILED;
            listing.add(new ClusterLinkListing(description.linkName(), description.clusterLinkId(), description.remoteClusterId(), description.localClusterId(), description.topics(), linkAvailable ? ClusterLinkError.NO_ERROR : ClusterLinkError.AUTHENTICATION_ERROR, linkAvailable ? null : "Link is unavailable", description.linkState()));
        }
        future.complete(listing);
        return new ListClusterLinksResult((KafkaFuture)future);
    }

    @Confluent
    public DescribeClusterLinksResult describeClusterLinks(DescribeClusterLinksOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (this.timeoutNextRequests > 0) {
            --this.timeoutNextRequests;
            future.completeExceptionally((Throwable)new TimeoutException());
            return new DescribeClusterLinksResult((KafkaFuture)future);
        }
        if (this.throwClusterLinkDisabledException) {
            future.completeExceptionally((Throwable)new ClusterLinkDisabledException("Disabled"));
            return new DescribeClusterLinksResult((KafkaFuture)future);
        }
        future.complete(this.allClusterLinks.values());
        return new DescribeClusterLinksResult((KafkaFuture)future);
    }

    @Confluent
    public ResolveOffsetRangeResult resolveOffsetRange(Map<TopicIdAndPartition, ResolveOffsetRangeSpec> topicPartitionOffsets, ResolveOffsetRangeOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public DeleteClusterLinksResult deleteClusterLinks(Collection<String> linkNames, DeleteClusterLinksOptions options) {
        HashMap<String, KafkaFutureImpl> deleteLinkResult = new HashMap<String, KafkaFutureImpl>();
        if (this.timeoutNextRequests > 0) {
            for (String linkName : linkNames) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new TimeoutException());
                deleteLinkResult.put(linkName, future);
            }
            --this.timeoutNextRequests;
            return new DeleteClusterLinksResult(deleteLinkResult);
        }
        if (this.throwClusterLinkDisabledException) {
            for (String linkName : linkNames) {
                KafkaFutureImpl future = new KafkaFutureImpl();
                future.completeExceptionally((Throwable)new ClusterLinkDisabledException("Disabled"));
                deleteLinkResult.put(linkName, future);
            }
            return new DeleteClusterLinksResult(deleteLinkResult);
        }
        for (String linkName : linkNames) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (this.allClusterLinks.remove(linkName) == null) {
                future.completeExceptionally((Throwable)new ClusterLinkNotFoundException(linkName + " is not found"));
                deleteLinkResult.put(linkName, future);
                continue;
            }
            future.complete(null);
        }
        return new DeleteClusterLinksResult(deleteLinkResult);
    }

    public AlterMirrorsResult alterMirrors(Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    @Confluent
    public DescribeSwitchoverStatusResult describeSwitchoverStatus(String linkName) {
        throw new UnsupportedOperationException("Not implement yet");
    }

    public DescribeUserScramCredentialsResult describeUserScramCredentials(List<String> users, DescribeUserScramCredentialsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(List<UserScramCredentialAlteration> alterations, AlterUserScramCredentialsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeMetadataQuorumResult describeMetadataQuorum(DescribeMetadataQuorumOptions options) {
        if (this.quorumInfo == null) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        return new DescribeMetadataQuorumResult(KafkaFuture.completedFuture((Object)this.quorumInfo));
    }

    public void setQuorumInfo(QuorumInfo quorumInfo) {
        this.quorumInfo = quorumInfo;
    }

    public DescribeFeaturesResult describeFeatures(DescribeFeaturesOptions options) {
        HashMap<String, FinalizedVersionRange> finalizedFeatures = new HashMap<String, FinalizedVersionRange>();
        HashMap<String, SupportedVersionRange> supportedFeatures = new HashMap<String, SupportedVersionRange>();
        for (Map.Entry<String, Short> entry : this.featureLevels.entrySet()) {
            finalizedFeatures.put(entry.getKey(), new FinalizedVersionRange(entry.getValue().shortValue(), entry.getValue().shortValue()));
            supportedFeatures.put(entry.getKey(), new SupportedVersionRange(this.minSupportedFeatureLevels.get(entry.getKey()).shortValue(), this.maxSupportedFeatureLevels.get(entry.getKey()).shortValue()));
        }
        return new DescribeFeaturesResult(KafkaFuture.completedFuture((Object)new FeatureMetadata(finalizedFeatures, Optional.of(123L), supportedFeatures)));
    }

    public UpdateFeaturesResult updateFeatures(Map<String, FeatureUpdate> featureUpdates, UpdateFeaturesOptions options) {
        InvalidRequestException error = null;
        for (Map.Entry<String, FeatureUpdate> entry : featureUpdates.entrySet()) {
            String feature = entry.getKey();
            short next = entry.getValue().maxVersionLevel();
            short min = this.minSupportedFeatureLevels.getOrDefault(feature, (short)0);
            short max = this.maxSupportedFeatureLevels.getOrDefault(feature, (short)0);
            try {
                switch (entry.getValue().upgradeType()) {
                    case UNKNOWN: {
                        throw new InvalidRequestException("Invalid upgrade type.");
                    }
                    case UPGRADE: {
                        short cur;
                        if (cur <= next) break;
                        throw new InvalidUpdateVersionException("Can't upgrade to lower version.");
                    }
                    case SAFE_DOWNGRADE: {
                        short cur;
                        if (cur >= next) break;
                        throw new InvalidUpdateVersionException("Can't downgrade to newer version.");
                    }
                    case UNSAFE_DOWNGRADE: {
                        short cur;
                        if (cur < next) {
                            throw new InvalidUpdateVersionException("Can't downgrade to newer version.");
                        }
                        for (cur = this.featureLevels.getOrDefault(feature, 0).shortValue(); next != cur; cur = (short)(cur - 1)) {
                            if (cur % 2 != 0 || entry.getValue().upgradeType() != FeatureUpdate.UpgradeType.SAFE_DOWNGRADE) continue;
                            throw new InvalidUpdateVersionException("Unable to perform a safe downgrade.");
                        }
                        break;
                    }
                }
                if (next < min) {
                    throw new InvalidUpdateVersionException("Can't downgrade below " + min);
                }
                if (next <= max) continue;
                throw new InvalidUpdateVersionException("Can't upgrade above " + max);
            }
            catch (Exception e) {
                error = this.invalidUpdateVersion(feature, next, e.getMessage());
                break;
            }
        }
        HashMap<String, KafkaFutureImpl> results = new HashMap<String, KafkaFutureImpl>();
        for (Map.Entry<String, FeatureUpdate> entry : featureUpdates.entrySet()) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (error == null) {
                future.complete(null);
                if (!options.validateOnly()) {
                    this.featureLevels.put(entry.getKey(), entry.getValue().maxVersionLevel());
                }
            } else {
                future.completeExceptionally(error);
            }
            results.put(entry.getKey(), future);
        }
        return new UpdateFeaturesResult(results);
    }

    private InvalidRequestException invalidUpdateVersion(String feature, short version, String message) {
        return new InvalidRequestException(String.format("Invalid update version %d for feature %s. %s", version, feature, message));
    }

    public UnregisterBrokerResult unregisterBroker(int brokerId, UnregisterBrokerOptions options) {
        if (this.usingRaftController) {
            return new UnregisterBrokerResult(KafkaFuture.completedFuture(null));
        }
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException(""));
        return new UnregisterBrokerResult((KafkaFuture)future);
    }

    public DescribeProducersResult describeProducers(Collection<TopicPartition> partitions, DescribeProducersOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public DescribeTransactionsResult describeTransactions(Collection<String> transactionalIds, DescribeTransactionsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AbortTransactionResult abortTransaction(AbortTransactionSpec spec, AbortTransactionOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ListTransactionsResult listTransactions(ListTransactionsOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)this.allTransactions.entrySet().stream().filter(entries -> this.includeTransaction((TransactionListing)entries.getValue(), options)).map(Map.Entry::getValue).collect(Collectors.toList()));
        KafkaFutureImpl finalFuture = new KafkaFutureImpl();
        finalFuture.complete(Collections.singletonMap(0, future));
        return new ListTransactionsResult((KafkaFuture)finalFuture);
    }

    private boolean includeTransaction(TransactionListing listing, ListTransactionsOptions options) {
        if (!options.filteredProducerIds().isEmpty() && !options.filteredProducerIds().contains(listing.producerId())) {
            return false;
        }
        if (!options.filteredStates().isEmpty() && !options.filteredStates().contains(listing.state())) {
            return false;
        }
        return options.filteredDuration() < 0L || this.mockTime.milliseconds() - this.allTransactionStartTimes.get(listing.transactionalId()) > options.filteredDuration();
    }

    public FenceProducersResult fenceProducers(Collection<String> transactionalIds, FenceProducersOptions options) {
        HashMap<CoordinatorKey, KafkaFutureImpl> futures = new HashMap<CoordinatorKey, KafkaFutureImpl>();
        for (String transactionalId : transactionalIds) {
            KafkaFutureImpl result = new KafkaFutureImpl();
            if (this.allTransactions.containsKey(transactionalId)) {
                TransactionListing listing = this.allTransactions.remove(transactionalId);
                this.allTransactions.put(transactionalId, new TransactionListing(listing.transactionalId(), listing.producerId(), TransactionState.PREPARE_ABORT));
                this.allTransactionStartTimes.put(transactionalId, -1L);
                result.completeExceptionally((Throwable)new ConcurrentTransactionsException("InitProducerId request for transactionalId: " + transactionalId + " failed due to unexpected error"));
            } else {
                result.complete((Object)new ProducerIdAndEpoch(0L, 0));
                this.allTransactions.put(transactionalId, new TransactionListing(transactionalId, 0L, TransactionState.EMPTY));
                this.allTransactionStartTimes.put(transactionalId, -1L);
            }
            futures.put(CoordinatorKey.byTransactionalId((String)transactionalId), result);
        }
        return new FenceProducersResult(futures);
    }

    public ListClientMetricsResourcesResult listClientMetricsResources(ListClientMetricsResourcesOptions options) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)this.clientMetricsConfigs.keySet().stream().map(ClientMetricsResourceListing::new).collect(Collectors.toList()));
        return new ListClientMetricsResourcesResult((KafkaFuture)future);
    }

    public AddRaftVoterResult addRaftVoter(int voterId, Uuid voterDirectoryId, Set<RaftVoterEndpoint> endpoints, AddRaftVoterOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public RemoveRaftVoterResult removeRaftVoter(int voterId, Uuid voterDirectoryId, RemoveRaftVoterOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DescribeShareGroupsResult describeShareGroups(Collection<String> groupIds, DescribeShareGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized ListShareGroupOffsetsResult listShareGroupOffsets(Map<String, ListShareGroupOffsetsSpec> groupSpecs, ListShareGroupOffsetsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized DescribeClassicGroupsResult describeClassicGroups(Collection<String> groupIds, DescribeClassicGroupsOptions options) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public synchronized void close(Duration timeout) {
    }

    public synchronized void updateBeginningOffsets(Map<TopicPartition, Long> newOffsets) {
        this.beginningOffsets.putAll(newOffsets);
    }

    public synchronized void updateEndOffsets(Map<TopicPartition, Long> newOffsets) {
        this.endOffsets.putAll(newOffsets);
    }

    public synchronized void updateConsumerGroupOffsets(Map<TopicPartition, Long> newOffsets) {
        this.committedOffsets.putAll(newOffsets);
    }

    public synchronized void updateOffsetsByTimestamp(Map<TopicPartition, Map<Long, Long>> newOffsetsByTimestamp) {
        this.offsetsByTimestamp.putAll(newOffsetsByTimestamp);
    }

    public synchronized void updateOffsetsWithExceptions(Map<TopicPartition, Exception> newOffsetsWithExceptions) {
        this.offsetsWithExceptions.putAll(newOffsetsWithExceptions);
    }

    public void updateClusterLinkDisabledException(boolean throwException) {
        this.throwClusterLinkDisabledException = throwException;
    }

    public synchronized void setMockMetrics(MetricName name, Metric metric) {
        this.mockMetrics.put(name, metric);
    }

    public synchronized void startMockTransaction(String transactionalId, long producerId) {
        this.allTransactions.put(transactionalId, new TransactionListing(transactionalId, producerId, TransactionState.ONGOING));
        this.allTransactionStartTimes.put(transactionalId, this.mockTime.milliseconds());
    }

    public void disableTelemetry() {
        this.telemetryDisabled = true;
    }

    public void injectTimeoutException(int injectTimeoutExceptionCounter) {
        this.injectTimeoutExceptionCounter = injectTimeoutExceptionCounter;
    }

    public void advanceTimeOnClientInstanceId(Time mockTime, long blockingTimeMs) {
        this.mockTime = mockTime;
        this.blockingTimeMs = blockingTimeMs;
    }

    public void setClientInstanceId(Uuid instanceId) {
        this.clientInstanceId = instanceId;
    }

    public Uuid clientInstanceId(Duration timeout) {
        if (this.telemetryDisabled) {
            throw new IllegalStateException();
        }
        if (this.clientInstanceId == null) {
            throw new UnsupportedOperationException("clientInstanceId not set");
        }
        if (this.injectTimeoutExceptionCounter != 0) {
            if (this.injectTimeoutExceptionCounter > 0) {
                --this.injectTimeoutExceptionCounter;
            }
            throw new TimeoutException();
        }
        if (this.mockTime != null) {
            this.mockTime.sleep(this.blockingTimeMs);
        }
        return this.clientInstanceId;
    }

    public synchronized Map<MetricName, ? extends Metric> metrics() {
        return this.mockMetrics;
    }

    public synchronized void setFetchesRemainingUntilVisible(String topicName, int fetchesRemainingUntilVisible) {
        TopicMetadata metadata = this.allTopics.get(topicName);
        if (metadata == null) {
            throw new RuntimeException("No such topic as " + topicName);
        }
        metadata.fetchesRemainingUntilVisible = fetchesRemainingUntilVisible;
    }

    public synchronized List<Node> brokers() {
        return new ArrayList<Node>(this.brokers);
    }

    public synchronized Node broker(int index) {
        return this.brokers.get(index);
    }

    public synchronized int NumCreateTopicsInvocation() {
        return this.numCreateTopicsInvocation;
    }

    public List<KafkaMetric> addedMetrics() {
        return Collections.unmodifiableList(this.addedMetrics);
    }

    public void registerMetricForSubscription(KafkaMetric metric) {
        this.addedMetrics.add(metric);
    }

    public void unregisterMetricFromSubscription(KafkaMetric metric) {
        this.addedMetrics.remove(metric);
    }

    public static class Builder {
        private String clusterId = "I4ZmrWqfT2e-upky_4fdPA";
        private List<Node> brokers = new ArrayList<Node>();
        private Node controller = null;
        private List<List<String>> brokerLogDirs = new ArrayList<List<String>>();
        private Short defaultPartitions;
        private boolean usingRaftController = false;
        private Integer defaultReplicationFactor;
        private Map<String, Short> featureLevels = Collections.emptyMap();
        private Map<String, Short> minSupportedFeatureLevels = Collections.emptyMap();
        private Map<String, Short> maxSupportedFeatureLevels = Collections.emptyMap();
        private Map<String, String> defaultGroupConfigs = Collections.emptyMap();

        public Builder() {
            this.numBrokers(1);
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder brokers(List<Node> brokers) {
            this.numBrokers(brokers.size());
            this.brokers = brokers;
            return this;
        }

        public final Builder numBrokers(int numBrokers) {
            if (this.brokers.size() >= numBrokers) {
                this.brokers = this.brokers.subList(0, numBrokers);
                this.brokerLogDirs = this.brokerLogDirs.subList(0, numBrokers);
            } else {
                for (int id = this.brokers.size(); id < numBrokers; ++id) {
                    this.brokers.add(new Node(id, "localhost", 1000 + id));
                    this.brokerLogDirs.add(DEFAULT_LOG_DIRS);
                }
            }
            return this;
        }

        public Builder controller(int index) {
            this.controller = this.brokers.get(index);
            return this;
        }

        public Builder brokerLogDirs(List<List<String>> brokerLogDirs) {
            this.brokerLogDirs = brokerLogDirs;
            return this;
        }

        public Builder defaultReplicationFactor(int defaultReplicationFactor) {
            this.defaultReplicationFactor = defaultReplicationFactor;
            return this;
        }

        public Builder usingRaftController(boolean usingRaftController) {
            this.usingRaftController = usingRaftController;
            return this;
        }

        public Builder defaultPartitions(short numPartitions) {
            this.defaultPartitions = numPartitions;
            return this;
        }

        public Builder featureLevels(Map<String, Short> featureLevels) {
            this.featureLevels = featureLevels;
            return this;
        }

        public Builder minSupportedFeatureLevels(Map<String, Short> minSupportedFeatureLevels) {
            this.minSupportedFeatureLevels = minSupportedFeatureLevels;
            return this;
        }

        public Builder maxSupportedFeatureLevels(Map<String, Short> maxSupportedFeatureLevels) {
            this.maxSupportedFeatureLevels = maxSupportedFeatureLevels;
            return this;
        }

        public Builder defaultGroupConfigs(Map<String, String> defaultGroupConfigs) {
            this.defaultGroupConfigs = defaultGroupConfigs;
            return this;
        }

        public MockAdminClient build() {
            return new MockAdminClient(this.brokers, this.controller == null ? this.brokers.get(0) : this.controller, this.clusterId, this.defaultPartitions != null ? this.defaultPartitions : (short)1, this.defaultReplicationFactor != null ? this.defaultReplicationFactor.shortValue() : Math.min(this.brokers.size(), 3), this.brokerLogDirs, this.usingRaftController, this.featureLevels, this.minSupportedFeatureLevels, this.maxSupportedFeatureLevels, this.defaultGroupConfigs);
        }
    }

    private static final class TopicMetadata {
        final Uuid topicId;
        final boolean isInternalTopic;
        final List<TopicPartitionInfo> partitions;
        final List<String> partitionLogDirs;
        Map<String, String> configs;
        int fetchesRemainingUntilVisible;
        public boolean markedForDeletion;

        TopicMetadata(Uuid topicId, boolean isInternalTopic, List<TopicPartitionInfo> partitions, List<String> partitionLogDirs, Map<String, String> configs) {
            this.topicId = topicId;
            this.isInternalTopic = isInternalTopic;
            this.partitions = partitions;
            this.partitionLogDirs = partitionLogDirs;
            this.configs = configs != null ? configs : Collections.emptyMap();
            this.markedForDeletion = false;
            this.fetchesRemainingUntilVisible = 0;
        }
    }
}

