/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.SampleMetrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.ExponentialWeightedAvg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.metrics.stats.WindowedSum;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsTest {
    private static final Logger log = LoggerFactory.getLogger(MetricsTest.class);
    private static final double EPS = 1.0E-6;
    private final MockTime time = new MockTime();
    private final MetricConfig config = new MetricConfig();
    private Metrics metrics;
    private ExecutorService executorService;

    @BeforeEach
    public void setup() {
        this.metrics = new Metrics(this.config, Collections.singletonList(new JmxReporter()), (Time)this.time, true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        this.metrics.close();
    }

    @Test
    public void testMetricName() {
        MetricName n1 = this.metrics.metricName("name", "group", "description", new String[]{"key1", "value1", "key2", "value2"});
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("key1", "value1");
        tags.put("key2", "value2");
        MetricName n2 = this.metrics.metricName("name", "group", "description", tags);
        Assertions.assertEquals((Object)n1, (Object)n2, (String)"metric names created in two different ways should be equal");
        try {
            this.metrics.metricName("name", "group", "description", new String[]{"key1"});
            Assertions.fail((String)"Creating MetricName with an odd number of keyValue should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testManyMetricNamesWithSameMeasurableStat() {
        MetricName n1 = this.metrics.metricName("name", "group", "description", new String[]{"key1", "value1"});
        MetricName n2 = this.metrics.metricName("name", "group", "description", new String[]{"key1", "value2"});
        Max m = new Max();
        this.metrics.addMetric(n1, (Measurable)m);
        this.metrics.addMetric(n2, (Measurable)m);
        m.record(this.config, 5.0, 100L);
        double p1 = (Double)this.metrics.metric(n1).metricValue();
        double p2 = (Double)this.metrics.metric(n2).metricValue();
        Assertions.assertEquals((double)p1, (double)p2, (String)"Expect 2 different metric names with the same stat to have the same metric value");
    }

    @Test
    public void testSimpleStats() {
        this.verifyStats(m -> (double)((Double)m.metricValue()));
    }

    private void verifyStats(Function<KafkaMetric, Double> metricValueFunc) {
        ConstantMeasurable measurable = new ConstantMeasurable();
        this.metrics.addMetric(this.metrics.metricName("direct.measurable", "grp1", "The fraction of time an appender waits for space allocation."), (Measurable)measurable);
        Sensor s = this.metrics.sensor("test.sensor");
        s.add(this.metrics.metricName("test.avg", "grp1"), (MeasurableStat)new Avg());
        s.add(this.metrics.metricName("test.max", "grp1"), (MeasurableStat)new Max());
        s.add(this.metrics.metricName("test.min", "grp1"), (MeasurableStat)new Min());
        s.add(this.metrics.metricName("test.exponentialWeightedAvg", "grp1"), (MeasurableStat)new ExponentialWeightedAvg(0.7));
        s.add((CompoundStat)new Meter(TimeUnit.SECONDS, this.metrics.metricName("test.rate", "grp1"), this.metrics.metricName("test.total", "grp1")));
        s.add((CompoundStat)new Meter(TimeUnit.SECONDS, (SampledStat)new WindowedCount(), this.metrics.metricName("test.occurrences", "grp1"), this.metrics.metricName("test.occurrences.total", "grp1")));
        s.add(this.metrics.metricName("test.count", "grp1"), (MeasurableStat)new WindowedCount());
        s.add((CompoundStat)new Percentiles(100, -100.0, 100.0, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.metrics.metricName("test.median", "grp1"), 50.0), new Percentile(this.metrics.metricName("test.perc99_9", "grp1"), 99.9)}));
        Sensor s2 = this.metrics.sensor("test.sensor2");
        s2.add(this.metrics.metricName("s2.total", "grp1"), (MeasurableStat)new CumulativeSum());
        s2.record(5.0);
        int sum = 0;
        int count = 10;
        for (int i = 0; i < count; ++i) {
            s.record((double)i);
            sum += i;
        }
        double elapsedSecs = (double)(this.config.timeWindowMs() * (long)(this.config.samples() - 1)) / 1000.0;
        Assertions.assertEquals((double)((double)count / elapsedSecs), (double)metricValueFunc.apply((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.occurrences", "grp1"))), (double)1.0E-6, (String)String.format("Occurrences(0...%d) = %f", count, (double)count / elapsedSecs));
        long sleepTimeMs = 2L;
        this.time.sleep(sleepTimeMs * 1000L);
        Assertions.assertEquals((double)5.0, (double)metricValueFunc.apply(this.metrics.metric(this.metrics.metricName("s2.total", "grp1"))), (double)1.0E-6, (String)"s2 reflects the constant value");
        Assertions.assertEquals((double)4.5, (double)metricValueFunc.apply(this.metrics.metric(this.metrics.metricName("test.avg", "grp1"))), (double)1.0E-6, (String)"Avg(0...9) = 4.5");
        Assertions.assertEquals((double)(count - 1), (double)metricValueFunc.apply(this.metrics.metric(this.metrics.metricName("test.max", "grp1"))), (double)1.0E-6, (String)"Max(0...9) = 9");
        Assertions.assertEquals((double)0.0, (double)metricValueFunc.apply(this.metrics.metric(this.metrics.metricName("test.min", "grp1"))), (double)1.0E-6, (String)"Min(0...9) = 0");
        Assertions.assertEquals((double)((double)sum / (elapsedSecs += (double)sleepTimeMs)), (double)metricValueFunc.apply(this.metrics.metric(this.metrics.metricName("test.rate", "grp1"))), (double)1.0E-6, (String)"Rate(0...9) = 1.40625");
        Assertions.assertEquals((double)((double)count / elapsedSecs), (double)metricValueFunc.apply(this.metrics.metric(this.metrics.metricName("test.occurrences", "grp1"))), (double)1.0E-6, (String)String.format("Occurrences(0...%d) = %f", count, (double)count / elapsedSecs));
        Assertions.assertEquals((double)count, (double)metricValueFunc.apply(this.metrics.metric(this.metrics.metricName("test.count", "grp1"))), (double)1.0E-6, (String)"Count(0...9) = 10");
        sleepTimeMs = 30L;
        this.time.sleep(sleepTimeMs * 1000L);
        elapsedSecs += (double)sleepTimeMs;
        s.record(1.0);
        Assertions.assertEquals((double)4.5, (double)metricValueFunc.apply((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.exponentialWeightedAvg", "grp1"))), (double)1.0E-6, (String)"ExponentialWeightedAvg(0..9) = x");
    }

    @Test
    public void testHierarchicalSensors() {
        Sensor parent1 = this.metrics.sensor("test.parent1");
        parent1.add(this.metrics.metricName("test.parent1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor parent2 = this.metrics.sensor("test.parent2");
        parent2.add(this.metrics.metricName("test.parent2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor child1 = this.metrics.sensor("test.child1", new Sensor[]{parent1, parent2});
        child1.add(this.metrics.metricName("test.child1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor child2 = this.metrics.sensor("test.child2", new Sensor[]{parent1});
        child2.add(this.metrics.metricName("test.child2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor grandchild = this.metrics.sensor("test.grandchild", new Sensor[]{child1});
        grandchild.add(this.metrics.metricName("test.grandchild.count", "grp1"), (MeasurableStat)new WindowedCount());
        parent1.record();
        parent2.record();
        child1.record();
        child2.record();
        grandchild.record();
        double p1 = (Double)((KafkaMetric)parent1.metrics().get(0)).metricValue();
        double p2 = (Double)((KafkaMetric)parent2.metrics().get(0)).metricValue();
        double c1 = (Double)((KafkaMetric)child1.metrics().get(0)).metricValue();
        double c2 = (Double)((KafkaMetric)child2.metrics().get(0)).metricValue();
        double gc = (Double)((KafkaMetric)grandchild.metrics().get(0)).metricValue();
        Assertions.assertEquals((double)1.0, (double)gc, (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 + gc), (double)c1, (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (double)c2, (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 + c1), (double)p2, (double)1.0E-6);
        Assertions.assertEquals((double)(1.0 + c1 + c2), (double)p1, (double)1.0E-6);
        Assertions.assertEquals(Arrays.asList(child1, child2), this.metrics.childrenSensors().get(parent1));
        Assertions.assertEquals(Collections.singletonList(child1), this.metrics.childrenSensors().get(parent2));
        Assertions.assertNull(this.metrics.childrenSensors().get(grandchild));
    }

    @Test
    public void testBadSensorHierarchy() {
        Sensor p = this.metrics.sensor("parent");
        Sensor c1 = this.metrics.sensor("child1", new Sensor[]{p});
        Sensor c2 = this.metrics.sensor("child2", new Sensor[]{p});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.metrics.sensor("gc", new Sensor[]{c1, c2}));
    }

    @Test
    public void testRemoveChildSensor() {
        Metrics metrics = new Metrics();
        Sensor parent = metrics.sensor("parent");
        Sensor child = metrics.sensor("child", new Sensor[]{parent});
        Assertions.assertEquals(Collections.singletonList(child), metrics.childrenSensors().get(parent));
        metrics.removeSensor("child");
        Assertions.assertEquals(Collections.emptyList(), metrics.childrenSensors().get(parent));
    }

    @Test
    public void testRemoveSensor() {
        int size = this.metrics.metrics().size();
        Sensor parent1 = this.metrics.sensor("test.parent1");
        parent1.add(this.metrics.metricName("test.parent1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor parent2 = this.metrics.sensor("test.parent2");
        parent2.add(this.metrics.metricName("test.parent2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor child1 = this.metrics.sensor("test.child1", new Sensor[]{parent1, parent2});
        child1.add(this.metrics.metricName("test.child1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor child2 = this.metrics.sensor("test.child2", new Sensor[]{parent2});
        child2.add(this.metrics.metricName("test.child2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor grandChild1 = this.metrics.sensor("test.gchild2", new Sensor[]{child2});
        grandChild1.add(this.metrics.metricName("test.gchild2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor sensor = this.metrics.getSensor("test.parent1");
        Assertions.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.parent1");
        Assertions.assertNull((Object)this.metrics.getSensor("test.parent1"));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.parent1.count", "grp1")));
        Assertions.assertNull((Object)this.metrics.getSensor("test.child1"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.child1.count", "grp1")));
        sensor = this.metrics.getSensor("test.gchild2");
        Assertions.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.gchild2");
        Assertions.assertNull((Object)this.metrics.getSensor("test.gchild2"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.gchild2.count", "grp1")));
        sensor = this.metrics.getSensor("test.child2");
        Assertions.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.child2");
        Assertions.assertNull((Object)this.metrics.getSensor("test.child2"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.child2.count", "grp1")));
        sensor = this.metrics.getSensor("test.parent2");
        Assertions.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.parent2");
        Assertions.assertNull((Object)this.metrics.getSensor("test.parent2"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.parent2.count", "grp1")));
        Assertions.assertEquals((int)size, (int)this.metrics.metrics().size());
    }

    @Test
    public void testRemoveSensorWithRemovalCallback() {
        ArrayList removedSensorNames = new ArrayList();
        Consumer<Sensor> removeCallback = sensor -> removedSensorNames.add(sensor.name());
        Sensor parent1 = this.metrics.sensor("test.parent1", null, Long.MAX_VALUE, Sensor.RecordingLevel.INFO, removeCallback, new Sensor[0]);
        parent1.add(this.metrics.metricName("test.parent1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor parent2 = this.metrics.sensor("test.parent2", null, Long.MAX_VALUE, Sensor.RecordingLevel.INFO, removeCallback, new Sensor[0]);
        parent2.add(this.metrics.metricName("test.parent2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor child1 = this.metrics.sensor("test.child1", null, Long.MAX_VALUE, Sensor.RecordingLevel.INFO, removeCallback, new Sensor[]{parent1, parent2});
        child1.add(this.metrics.metricName("test.child1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor child2 = this.metrics.sensor("test.child2", null, Long.MAX_VALUE, Sensor.RecordingLevel.INFO, removeCallback, new Sensor[]{parent2});
        child2.add(this.metrics.metricName("test.child2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor grandChild1 = this.metrics.sensor("test.gchild2", null, Long.MAX_VALUE, Sensor.RecordingLevel.INFO, removeCallback, new Sensor[]{child2});
        grandChild1.add(this.metrics.metricName("test.gchild2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor sensor2 = this.metrics.getSensor("test.parent1");
        Assertions.assertNotNull((Object)sensor2);
        this.metrics.removeSensor("test.parent1");
        Assertions.assertNull((Object)this.metrics.getSensor("test.parent1"));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.parent1.count", "grp1")));
        Assertions.assertNull((Object)this.metrics.getSensor("test.child1"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor2));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.child1.count", "grp1")));
        Assertions.assertEquals(Arrays.asList("test.parent1", "test.child1"), removedSensorNames);
        sensor2 = this.metrics.getSensor("test.gchild2");
        Assertions.assertNotNull((Object)sensor2);
        this.metrics.removeSensor("test.gchild2");
        Assertions.assertNull((Object)this.metrics.getSensor("test.gchild2"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor2));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.gchild2.count", "grp1")));
        Assertions.assertEquals(Arrays.asList("test.parent1", "test.child1", "test.gchild2"), removedSensorNames);
        sensor2 = this.metrics.getSensor("test.child2");
        Assertions.assertNotNull((Object)sensor2);
        this.metrics.removeSensor("test.child2");
        Assertions.assertNull((Object)this.metrics.getSensor("test.child2"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor2));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.child2.count", "grp1")));
        Assertions.assertEquals(Arrays.asList("test.parent1", "test.child1", "test.gchild2", "test.child2"), removedSensorNames);
        sensor2 = this.metrics.getSensor("test.parent2");
        Assertions.assertNotNull((Object)sensor2);
        this.metrics.removeSensor("test.parent2");
        Assertions.assertNull((Object)this.metrics.getSensor("test.parent2"));
        Assertions.assertNull(this.metrics.childrenSensors().get(sensor2));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.parent2.count", "grp1")));
        Assertions.assertEquals(Arrays.asList("test.parent1", "test.child1", "test.gchild2", "test.child2", "test.parent2"), removedSensorNames);
    }

    @Test
    public void testEmitWhenNonDefaultMetrics() {
        String sensorName = "test sensor";
        final AtomicInteger value = new AtomicInteger(1);
        Supplier<Double> metricValueProvider = new Supplier<Double>(){

            @Override
            public Double get() {
                return value.doubleValue();
            }
        };
        MetricName metricName = this.metrics.metricName("test.s1.count", "grp1");
        this.metrics.registerEmitWhenNonDefaultMetricSensor(sensorName, metricName, null, (Supplier)metricValueProvider, Double.valueOf(0.0));
        Assertions.assertNotNull((Object)this.metrics.getSensor(sensorName), (String)("Sensor " + sensorName + " must be present"));
        Assertions.assertNotNull(this.metrics.metrics().get(metricName), (String)("MetricName " + metricName.name() + " must be present"));
        Metrics.RegisterEmitWhenNonDefaultMetricsSensorsTask reducer = new Metrics.RegisterEmitWhenNonDefaultMetricsSensorsTask(this.metrics);
        reducer.run();
        Assertions.assertNotNull((Object)this.metrics.getSensor(sensorName), (String)("Sensor " + sensorName + " must be present"));
        Assertions.assertNotNull(this.metrics.metrics().get(metricName), (String)("MetricName " + metricName.name() + " must be present"));
        value.set(0);
        reducer.run();
        Assertions.assertNull((Object)this.metrics.getSensor(sensorName), (String)("Sensor " + sensorName + " must be absent"));
        Assertions.assertNull(this.metrics.metrics().get(metricName), (String)("MetricName " + metricName.name() + " must be absent"));
        value.set(10);
        reducer.run();
        Assertions.assertNotNull((Object)this.metrics.getSensor(sensorName), (String)("Sensor " + sensorName + " must be present"));
        Assertions.assertNotNull(this.metrics.metrics().get(metricName), (String)("MetricName " + metricName.name() + " must be present"));
        this.metrics.removeEmitWhenNonDefaultMetricSensor(sensorName);
        Assertions.assertNull((Object)this.metrics.getSensor(sensorName), (String)("Sensor " + sensorName + " must be absent"));
        Assertions.assertNull(this.metrics.metrics().get(metricName), (String)("MetricName " + metricName.name() + " must be absent"));
    }

    @Test
    public void testRemoveInactiveMetrics() {
        Sensor s1 = this.metrics.sensor("test.s1", null, 1L, new Sensor[0]);
        s1.add(this.metrics.metricName("test.s1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Sensor s2 = this.metrics.sensor("test.s2", null, 3L, new Sensor[0]);
        s2.add(this.metrics.metricName("test.s2.count", "grp1"), (MeasurableStat)new WindowedCount());
        Metrics.ExpireSensorTask purger = new Metrics.ExpireSensorTask(this.metrics);
        purger.run();
        Assertions.assertNotNull((Object)this.metrics.getSensor("test.s1"), (String)"Sensor test.s1 must be present");
        Assertions.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("test.s1.count", "grp1")), (String)"MetricName test.s1.count must be present");
        Assertions.assertNotNull((Object)this.metrics.getSensor("test.s2"), (String)"Sensor test.s2 must be present");
        Assertions.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("test.s2.count", "grp1")), (String)"MetricName test.s2.count must be present");
        this.time.sleep(1001L);
        purger.run();
        Assertions.assertNull((Object)this.metrics.getSensor("test.s1"), (String)"Sensor test.s1 should have been purged");
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.s1.count", "grp1")), (String)"MetricName test.s1.count should have been purged");
        Assertions.assertNotNull((Object)this.metrics.getSensor("test.s2"), (String)"Sensor test.s2 must be present");
        Assertions.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("test.s2.count", "grp1")), (String)"MetricName test.s2.count must be present");
        s2.record();
        this.time.sleep(2000L);
        purger.run();
        Assertions.assertNotNull((Object)this.metrics.getSensor("test.s2"), (String)"Sensor test.s2 must be present");
        Assertions.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("test.s2.count", "grp1")), (String)"MetricName test.s2.count must be present");
        this.time.sleep(1001L);
        purger.run();
        Assertions.assertNull((Object)this.metrics.getSensor("test.s2"), (String)"Sensor test.s2 should have been purged");
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.s2.count", "grp1")), (String)"MetricName test.s2.count should have been purged");
        s1 = this.metrics.sensor("test.s1", null, 1L, new Sensor[0]);
        s1.add(this.metrics.metricName("test.s1.count", "grp1"), (MeasurableStat)new WindowedCount());
        Assertions.assertNotNull((Object)this.metrics.getSensor("test.s1"), (String)"Sensor test.s1 must be present");
        Assertions.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("test.s1.count", "grp1")), (String)"MetricName test.s1.count must be present");
    }

    @Test
    public void testRemoveMetric() {
        int size = this.metrics.metrics().size();
        this.metrics.addMetric(this.metrics.metricName("test1", "grp1"), (Measurable)new WindowedCount());
        this.metrics.addMetric(this.metrics.metricName("test2", "grp1"), (Measurable)new WindowedCount());
        Assertions.assertNotNull((Object)this.metrics.removeMetric(this.metrics.metricName("test1", "grp1")));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test1", "grp1")));
        Assertions.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("test2", "grp1")));
        Assertions.assertNotNull((Object)this.metrics.removeMetric(this.metrics.metricName("test2", "grp1")));
        Assertions.assertNull(this.metrics.metrics().get(this.metrics.metricName("test2", "grp1")));
        Assertions.assertEquals((int)size, (int)this.metrics.metrics().size());
    }

    @Test
    public void testTimeWindowing() {
        WindowedCount count = new WindowedCount();
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.MILLISECONDS).samples(2);
        count.record(config, 1.0, this.time.milliseconds());
        this.time.sleep(1L);
        count.record(config, 1.0, this.time.milliseconds());
        Assertions.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
        this.time.sleep(1L);
        count.record(config, 1.0, this.time.milliseconds());
        Assertions.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test
    public void testOldDataHasNoEffect() {
        Max max = new Max();
        long windowMs = 100L;
        int samples = 2;
        MetricConfig config = new MetricConfig().timeWindow(windowMs, TimeUnit.MILLISECONDS).samples(samples);
        max.record(config, 50.0, this.time.milliseconds());
        this.time.sleep((long)samples * windowMs);
        Assertions.assertEquals((double)Double.NaN, (double)max.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test
    public void testSampledStatReturnsNaNWhenNoValuesExist() {
        Max max = new Max();
        Min min = new Min();
        Avg avg = new Avg();
        ExponentialWeightedAvg exponentialWeightedAvg = new ExponentialWeightedAvg(0.7);
        long windowMs = 100L;
        int samples = 2;
        MetricConfig config = new MetricConfig().timeWindow(windowMs, TimeUnit.MILLISECONDS).samples(samples);
        max.record(config, 50.0, this.time.milliseconds());
        min.record(config, 50.0, this.time.milliseconds());
        avg.record(config, 50.0, this.time.milliseconds());
        exponentialWeightedAvg.record(config, 50.0, this.time.milliseconds());
        this.time.sleep((long)samples * windowMs);
        Assertions.assertEquals((double)Double.NaN, (double)max.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assertions.assertEquals((double)Double.NaN, (double)min.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assertions.assertEquals((double)Double.NaN, (double)avg.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assertions.assertEquals((double)Double.NaN, (double)exponentialWeightedAvg.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test
    public void testSampledStatReturnsInitialValueWhenNoValuesExist() {
        WindowedCount count = new WindowedCount();
        WindowedSum sampledTotal = new WindowedSum();
        long windowMs = 100L;
        int samples = 2;
        MetricConfig config = new MetricConfig().timeWindow(windowMs, TimeUnit.MILLISECONDS).samples(samples);
        count.record(config, 50.0, this.time.milliseconds());
        sampledTotal.record(config, 50.0, this.time.milliseconds());
        this.time.sleep((long)samples * windowMs);
        Assertions.assertEquals((double)0.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)sampledTotal.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test
    public void testDuplicateMetricName() {
        this.metrics.sensor("test").add(this.metrics.metricName("test", "grp1"), (MeasurableStat)new Avg());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.metrics.sensor("test2").add(this.metrics.metricName("test", "grp1"), (MeasurableStat)new CumulativeSum()));
    }

    @Test
    public void testQuotas() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metrics.metricName("test1.total", "grp1"), (MeasurableStat)new CumulativeSum(), new MetricConfig().quota(Quota.upperBound((double)5.0)));
        sensor.add(this.metrics.metricName("test2.total", "grp1"), (MeasurableStat)new CumulativeSum(), new MetricConfig().quota(Quota.lowerBound((double)0.0)));
        sensor.record(5.0);
        try {
            sensor.record(1.0);
            Assertions.fail((String)"Should have gotten a quota violation.");
        }
        catch (QuotaViolationException quotaViolationException) {
            // empty catch block
        }
        Assertions.assertEquals((double)6.0, (double)((Double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test1.total", "grp1"))).metricValue()), (double)1.0E-6);
        sensor.record(-6.0);
        try {
            sensor.record(-1.0);
            Assertions.fail((String)"Should have gotten a quota violation.");
        }
        catch (QuotaViolationException quotaViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testQuotasEquality() {
        Quota quota1 = Quota.upperBound((double)10.5);
        Quota quota2 = Quota.lowerBound((double)10.5);
        Assertions.assertNotEquals((Object)quota1, (Object)quota2, (String)"Quota with different upper values shouldn't be equal");
        Quota quota3 = Quota.lowerBound((double)10.5);
        Assertions.assertEquals((Object)quota2, (Object)quota3, (String)"Quota with same upper and bound values should be equal");
    }

    @Test
    public void testPercentiles() {
        int buckets = 100;
        Percentiles percs = new Percentiles(4 * buckets, 0.0, 100.0, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.metrics.metricName("test.p25", "grp1"), 25.0), new Percentile(this.metrics.metricName("test.p50", "grp1"), 50.0), new Percentile(this.metrics.metricName("test.p75", "grp1"), 75.0)});
        MetricConfig config = new MetricConfig().eventWindow(50L).samples(2);
        Sensor sensor = this.metrics.sensor("test", config, new Sensor[0]);
        sensor.add((CompoundStat)percs);
        Metric p25 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p25", "grp1"));
        Metric p50 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p50", "grp1"));
        Metric p75 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p75", "grp1"));
        for (int i = 0; i < buckets; ++i) {
            sensor.record((double)i);
        }
        Assertions.assertEquals((double)25.0, (Double)((Double)p25.metricValue()));
        Assertions.assertEquals((double)50.0, (Double)((Double)p50.metricValue()));
        Assertions.assertEquals((double)75.0, (Double)((Double)p75.metricValue()));
    }

    @Test
    public void shouldPinSmallerValuesToMin() {
        double min = 0.0;
        double max = 100.0;
        Percentiles percs = new Percentiles(1000, 0.0, 100.0, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(this.metrics.metricName("test.p50", "grp1"), 50.0)});
        MetricConfig config = new MetricConfig().eventWindow(50L).samples(2);
        Sensor sensor = this.metrics.sensor("test", config, new Sensor[0]);
        sensor.add((CompoundStat)percs);
        Metric p50 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p50", "grp1"));
        sensor.record(-100.0);
        sensor.record(-100.0);
        Assertions.assertEquals((double)0.0, (double)((Double)p50.metricValue()), (double)0.0);
    }

    @Test
    public void shouldPinLargerValuesToMax() {
        double min = 0.0;
        double max = 100.0;
        Percentiles percs = new Percentiles(1000, 0.0, 100.0, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(this.metrics.metricName("test.p50", "grp1"), 50.0)});
        MetricConfig config = new MetricConfig().eventWindow(50L).samples(2);
        Sensor sensor = this.metrics.sensor("test", config, new Sensor[0]);
        sensor.add((CompoundStat)percs);
        Metric p50 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p50", "grp1"));
        sensor.record(200.0);
        sensor.record(200.0);
        Assertions.assertEquals((double)100.0, (double)((Double)p50.metricValue()), (double)0.0);
    }

    @Test
    public void testPercentilesWithRandomNumbersAndLinearBucketing() {
        long seed = new Random().nextLong();
        int sizeInBytes = 100000;
        long maximumValue = 86400000000L;
        try {
            Random prng = new Random(seed);
            int numberOfValues = 5000 + prng.nextInt(10000);
            Percentiles percs = new Percentiles(sizeInBytes, (double)maximumValue, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(this.metrics.metricName("test.p90", "grp1"), 90.0), new Percentile(this.metrics.metricName("test.p99", "grp1"), 99.0)});
            MetricConfig config = new MetricConfig().eventWindow(50L).samples(2);
            Sensor sensor = this.metrics.sensor("test", config, new Sensor[0]);
            sensor.add((CompoundStat)percs);
            Metric p90 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p90", "grp1"));
            Metric p99 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p99", "grp1"));
            ArrayList<Long> values = new ArrayList<Long>(numberOfValues);
            for (int i = 0; i < numberOfValues; ++i) {
                long value = (Math.abs(prng.nextLong()) - 1L) % maximumValue;
                values.add(value);
                sensor.record((double)value);
            }
            Collections.sort(values);
            int p90Index = (int)Math.ceil((double)(90 * numberOfValues) / 100.0);
            int p99Index = (int)Math.ceil((double)(99 * numberOfValues) / 100.0);
            double expectedP90 = ((Long)values.get(p90Index - 1)).longValue();
            double expectedP99 = ((Long)values.get(p99Index - 1)).longValue();
            Assertions.assertEquals((double)expectedP90, (double)((Double)p90.metricValue()), (double)(expectedP90 / 5.0));
            Assertions.assertEquals((double)expectedP99, (double)((Double)p99.metricValue()), (double)(expectedP99 / 5.0));
        }
        catch (AssertionError e) {
            throw new AssertionError("Assertion failed in randomized test. Reproduce with seed = " + seed + " .", (Throwable)((Object)e));
        }
    }

    @Test
    public void testRateWindowing() {
        MetricConfig cfg = new MetricConfig().samples(3);
        Sensor s = this.metrics.sensor("test.sensor", cfg, new Sensor[0]);
        MetricName rateMetricName = this.metrics.metricName("test.rate", "grp1");
        MetricName totalMetricName = this.metrics.metricName("test.total", "grp1");
        MetricName countRateMetricName = this.metrics.metricName("test.count.rate", "grp1");
        MetricName countTotalMetricName = this.metrics.metricName("test.count.total", "grp1");
        s.add((CompoundStat)new Meter(TimeUnit.SECONDS, rateMetricName, totalMetricName));
        s.add((CompoundStat)new Meter(TimeUnit.SECONDS, (SampledStat)new WindowedCount(), countRateMetricName, countTotalMetricName));
        KafkaMetric totalMetric = (KafkaMetric)this.metrics.metrics().get(totalMetricName);
        KafkaMetric countTotalMetric = (KafkaMetric)this.metrics.metrics().get(countTotalMetricName);
        int sum = 0;
        int count = cfg.samples() - 1;
        for (int i = 0; i < count; ++i) {
            s.record(100.0);
            this.time.sleep(cfg.timeWindowMs());
            Assertions.assertEquals((double)(sum += 100), (double)((Double)totalMetric.metricValue()), (double)1.0E-6);
        }
        this.time.sleep(cfg.timeWindowMs() / 2L);
        double elapsedSecs = MetricsUtils.convert((long)cfg.timeWindowMs(), (TimeUnit)TimeUnit.SECONDS) * ((double)cfg.samples() - 0.5);
        KafkaMetric rateMetric = (KafkaMetric)this.metrics.metrics().get(rateMetricName);
        KafkaMetric countRateMetric = (KafkaMetric)this.metrics.metrics().get(countRateMetricName);
        Assertions.assertEquals((double)((double)sum / elapsedSecs), (double)((Double)rateMetric.metricValue()), (double)1.0E-6, (String)"Rate(0...2) = 2.666");
        Assertions.assertEquals((double)((double)count / elapsedSecs), (double)((Double)countRateMetric.metricValue()), (double)1.0E-6, (String)"Count rate(0...2) = 0.02666");
        Assertions.assertEquals((double)elapsedSecs, (double)MetricsUtils.convert((long)((Rate)rateMetric.measurable()).windowSize(cfg, this.time.milliseconds()), (TimeUnit)TimeUnit.SECONDS), (double)1.0E-6, (String)"Elapsed Time = 75 seconds");
        Assertions.assertEquals((double)sum, (double)((Double)totalMetric.metricValue()), (double)1.0E-6);
        Assertions.assertEquals((double)count, (double)((Double)countTotalMetric.metricValue()), (double)1.0E-6);
        this.time.sleep(cfg.timeWindowMs() * (long)cfg.samples());
        Assertions.assertEquals((double)0.0, (double)((Double)rateMetric.metricValue()), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)((Double)countRateMetric.metricValue()), (double)1.0E-6);
        Assertions.assertEquals((double)sum, (double)((Double)totalMetric.metricValue()), (double)1.0E-6);
        Assertions.assertEquals((double)count, (double)((Double)countTotalMetric.metricValue()), (double)1.0E-6);
    }

    @Test
    public void testSimpleRate() {
        SimpleRate rate = new SimpleRate();
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.SECONDS).samples(10);
        this.record((Rate)rate, config, 1000);
        Assertions.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(100L);
        Assertions.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(100L);
        Assertions.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(200L);
        Assertions.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(600L);
        Assertions.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(200L);
        Assertions.assertEquals((double)833.3333333333334, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(200L);
        Assertions.assertEquals((double)714.2857142857143, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.record((Rate)rate, config, 1000);
        Assertions.assertEquals((double)1428.5714285714287, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(1100L);
        Assertions.assertEquals((double)800.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.record((Rate)rate, config, 1000);
        Assertions.assertEquals((double)1200.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(6500L);
        Assertions.assertEquals((double)333.0, (double)this.measure((Measurable)rate, config), (double)1.0);
        this.record((Rate)rate, config, 1000);
        Assertions.assertEquals((double)444.0, (double)this.measure((Measurable)rate, config), (double)1.0);
        this.time.sleep(1500L);
        Assertions.assertEquals((double)329.6703296703297, (double)this.measure((Measurable)rate, config), (double)1.0);
        this.record((Rate)rate, config, 1000);
        Assertions.assertEquals((double)439.5604395604396, (double)this.measure((Measurable)rate, config), (double)1.0);
    }

    private void record(Rate rate, MetricConfig config, int value) {
        rate.record(config, (double)value, this.time.milliseconds());
    }

    private Double measure(Measurable rate, MetricConfig config) {
        return rate.measure(config, this.time.milliseconds());
    }

    @Test
    public void testMetricInstances() {
        MetricName n1 = this.metrics.metricInstance(SampleMetrics.METRIC1, new String[]{"key1", "value1", "key2", "value2"});
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("key1", "value1");
        tags.put("key2", "value2");
        MetricName n2 = this.metrics.metricInstance(SampleMetrics.METRIC2, tags);
        Assertions.assertEquals((Object)n1, (Object)n2, (String)"metric names created in two different ways should be equal");
        try {
            this.metrics.metricInstance(SampleMetrics.METRIC1, new String[]{"key1"});
            Assertions.fail((String)"Creating MetricName with an odd number of keyValue should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        HashMap<String, String> parentTagsWithValues = new HashMap<String, String>();
        parentTagsWithValues.put("parent-tag", "parent-tag-value");
        HashMap<String, String> childTagsWithValues = new HashMap<String, String>();
        childTagsWithValues.put("child-tag", "child-tag-value");
        try (Metrics inherited = new Metrics(new MetricConfig().tags(parentTagsWithValues), Collections.singletonList(new JmxReporter()), (Time)this.time, true);){
            MetricName inheritedMetric = inherited.metricInstance(SampleMetrics.METRIC_WITH_INHERITED_TAGS, childTagsWithValues);
            Map filledOutTags = inheritedMetric.tags();
            Assertions.assertEquals(filledOutTags.get("parent-tag"), (Object)"parent-tag-value", (String)"parent-tag should be set properly");
            Assertions.assertEquals(filledOutTags.get("child-tag"), (Object)"child-tag-value", (String)"child-tag should be set properly");
            try {
                inherited.metricInstance(SampleMetrics.METRIC_WITH_INHERITED_TAGS, parentTagsWithValues);
                Assertions.fail((String)"Creating MetricName should fail if the child metrics are not defined at runtime");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                HashMap<String, String> runtimeTags = new HashMap<String, String>();
                runtimeTags.put("child-tag", "child-tag-value");
                runtimeTags.put("tag-not-in-template", "unexpected-value");
                inherited.metricInstance(SampleMetrics.METRIC_WITH_INHERITED_TAGS, runtimeTags);
                Assertions.fail((String)"Creating MetricName should fail if there is a tag at runtime that is not in the template");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConcurrentReadUpdate() {
        Random random = new Random();
        ConcurrentLinkedDeque<Sensor> sensors = new ConcurrentLinkedDeque<Sensor>();
        this.metrics = new Metrics((Time)new MockTime(10L));
        SensorCreator sensorCreator = new SensorCreator(this.metrics);
        AtomicBoolean alive = new AtomicBoolean(true);
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(new ConcurrentMetricOperation(alive, "record", () -> sensors.forEach(sensor -> sensor.record((double)random.nextInt(10000)))));
        for (int i = 0; i < 10000; ++i) {
            if (sensors.size() > 5) {
                Sensor sensor = random.nextBoolean() ? (Sensor)sensors.removeFirst() : (Sensor)sensors.removeLast();
                this.metrics.removeSensor(sensor.name());
            }
            StatType statType = StatType.forId(random.nextInt(StatType.values().length));
            sensors.add(sensorCreator.createSensor(statType, i, this.config));
            for (Sensor sensor : sensors) {
                for (KafkaMetric metric : sensor.metrics()) {
                    Assertions.assertNotNull((Object)metric.metricValue(), (String)"Invalid metric value");
                }
            }
        }
        alive.set(false);
    }

    @Test
    public void testConcurrentReadUpdateReport() {
        class LockingReporter
        implements MetricsReporter {
            final Map<MetricName, KafkaMetric> activeMetrics = new HashMap<MetricName, KafkaMetric>();

            LockingReporter() {
            }

            public synchronized void init(List<KafkaMetric> metrics) {
            }

            public synchronized void metricChange(KafkaMetric metric) {
                this.activeMetrics.put(metric.metricName(), metric);
            }

            public synchronized void metricRemoval(KafkaMetric metric) {
                this.activeMetrics.remove(metric.metricName(), metric);
            }

            public synchronized void close() {
            }

            public void configure(Map<String, ?> configs) {
            }

            synchronized void processMetrics() {
                for (KafkaMetric metric : this.activeMetrics.values()) {
                    Assertions.assertNotNull((Object)metric.metricValue(), (String)"Invalid metric value");
                }
            }
        }
        LockingReporter reporter = new LockingReporter();
        this.metrics.close();
        this.metrics = new Metrics(this.config, Collections.singletonList(reporter), (Time)new MockTime(10L), true);
        ConcurrentLinkedDeque<Sensor> sensors = new ConcurrentLinkedDeque<Sensor>();
        SensorCreator sensorCreator = new SensorCreator(this.metrics);
        Random random = new Random();
        AtomicBoolean alive = new AtomicBoolean(true);
        this.executorService = Executors.newFixedThreadPool(3);
        Future<?> writeFuture = this.executorService.submit(new ConcurrentMetricOperation(alive, "record", () -> sensors.forEach(sensor -> sensor.record((double)random.nextInt(10000)))));
        Future<?> readFuture = this.executorService.submit(new ConcurrentMetricOperation(alive, "read", () -> sensors.forEach(sensor -> sensor.metrics().forEach(metric -> Assertions.assertNotNull((Object)metric.metricValue(), (String)"Invalid metric value")))));
        Future<?> reportFuture = this.executorService.submit(new ConcurrentMetricOperation(alive, "report", reporter::processMetrics));
        for (int i = 0; i < 10000; ++i) {
            if (sensors.size() > 10) {
                Sensor sensor = random.nextBoolean() ? (Sensor)sensors.removeFirst() : (Sensor)sensors.removeLast();
                this.metrics.removeSensor(sensor.name());
            }
            StatType statType = StatType.forId(random.nextInt(StatType.values().length));
            sensors.add(sensorCreator.createSensor(statType, i, this.config));
        }
        Assertions.assertFalse((boolean)readFuture.isDone(), (String)"Read failed");
        Assertions.assertFalse((boolean)writeFuture.isDone(), (String)"Write failed");
        Assertions.assertFalse((boolean)reportFuture.isDone(), (String)"Report failed");
        alive.set(false);
    }

    @Test
    public void testWeightedAverageNoSamples() {
        SensorCreator sensorCreator = new SensorCreator(this.metrics);
        Sensor weightedAvgSensor = sensorCreator.createSensor(StatType.WEIGHTED_AVG, 0, this.config);
        this.time.sleep(30000L);
        Assertions.assertEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
    }

    @Test
    public void testWeightedAverageOneSample() {
        SensorCreator sensorCreator = new SensorCreator(this.metrics);
        Sensor weightedAvgSensor = sensorCreator.createSensor(StatType.WEIGHTED_AVG, 0, this.config);
        weightedAvgSensor.record(1.0);
        Assertions.assertEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        this.time.sleep(30000L);
        Assertions.assertEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        weightedAvgSensor.record(1.0);
        Assertions.assertNotEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        Assertions.assertTrue(((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedAverageNegativeSamples() {
        SensorCreator sensorCreator = new SensorCreator(this.metrics);
        Sensor weightedAvgSensor = sensorCreator.createSensor(StatType.WEIGHTED_AVG, 0, this.config);
        weightedAvgSensor.record(-1.0);
        this.time.sleep(30000L);
        weightedAvgSensor.record(-1.0);
        Assertions.assertNotEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        Assertions.assertTrue(((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedAverageNaNSamples() {
        SensorCreator sensorCreator = new SensorCreator(this.metrics);
        Sensor weightedAvgSensor = sensorCreator.createSensor(StatType.WEIGHTED_AVG, 0, this.config);
        weightedAvgSensor.record(Double.NaN);
        Assertions.assertEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        this.time.sleep(30000L);
        weightedAvgSensor.record(Double.NaN);
        weightedAvgSensor.record(1.0);
        Assertions.assertEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        this.time.sleep(30000L);
        weightedAvgSensor.record(1.0);
        Assertions.assertEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        this.time.sleep(30000L);
        weightedAvgSensor.record(1.0);
        Assertions.assertNotEquals((double)((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue()), (double)Double.NaN, (double)0.0);
        Assertions.assertTrue(((Double)((KafkaMetric)weightedAvgSensor.metrics().get(0)).metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedAverageStat() {
        SensorCreator sensorCreator = new SensorCreator(this.metrics);
        Sensor weightedAvgSensor = sensorCreator.createSensor(StatType.WEIGHTED_AVG, 0, new MetricConfig().samples(60));
        int maxRequestCount = 50000;
        double prevEMA = 0.0;
        for (int i = 1; i <= maxRequestCount; ++i) {
            weightedAvgSensor.record((double)i);
            this.time.sleep(30000L);
            for (KafkaMetric metric : weightedAvgSensor.metrics()) {
                double curEMA = (Double)metric.metricValue();
                Assertions.assertNotEquals((double)prevEMA, (double)curEMA, (double)0.0);
                prevEMA = curEMA;
            }
        }
    }

    public static class ConstantMeasurable
    implements Measurable {
        public double value = 0.0;

        public double measure(MetricConfig config, long now) {
            return this.value;
        }
    }

    private static class SensorCreator {
        private final Metrics metrics;

        SensorCreator(Metrics metrics) {
            this.metrics = metrics;
        }

        private Sensor createSensor(StatType statType, int index, MetricConfig metricConfig) {
            Sensor sensor = this.metrics.sensor("kafka.requests." + index, metricConfig, new Sensor[0]);
            Map<String, CallSite> tags = Collections.singletonMap("tag", "tag" + index);
            switch (statType.ordinal()) {
                case 0: {
                    sensor.add(this.metrics.metricName("test.metric.avg", "avg", tags), (MeasurableStat)new Avg());
                    break;
                }
                case 1: {
                    sensor.add(this.metrics.metricName("test.metric.total", "total", tags), (MeasurableStat)new CumulativeSum());
                    break;
                }
                case 2: {
                    sensor.add(this.metrics.metricName("test.metric.count", "count", tags), (MeasurableStat)new WindowedCount());
                    break;
                }
                case 3: {
                    sensor.add(this.metrics.metricName("test.metric.max", "max", tags), (MeasurableStat)new Max());
                    break;
                }
                case 4: {
                    sensor.add(this.metrics.metricName("test.metric.min", "min", tags), (MeasurableStat)new Min());
                    break;
                }
                case 5: {
                    sensor.add(this.metrics.metricName("test.metric.rate", "rate", tags), (MeasurableStat)new Rate());
                    break;
                }
                case 6: {
                    sensor.add(this.metrics.metricName("test.metric.simpleRate", "simpleRate", tags), (MeasurableStat)new SimpleRate());
                    break;
                }
                case 7: {
                    sensor.add(this.metrics.metricName("test.metric.sum", "sum", tags), (MeasurableStat)new WindowedSum());
                    break;
                }
                case 8: {
                    sensor.add(this.metrics.metricName("test.metric.value", "value", tags), (MeasurableStat)new Value());
                    break;
                }
                case 9: {
                    sensor.add(this.metrics.metricName("test.metric.percentiles", "percentiles", tags), (MeasurableStat)new Percentiles(100, -100.0, 100.0, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.metrics.metricName("test.median", "percentiles"), 50.0), new Percentile(this.metrics.metricName("test.perc99_9", "percentiles"), 99.9)}));
                    break;
                }
                case 10: {
                    sensor.add((CompoundStat)new Meter(this.metrics.metricName("test.metric.meter.rate", "meter", tags), this.metrics.metricName("test.metric.meter.total", "meter", tags)));
                    break;
                }
                case 11: {
                    sensor.add(this.metrics.metricName("test.metric.exponentialWeightedAvg", "exponentialWeightedAvg", tags), (MeasurableStat)new ExponentialWeightedAvg(0.7));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid stat type " + String.valueOf((Object)statType));
                }
            }
            return sensor;
        }
    }

    private static class ConcurrentMetricOperation
    implements Runnable {
        private final AtomicBoolean alive;
        private final String opName;
        private final Runnable op;

        ConcurrentMetricOperation(AtomicBoolean alive, String opName, Runnable op) {
            this.alive = alive;
            this.opName = opName;
            this.op = op;
        }

        @Override
        public void run() {
            try {
                while (this.alive.get()) {
                    this.op.run();
                }
            }
            catch (Throwable t) {
                log.error("Metric {} failed with exception", (Object)this.opName, (Object)t);
            }
        }
    }

    static enum StatType {
        AVG(0),
        TOTAL(1),
        COUNT(2),
        MAX(3),
        MIN(4),
        RATE(5),
        SIMPLE_RATE(6),
        SUM(7),
        VALUE(8),
        PERCENTILES(9),
        METER(10),
        WEIGHTED_AVG(11);

        final int id;

        private StatType(int id) {
            this.id = id;
        }

        static StatType forId(int id) {
            for (StatType statType : StatType.values()) {
                if (statType.id != id) continue;
                return statType;
            }
            return null;
        }
    }
}

