/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidatorTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidatorAccessTokenValidator;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.InvalidAlgorithmException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatorAccessTokenValidatorTest
extends AccessTokenValidatorTest {
    protected AccessTokenValidator createAccessTokenValidator(AccessTokenBuilder builder, Map<String, Boolean> claimOptions) {
        return new ValidatorAccessTokenValidator(Integer.valueOf(30), Collections.emptySet(), null, (jws, nestingContext) -> builder.jwk().getKey(), builder.scopeClaimName(), builder.subjectClaimName(), claimOptions);
    }

    protected AccessTokenValidator createAccessTokenValidatorWithAud(AccessTokenBuilder builder) {
        HashSet<String> audience = new HashSet<String>();
        if (builder.audience() != null) {
            audience.add(builder.audience());
        }
        return new ValidatorAccessTokenValidator(Integer.valueOf(30), audience, null, (jws, nestingContext) -> builder.jwk().getKey(), builder.scopeClaimName(), builder.subjectClaimName());
    }

    @Override
    protected AccessTokenValidator createAccessTokenValidator(AccessTokenBuilder builder) {
        return new ValidatorAccessTokenValidator(Integer.valueOf(30), Collections.emptySet(), null, (jws, nestingContext) -> builder.jwk().getKey(), builder.scopeClaimName(), builder.subjectClaimName());
    }

    @Test
    public void testRsaEncryptionAlgorithm() throws Exception {
        PublicJsonWebKey jwk = this.createRsaJwk();
        this.testEncryptionAlgorithm(jwk, "RS256");
    }

    @Test
    public void testEcdsaEncryptionAlgorithm() throws Exception {
        PublicJsonWebKey jwk = this.createEcJwk();
        this.testEncryptionAlgorithm(jwk, "ES256");
    }

    @Test
    public void testInvalidEncryptionAlgorithm() throws Exception {
        PublicJsonWebKey jwk = this.createRsaJwk();
        this.assertThrowsWithMessage(InvalidAlgorithmException.class, () -> this.testEncryptionAlgorithm(jwk, "fake"), "fake is an unknown, unsupported or unavailable alg algorithm");
    }

    @Test
    public void testMissingSubShouldBeValid() throws Exception {
        String subClaimName = "client_id";
        String subject = "otherSub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder().jwk(jwk).alg("RS256").addCustomClaim(subClaimName, subject).subjectClaimName(subClaimName).subject(null);
        AccessTokenValidator validator = this.createAccessTokenValidator(tokenBuilder);
        OAuthBearerToken token = validator.validate(tokenBuilder.build());
        Assertions.assertEquals((Object)subject, (Object)token.principalName());
    }

    @Test
    public void testIatNotRequiredButPresentInToken() throws Exception {
        String subject = "sub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder().jwk(jwk).alg("RS256").subject(subject);
        AccessTokenValidator validator = this.createAccessTokenValidator(tokenBuilder);
        OAuthBearerToken token = validator.validate(tokenBuilder.build());
        Assertions.assertEquals((Object)subject, (Object)token.principalName());
    }

    @Test
    public void testIatRequiredButNotPresentInToken() throws Exception {
        String subject = "sub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        HashSet<String> excludedClaims = new HashSet<String>();
        excludedClaims.add("iat");
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder(Collections.unmodifiableSet(excludedClaims)).jwk(jwk).alg("RS256").subject(subject);
        AccessTokenValidator validator = this.createAccessTokenValidator(tokenBuilder, Collections.singletonMap("iatRequired", true));
        ValidateException exception = (ValidateException)Assertions.assertThrows(ValidateException.class, () -> validator.validate(tokenBuilder.build()));
        String expectedMessage = "No Issued At (iat) claim present.";
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage));
    }

    @Test
    public void testJtiNotRequiredButPresentInToken() throws Exception {
        String subject = "sub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder().jwtId("jti-uuid").jwk(jwk).alg("RS256").subject(subject);
        AccessTokenValidator validator = this.createAccessTokenValidator(tokenBuilder);
        OAuthBearerToken token = validator.validate(tokenBuilder.build());
        Assertions.assertEquals((Object)subject, (Object)token.principalName());
    }

    @Test
    public void testJtiRequiredButNotPresentInToken() throws Exception {
        String subject = "sub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder().jwk(jwk).alg("RS256").subject(subject);
        AccessTokenValidator validator = this.createAccessTokenValidator(tokenBuilder, Collections.singletonMap("jtiRequired", true));
        ValidateException exception = (ValidateException)Assertions.assertThrows(ValidateException.class, () -> validator.validate(tokenBuilder.build()));
        String expectedMessage = "The JWT ID (jti) claim is not present.";
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage));
    }

    @Test
    public void testAudNotRequiredButPresentInToken() throws Exception {
        String subject = "sub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder().jwk(jwk).alg("RS256").subject(subject);
        AccessTokenValidator validator = this.createAccessTokenValidatorWithAud(tokenBuilder);
        AccessTokenBuilder tokenBuilder2 = new AccessTokenBuilder().jwk(jwk).audience("aud").alg("RS256").subject(subject);
        OAuthBearerToken token = validator.validate(tokenBuilder2.build());
        Assertions.assertEquals((Object)subject, (Object)token.principalName());
    }

    @Test
    public void testAudRequiredButNotPresentInToken() throws Exception {
        String subject = "sub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder().jwk(jwk).audience("aud").alg("RS256").subject(subject);
        AccessTokenValidator validator = this.createAccessTokenValidatorWithAud(tokenBuilder);
        HashSet<String> excludedClaims = new HashSet<String>();
        excludedClaims.add("aud");
        AccessTokenBuilder tokenBuilder2 = new AccessTokenBuilder(excludedClaims).jwk(jwk).alg("RS256").subject(subject);
        ValidateException exception = (ValidateException)Assertions.assertThrows(ValidateException.class, () -> validator.validate(tokenBuilder2.build()));
        String expectedMessage = "No Audience (aud) claim present.";
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage));
    }

    private void testEncryptionAlgorithm(PublicJsonWebKey jwk, String alg) throws Exception {
        AccessTokenBuilder builder = new AccessTokenBuilder().jwk(jwk).alg(alg);
        AccessTokenValidator validator = this.createAccessTokenValidator(builder);
        String accessToken = builder.build();
        OAuthBearerToken token = validator.validate(accessToken);
        Assertions.assertEquals((Object)builder.subject(), (Object)token.principalName());
        Assertions.assertEquals((long)(builder.issuedAtSeconds() * 1000L), (Long)token.startTimeMs());
        Assertions.assertEquals((long)(builder.expirationSeconds() * 1000L), (long)token.lifetimeMs());
        Assertions.assertEquals((int)1, (int)token.scope().size());
    }
}

