/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvType;

public enum CCloudTrafficType {
    UNKNOWN(0, false),
    PL_PRIVATE_LINK_NLB(1, false),
    PL_PUBLIC_IP_NLB(2, true);

    public static final String CCLOUD_TRAFFIC_TYPE_CLIENT_CONFIG = "confluent.ccloud.traffic.type";
    private int value;
    private boolean shouldValidateTraffic;

    private CCloudTrafficType(int value, boolean shouldValidateTraffic) {
        this.value = value;
        this.shouldValidateTraffic = shouldValidateTraffic;
    }

    public boolean shouldValidateTraffic() {
        return this.shouldValidateTraffic;
    }

    public static CCloudTrafficType valueOf(ProxyTlv tlv) {
        return tlv != null ? CCloudTrafficType.valueOf(tlv.rawValue()) : null;
    }

    public ProxyTlv tlv() {
        byte[] buf = new byte[]{(byte)(ProxyTlvType.CCLOUD_TRAFFIC_TYPE.subtype().get() & 0xFF), (byte)this.value};
        return new ProxyTlv(ProxyTlvType.CCLOUD_TRAFFIC_TYPE, buf);
    }

    public static CCloudTrafficType valueOf(byte[] bytes) {
        if (bytes.length != 2) {
            throw new IllegalArgumentException("The Link Traffic type in the TLV is missing or malformed, expected 2 bytes but got " + bytes.length);
        }
        byte value = bytes[1];
        for (CCloudTrafficType type : CCloudTrafficType.values()) {
            if (type.value != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unexpected Link Traffic type " + value + " in the TLV.");
    }
}

