/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsResponse;

public class DescribeShareGroupOffsetsRequest
extends AbstractRequest {
    private final DescribeShareGroupOffsetsRequestData data;

    public DescribeShareGroupOffsetsRequest(DescribeShareGroupOffsetsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS, version);
        this.data = data;
    }

    @Override
    public DescribeShareGroupOffsetsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic> results = new ArrayList<DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic>();
        this.data.topics().forEach(topicResult -> results.add(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic().setTopicName(topicResult.topicName()).setPartitions(topicResult.partitions().stream().map(partitionData -> new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition().setPartitionIndex((int)partitionData).setErrorCode(Errors.forException(e).code())).collect(Collectors.toList()))));
        return new DescribeShareGroupOffsetsResponse(new DescribeShareGroupOffsetsResponseData().setResponses(results));
    }

    @Override
    public DescribeShareGroupOffsetsRequestData data() {
        return this.data;
    }

    public static DescribeShareGroupOffsetsRequest parse(Readable readable, short version, MessageContext context) {
        return new DescribeShareGroupOffsetsRequest(new DescribeShareGroupOffsetsRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeShareGroupOffsetsRequest> {
        private final DescribeShareGroupOffsetsRequestData data;

        public Builder(DescribeShareGroupOffsetsRequestData data) {
            this(data, false);
        }

        public Builder(DescribeShareGroupOffsetsRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public DescribeShareGroupOffsetsRequest build(short version) {
            return new DescribeShareGroupOffsetsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

