/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class HeartbeatResponse
extends AbstractResponse {
    private final HeartbeatResponseData data;

    public HeartbeatResponse(HeartbeatResponseData data) {
        super(ApiKeys.HEARTBEAT);
        this.data = data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return HeartbeatResponse.errorCounts(this.error());
    }

    @Override
    public HeartbeatResponseData data() {
        return this.data;
    }

    public static HeartbeatResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new HeartbeatResponse(new HeartbeatResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }
}

