/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ListTransactionsRequestData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListTransactionsResponse;

public class ListTransactionsRequest
extends AbstractRequest {
    private final ListTransactionsRequestData data;

    private ListTransactionsRequest(ListTransactionsRequestData data, short version) {
        super(ApiKeys.LIST_TRANSACTIONS, version);
        this.data = data;
    }

    @Override
    public ListTransactionsRequestData data() {
        return this.data;
    }

    @Override
    public ListTransactionsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        ListTransactionsResponseData response = new ListTransactionsResponseData().setErrorCode(error.code()).setThrottleTimeMs(throttleTimeMs);
        return new ListTransactionsResponse(response);
    }

    public static ListTransactionsRequest parse(Readable readable, short version, MessageContext context) {
        return new ListTransactionsRequest(new ListTransactionsRequestData(readable, version, context), version);
    }

    @Override
    public String toString(boolean verbose) {
        return this.data.toString();
    }

    public static class Builder
    extends AbstractRequest.Builder<ListTransactionsRequest> {
        public final ListTransactionsRequestData data;

        public Builder(ListTransactionsRequestData data) {
            super(ApiKeys.LIST_TRANSACTIONS);
            this.data = data;
        }

        @Override
        public ListTransactionsRequest build(short version) {
            if (this.data.durationFilter() >= 0L && version < 1) {
                throw new UnsupportedVersionException("Duration filter can be set only when using API version 1 or higher. If client is connected to an older broker, do not specify duration filter or set duration filter to -1.");
            }
            return new ListTransactionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

