/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.ReportClusterLinkStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReportClusterLinkStatusResponse
extends AbstractResponse {
    private final ReportClusterLinkStatusResponseData data;

    public ReportClusterLinkStatusResponse(ReportClusterLinkStatusResponseData data) {
        super(ApiKeys.REPORT_CLUSTER_LINK_STATUS);
        this.data = data;
    }

    public ReportClusterLinkStatusResponse(int throttleTimeMs, Throwable e) {
        super(ApiKeys.REPORT_CLUSTER_LINK_STATUS);
        this.data = new ReportClusterLinkStatusResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage());
    }

    public static ReportClusterLinkStatusResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ReportClusterLinkStatusResponse(new ReportClusterLinkStatusResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public ReportClusterLinkStatusResponseData data() {
        return this.data;
    }

    public static enum PublishResult {
        SUCCESS,
        FAILED,
        LINK_NOT_AVAILABLE;

    }
}

