/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestFutureTest {
    @Test
    public void testBasicCompletion() {
        RequestFuture future = new RequestFuture();
        String value = "foo";
        future.complete((Object)value);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)value, (Object)future.value());
    }

    @Test
    public void testBasicFailure() {
        RequestFuture future = new RequestFuture();
        RuntimeException exception = new RuntimeException();
        future.raise(exception);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)exception, (Object)future.exception());
    }

    @Test
    public void testVoidFuture() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertNull((Object)future.value());
    }

    @Test
    public void testRuntimeExceptionInComplete() {
        RequestFuture future = new RequestFuture();
        Assertions.assertThrows(IllegalArgumentException.class, () -> future.complete((Object)new RuntimeException()));
    }

    @Test
    public void invokeCompleteAfterAlreadyComplete() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        Assertions.assertThrows(IllegalStateException.class, () -> future.complete(null));
    }

    @Test
    public void invokeCompleteAfterAlreadyFailed() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        Assertions.assertThrows(IllegalStateException.class, () -> future.complete(null));
    }

    @Test
    public void invokeRaiseAfterAlreadyFailed() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        Assertions.assertThrows(IllegalStateException.class, () -> future.raise(new RuntimeException()));
    }

    @Test
    public void invokeRaiseAfterAlreadyCompleted() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        Assertions.assertThrows(IllegalStateException.class, () -> future.raise(new RuntimeException()));
    }

    @Test
    public void invokeExceptionAfterSuccess() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        Assertions.assertThrows(IllegalStateException.class, () -> ((RequestFuture)future).exception());
    }

    @Test
    public void invokeValueAfterFailure() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        Assertions.assertThrows(IllegalStateException.class, () -> ((RequestFuture)future).value());
    }

    @Test
    public void listenerInvokedIfAddedBeforeFutureCompletion() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        future.complete(null);
        RequestFutureTest.assertOnSuccessInvoked(listener);
    }

    @Test
    public void listenerInvokedIfAddedBeforeFutureFailure() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        future.raise(new RuntimeException());
        RequestFutureTest.assertOnFailureInvoked(listener);
    }

    @Test
    public void listenerInvokedIfAddedAfterFutureCompletion() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        RequestFutureTest.assertOnSuccessInvoked(listener);
    }

    @Test
    public void listenerInvokedIfAddedAfterFutureFailure() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        RequestFutureTest.assertOnFailureInvoked(listener);
    }

    @Test
    public void listenersInvokedIfAddedBeforeAndAfterFailure() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener beforeListener = new MockRequestFutureListener();
        future.addListener(beforeListener);
        future.raise(new RuntimeException());
        MockRequestFutureListener afterListener = new MockRequestFutureListener();
        future.addListener(afterListener);
        RequestFutureTest.assertOnFailureInvoked(beforeListener);
        RequestFutureTest.assertOnFailureInvoked(afterListener);
    }

    @Test
    public void listenersInvokedIfAddedBeforeAndAfterCompletion() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener beforeListener = new MockRequestFutureListener();
        future.addListener(beforeListener);
        future.complete(null);
        MockRequestFutureListener afterListener = new MockRequestFutureListener();
        future.addListener(afterListener);
        RequestFutureTest.assertOnSuccessInvoked(beforeListener);
        RequestFutureTest.assertOnSuccessInvoked(afterListener);
    }

    @Test
    public void testComposeSuccessCase() {
        RequestFuture future = new RequestFuture();
        RequestFuture composed = future.compose((RequestFutureAdapter)new RequestFutureAdapter<String, Integer>(){

            public void onSuccess(String value, RequestFuture<Integer> future) {
                future.complete((Object)value.length());
            }
        });
        future.complete((Object)"hello");
        Assertions.assertTrue((boolean)composed.isDone());
        Assertions.assertTrue((boolean)composed.succeeded());
        Assertions.assertEquals((int)5, (int)((Integer)composed.value()));
    }

    @Test
    public void testComposeFailureCase() {
        RequestFuture future = new RequestFuture();
        RequestFuture composed = future.compose((RequestFutureAdapter)new RequestFutureAdapter<String, Integer>(){

            public void onSuccess(String value, RequestFuture<Integer> future) {
                future.complete((Object)value.length());
            }
        });
        RuntimeException e = new RuntimeException();
        future.raise(e);
        Assertions.assertTrue((boolean)composed.isDone());
        Assertions.assertTrue((boolean)composed.failed());
        Assertions.assertEquals((Object)e, (Object)composed.exception());
    }

    private static <T> void assertOnSuccessInvoked(MockRequestFutureListener<T> listener) {
        Assertions.assertEquals((int)1, (int)listener.numOnSuccessCalls.get());
        Assertions.assertEquals((int)0, (int)listener.numOnFailureCalls.get());
    }

    private static <T> void assertOnFailureInvoked(MockRequestFutureListener<T> listener) {
        Assertions.assertEquals((int)0, (int)listener.numOnSuccessCalls.get());
        Assertions.assertEquals((int)1, (int)listener.numOnFailureCalls.get());
    }

    private static class MockRequestFutureListener<T>
    implements RequestFutureListener<T> {
        private final AtomicInteger numOnSuccessCalls = new AtomicInteger(0);
        private final AtomicInteger numOnFailureCalls = new AtomicInteger(0);

        private MockRequestFutureListener() {
        }

        public void onSuccess(T value) {
            this.numOnSuccessCalls.incrementAndGet();
        }

        public void onFailure(RuntimeException e) {
            this.numOnFailureCalls.incrementAndGet();
        }
    }
}

