/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RemoteLogInputStream;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.ParameterDeclarations;

@Disabled
public class RemoteLogInputStreamTest {
    @ParameterizedTest
    @ArgumentsSource(value=RemoteLogInputStreamArgsProvider.class)
    public void testSimpleBatchIteration(Args args) throws IOException {
        byte magic = args.magic;
        Compression compression = args.compression;
        if (compression.type() == CompressionType.ZSTD && magic < 2) {
            return;
        }
        SimpleRecord firstBatchRecord = new SimpleRecord(3241324L, "a".getBytes(), "foo".getBytes());
        SimpleRecord secondBatchRecord = new SimpleRecord(234280L, "b".getBytes(), "bar".getBytes());
        File file = TestUtils.tempFile();
        try (FileRecords fileRecords = FileRecords.open((File)file);){
            fileRecords.append(MemoryRecords.withRecords((byte)magic, (long)0L, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{firstBatchRecord}));
            fileRecords.append(MemoryRecords.withRecords((byte)magic, (long)1L, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{secondBatchRecord}));
            fileRecords.flush();
        }
        try (FileInputStream is = new FileInputStream(file);){
            RemoteLogInputStream logInputStream = new RemoteLogInputStream((InputStream)is);
            RecordBatch firstBatch = logInputStream.nextBatch();
            this.assertGenericRecordBatchData(args, firstBatch, 0L, 3241324L, firstBatchRecord);
            this.assertNoProducerData(firstBatch);
            RecordBatch secondBatch = logInputStream.nextBatch();
            this.assertGenericRecordBatchData(args, secondBatch, 1L, 234280L, secondBatchRecord);
            this.assertNoProducerData(secondBatch);
            Assertions.assertNull((Object)logInputStream.nextBatch());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=RemoteLogInputStreamArgsProvider.class)
    public void testBatchIterationWithMultipleRecordsPerBatch(Args args) throws IOException {
        byte magic = args.magic;
        Compression compression = args.compression;
        if (magic < 2 && compression.type() == CompressionType.NONE) {
            return;
        }
        if (compression.type() == CompressionType.ZSTD && magic < 2) {
            return;
        }
        SimpleRecord[] firstBatchRecords = new SimpleRecord[]{new SimpleRecord(3241324L, "a".getBytes(), "1".getBytes()), new SimpleRecord(234280L, "b".getBytes(), "2".getBytes())};
        SimpleRecord[] secondBatchRecords = new SimpleRecord[]{new SimpleRecord(238423489L, "c".getBytes(), "3".getBytes()), new SimpleRecord(897839L, null, "4".getBytes()), new SimpleRecord(8234020L, "e".getBytes(), null)};
        File file = TestUtils.tempFile();
        try (FileRecords fileRecords = FileRecords.open((File)file);){
            fileRecords.append(MemoryRecords.withRecords((byte)magic, (long)0L, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])firstBatchRecords));
            fileRecords.append(MemoryRecords.withRecords((byte)magic, (long)1L, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])secondBatchRecords));
            fileRecords.flush();
        }
        try (FileInputStream is = new FileInputStream(file);){
            RemoteLogInputStream logInputStream = new RemoteLogInputStream((InputStream)is);
            RecordBatch firstBatch = logInputStream.nextBatch();
            this.assertNoProducerData(firstBatch);
            this.assertGenericRecordBatchData(args, firstBatch, 0L, 3241324L, firstBatchRecords);
            RecordBatch secondBatch = logInputStream.nextBatch();
            this.assertNoProducerData(secondBatch);
            this.assertGenericRecordBatchData(args, secondBatch, 1L, 238423489L, secondBatchRecords);
            Assertions.assertNull((Object)logInputStream.nextBatch());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=RemoteLogInputStreamArgsProvider.class)
    public void testBatchIterationV2(Args args) throws IOException {
        byte magic = args.magic;
        Compression compression = args.compression;
        if (magic != 2) {
            return;
        }
        long producerId = 83843L;
        short producerEpoch = 15;
        int baseSequence = 234;
        int partitionLeaderEpoch = 9832;
        Header[] headers = new Header[]{new RecordHeader("header-key", "header-value".getBytes(StandardCharsets.UTF_8))};
        SimpleRecord[] firstBatchRecords = new SimpleRecord[]{new SimpleRecord(3241324L, "a".getBytes(), "1".getBytes()), new SimpleRecord(234280L, "b".getBytes(), "2".getBytes(), headers)};
        SimpleRecord[] secondBatchRecords = new SimpleRecord[]{new SimpleRecord(238423489L, "c".getBytes(), "3".getBytes()), new SimpleRecord(897839L, null, "4".getBytes()), new SimpleRecord(8234020L, "e".getBytes(), null)};
        File file = TestUtils.tempFile();
        try (FileRecords fileRecords = FileRecords.open((File)file);){
            fileRecords.append(MemoryRecords.withIdempotentRecords((byte)magic, (long)15L, (Compression)compression, (long)producerId, (short)producerEpoch, (int)baseSequence, (int)partitionLeaderEpoch, (SimpleRecord[])firstBatchRecords));
            fileRecords.append(MemoryRecords.withTransactionalRecords((byte)magic, (long)27L, (Compression)compression, (long)producerId, (short)producerEpoch, (int)(baseSequence + firstBatchRecords.length), (int)partitionLeaderEpoch, (SimpleRecord[])secondBatchRecords));
            fileRecords.flush();
        }
        try (FileInputStream is = new FileInputStream(file);){
            RemoteLogInputStream logInputStream = new RemoteLogInputStream((InputStream)is);
            RecordBatch firstBatch = logInputStream.nextBatch();
            this.assertProducerData(firstBatch, producerId, producerEpoch, baseSequence, false, firstBatchRecords);
            this.assertGenericRecordBatchData(args, firstBatch, 15L, 3241324L, firstBatchRecords);
            Assertions.assertEquals((int)partitionLeaderEpoch, (int)firstBatch.partitionLeaderEpoch());
            RecordBatch secondBatch = logInputStream.nextBatch();
            this.assertProducerData(secondBatch, producerId, producerEpoch, baseSequence + firstBatchRecords.length, true, secondBatchRecords);
            this.assertGenericRecordBatchData(args, secondBatch, 27L, 238423489L, secondBatchRecords);
            Assertions.assertEquals((int)partitionLeaderEpoch, (int)secondBatch.partitionLeaderEpoch());
            Assertions.assertNull((Object)logInputStream.nextBatch());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=RemoteLogInputStreamArgsProvider.class)
    public void testBatchIterationIncompleteBatch(Args args) throws IOException {
        byte magic = args.magic;
        Compression compression = args.compression;
        if (compression.type() == CompressionType.ZSTD && magic < 2) {
            return;
        }
        try (FileRecords fileRecords = FileRecords.open((File)TestUtils.tempFile());){
            SimpleRecord firstBatchRecord = new SimpleRecord(100L, "foo".getBytes());
            SimpleRecord secondBatchRecord = new SimpleRecord(200L, "bar".getBytes());
            fileRecords.append(MemoryRecords.withRecords((byte)magic, (long)0L, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{firstBatchRecord}));
            fileRecords.append(MemoryRecords.withRecords((byte)magic, (long)1L, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{secondBatchRecord}));
            fileRecords.flush();
            fileRecords.truncateTo(fileRecords.sizeInBytes() - 13);
            FileLogInputStream logInputStream = new FileLogInputStream(fileRecords, 0, fileRecords.sizeInBytes());
            FileLogInputStream.FileChannelRecordBatch firstBatch = logInputStream.nextBatch();
            this.assertNoProducerData((RecordBatch)firstBatch);
            this.assertGenericRecordBatchData(args, (RecordBatch)firstBatch, 0L, 100L, firstBatchRecord);
            Assertions.assertNull((Object)logInputStream.nextBatch());
        }
    }

    private void assertProducerData(RecordBatch batch, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, SimpleRecord ... records) {
        Assertions.assertEquals((long)producerId, (long)batch.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)batch.producerEpoch());
        Assertions.assertEquals((int)baseSequence, (int)batch.baseSequence());
        Assertions.assertEquals((int)(baseSequence + records.length - 1), (int)batch.lastSequence());
        Assertions.assertEquals((Object)isTransactional, (Object)batch.isTransactional());
    }

    private void assertNoProducerData(RecordBatch batch) {
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
        Assertions.assertEquals((int)-1, (int)batch.lastSequence());
        Assertions.assertFalse((boolean)batch.isTransactional());
    }

    private void assertGenericRecordBatchData(Args args, RecordBatch batch, long baseOffset, long maxTimestamp, SimpleRecord ... records) {
        byte magic = args.magic;
        Compression compression = args.compression;
        Assertions.assertEquals((byte)magic, (byte)batch.magic());
        Assertions.assertEquals((Object)compression.type(), (Object)batch.compressionType());
        if (magic == 0) {
            Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
        } else {
            Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
            Assertions.assertEquals((long)maxTimestamp, (long)batch.maxTimestamp());
        }
        Assertions.assertEquals((long)(baseOffset + (long)records.length - 1L), (long)batch.lastOffset());
        if (magic >= 2) {
            Assertions.assertEquals((Integer)records.length, (Integer)batch.countOrNull());
        }
        Assertions.assertEquals((long)baseOffset, (long)batch.baseOffset());
        Assertions.assertTrue((boolean)batch.isValid());
        List batchRecords = TestUtils.toList(batch);
        for (int i = 0; i < records.length; ++i) {
            Assertions.assertEquals((long)(baseOffset + (long)i), (long)((Record)batchRecords.get(i)).offset());
            Assertions.assertEquals((Object)records[i].key(), (Object)((Record)batchRecords.get(i)).key());
            Assertions.assertEquals((Object)records[i].value(), (Object)((Record)batchRecords.get(i)).value());
            Assertions.assertArrayEquals((Object[])records[i].headers(), (Object[])((Record)batchRecords.get(i)).headers());
            if (magic == 0) {
                Assertions.assertEquals((long)-1L, (long)((Record)batchRecords.get(i)).timestamp());
                continue;
            }
            Assertions.assertEquals((long)records[i].timestamp(), (long)((Record)batchRecords.get(i)).timestamp());
        }
    }

    private static class Args {
        private final byte magic;
        private final Compression compression;

        public Args(byte magic, Compression compression) {
            this.magic = magic;
            this.compression = compression;
        }

        public String toString() {
            return "Args{magic=" + this.magic + ", compression=" + String.valueOf(this.compression) + "}";
        }
    }

    private static class RemoteLogInputStreamArgsProvider
    implements ArgumentsProvider {
        private RemoteLogInputStreamArgsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ParameterDeclarations parameterDeclarations, ExtensionContext context) {
            ArrayList<Arguments> values = new ArrayList<Arguments>();
            for (byte magic : Arrays.asList((byte)0, (byte)1, (byte)2)) {
                for (CompressionType type : CompressionType.values()) {
                    values.add(Arguments.of((Object[])new Object[]{new Args(magic, Compression.of((CompressionType)type).build())}));
                }
            }
            return values.stream();
        }
    }
}

