/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.utils.LogAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RequestLogFilterTest {
    @Test
    public void testMatchNone() {
        RequestContext ctx = (RequestContext)Mockito.mock(RequestContext.class);
        Assertions.assertEquals((Object)LogAction.NOT_LOGGED, (Object)RequestLogFilter.MATCH_NONE.processRequest(ctx, 1L));
        Assertions.assertFalse((boolean)RequestLogFilter.MATCH_NONE.shouldLogRequest(ctx, 1L));
    }

    @Test
    public void testProcessRequestOverride() {
        final RequestContext ctx1 = (RequestContext)Mockito.mock(RequestContext.class);
        RequestContext ctx2 = (RequestContext)Mockito.mock(RequestContext.class);
        RequestLogFilter filter = new RequestLogFilter(){
            final /* synthetic */ RequestLogFilterTest this$0;
            {
                this.this$0 = this$0;
            }

            public LogAction processRequest(RequestContext ctx, long currentTimeNanos) {
                if (ctx.equals(ctx1)) {
                    return LogAction.LOGGED;
                }
                return LogAction.NOT_LOGGED;
            }
        };
        Assertions.assertTrue((boolean)filter.shouldLogRequest(ctx1, 1L));
        Assertions.assertFalse((boolean)filter.shouldLogRequest(ctx2, 1L));
    }

    @Test
    public void testShouldLogOverride() {
        final RequestContext ctx1 = (RequestContext)Mockito.mock(RequestContext.class);
        RequestContext ctx2 = (RequestContext)Mockito.mock(RequestContext.class);
        RequestLogFilter filter = new RequestLogFilter(){
            final /* synthetic */ RequestLogFilterTest this$0;
            {
                this.this$0 = this$0;
            }

            public boolean shouldLogRequest(RequestContext ctx, long currentTimeNanos) {
                return ctx.equals(ctx1);
            }
        };
        Assertions.assertEquals((Object)LogAction.LOGGED, (Object)filter.processRequest(ctx1, 1L));
        Assertions.assertEquals((Object)LogAction.NOT_LOGGED, (Object)filter.processRequest(ctx2, 1L));
    }
}

