/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.ClientCredentialsJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.DefaultJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.FileJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DefaultJwtRetrieverTest
extends OAuthBearerTest {
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }

    @Test
    public void testConfigureRefreshingFileJwtRetriever() throws Exception {
        String expected = this.createJwt("jdoe");
        String file = TestUtils.tempFile(expected).toURI().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", file);
        Map<String, String> configs = Collections.singletonMap("sasl.oauthbearer.token.endpoint.url", file);
        try (DefaultJwtRetriever jwtRetriever = new DefaultJwtRetriever();){
            jwtRetriever.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries());
            Assertions.assertEquals((Object)expected, (Object)jwtRetriever.retrieve());
        }
    }

    @Test
    public void testConfigureRefreshingFileJwtRetrieverWithInvalidDirectory() throws IOException {
        String file = new File("/tmp/this-directory-does-not-exist/foo.json").toURI().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", file);
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", file);
        try (DefaultJwtRetriever jwtRetriever = new DefaultJwtRetriever();){
            this.assertThrowsWithMessage(ConfigException.class, () -> this.lambda$testConfigureRefreshingFileJwtRetrieverWithInvalidDirectory$0((JwtRetriever)jwtRetriever, configs), "that doesn't exist");
        }
    }

    @Test
    public void testSaslOauthbearerTokenEndpointUrlIsNotAllowed() throws Exception {
        String file = TestUtils.tempFile("test data").toURI().toString();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", file);
        try (DefaultJwtRetriever jwtRetriever = new DefaultJwtRetriever();){
            this.assertThrowsWithMessage(ConfigException.class, () -> this.lambda$testSaslOauthbearerTokenEndpointUrlIsNotAllowed$0((JwtRetriever)jwtRetriever, configs), "org.apache.kafka.sasl.oauthbearer.allowed.urls");
        }
    }

    @Test
    public void testConfigureWithAccessTokenFile() throws Exception {
        String expected = this.createJwt("jdoe");
        String file = TestUtils.tempFile(expected).toURI().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", file);
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", file);
        try (DefaultJwtRetriever jwtRetriever = new DefaultJwtRetriever();){
            Assertions.assertDoesNotThrow(() -> jwtRetriever.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries()));
            Assertions.assertInstanceOf(FileJwtRetriever.class, (Object)jwtRetriever.delegate());
        }
    }

    @Test
    public void testConfigureWithAccessClientCredentials() throws Exception {
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", "http://www.example.com");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", "http://www.example.com");
        HashMap<String, String> jaasConfigs = new HashMap<String, String>();
        jaasConfigs.put("clientId", "an ID");
        jaasConfigs.put("clientSecret", "a secret");
        try (DefaultJwtRetriever jwtRetriever = new DefaultJwtRetriever();){
            Assertions.assertDoesNotThrow(() -> jwtRetriever.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(jaasConfigs)));
            Assertions.assertInstanceOf(HttpJwtRetriever.class, (Object)jwtRetriever.delegate());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"urlencodeHeaderSupplier"})
    public void testUrlencodeHeader(Map<String, Object> configs, boolean expectedValue) {
        ConfigurationUtils cu = new ConfigurationUtils(configs);
        boolean actualValue = ClientCredentialsJwtRetriever.validateUrlencodeHeader((ConfigurationUtils)cu);
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    private static Stream<Arguments> urlencodeHeaderSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.emptyMap(), false}), Arguments.of((Object[])new Object[]{Collections.singletonMap("sasl.oauthbearer.header.urlencode", null), false}), Arguments.of((Object[])new Object[]{Collections.singletonMap("sasl.oauthbearer.header.urlencode", true), true}), Arguments.of((Object[])new Object[]{Collections.singletonMap("sasl.oauthbearer.header.urlencode", false), false}));
    }

    private /* synthetic */ void lambda$testSaslOauthbearerTokenEndpointUrlIsNotAllowed$0(JwtRetriever jwtRetriever, Map configs) throws Throwable {
        jwtRetriever.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries());
    }

    private /* synthetic */ void lambda$testConfigureRefreshingFileJwtRetrieverWithInvalidDirectory$0(JwtRetriever jwtRetriever, Map configs) throws Throwable {
        jwtRetriever.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries());
    }
}

