/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.link;

import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.link.ClusterLinkMetricsUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterLinkMetricsUtilsTest {
    protected Metrics metrics;

    @BeforeEach
    public void setUp() {
        this.metrics = new Metrics();
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testActiveLinkCountMetric() {
        UUID linkId = UUID.randomUUID();
        String legacyLinkId = linkId.toString();
        Sensor sensor = ClusterLinkMetricsUtils.createActiveLinkCountSensor((Metrics)this.metrics, (UUID)linkId, (String)"destination", Collections.emptyMap(), (String)"lkc", (long)30L);
        Assertions.assertTrue((boolean)sensor.name().contains(legacyLinkId), (String)("Legacy link id not in sensor name: " + sensor.name()));
        Optional<MetricName> countMetric = this.metrics.metrics().keySet().stream().filter(m -> m.name().equals("active-link-count")).findFirst();
        Assertions.assertTrue((boolean)countMetric.isPresent());
        Assertions.assertEquals((Object)legacyLinkId, countMetric.get().tags().get("link-id"));
    }
}

