/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import io.netty.channel.EventLoopGroup;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.SelectablePlugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.netty.NettyHttp2Selector;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;

public class NettyHttp2SelectablePlugin
implements SelectablePlugin {
    private static volatile int numThreads = 2;
    private static final AtomicReference<EventLoopGroup> eventLoopGroup = new AtomicReference();

    public static void numThreads(int numThreads) {
        NettyHttp2SelectablePlugin.numThreads = numThreads;
    }

    public static void eventLoopGroup(EventLoopGroup eventLoopGroup) {
        if (!NettyHttp2SelectablePlugin.eventLoopGroup.compareAndSet(null, eventLoopGroup)) {
            throw new IllegalStateException("Event loop to use for Selector is already set.");
        }
    }

    @Override
    public Selectable newSelectable(Metrics metrics, String metricGrpPrefix, LogContext logContext) {
        if (eventLoopGroup.get() == null) {
            eventLoopGroup.set(EventLoopGroupHolder.eventLoopGroup);
        }
        return new NettyHttp2Selector(eventLoopGroup.get(), null, logContext);
    }

    private static class EventLoopGroupHolder {
        static final EventLoopGroup eventLoopGroup = Utils.createEventLoopGroup(numThreads, "selector");

        private EventLoopGroupHolder() {
        }
    }
}

