/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AlterShareGroupOffsetsRequestData
implements ApiMessage {
    String groupId;
    AlterShareGroupOffsetsRequestTopicCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("topics", new CompactArrayOf(AlterShareGroupOffsetsRequestTopic.SCHEMA_0), "The topics to alter offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterShareGroupOffsetsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterShareGroupOffsetsRequestData() {
        this.groupId = "";
        this.topics = new AlterShareGroupOffsetsRequestTopicCollection(0);
    }

    @Override
    public short apiKey() {
        return 91;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _context.read(EntityType.GROUP_ID, _readable.readString(length));
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        AlterShareGroupOffsetsRequestTopicCollection newCollection = new AlterShareGroupOffsetsRequestTopicCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterShareGroupOffsetsRequestTopic(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            AlterShareGroupOffsetsRequestTopic topicsElement = (AlterShareGroupOffsetsRequestTopic)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _context.write(EntityType.GROUP_ID, this.groupId).getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (AlterShareGroupOffsetsRequestTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterShareGroupOffsetsRequestData)) {
            return false;
        }
        AlterShareGroupOffsetsRequestData other = (AlterShareGroupOffsetsRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public AlterShareGroupOffsetsRequestData duplicate() {
        AlterShareGroupOffsetsRequestData _duplicate = new AlterShareGroupOffsetsRequestData();
        _duplicate.groupId = this.groupId;
        AlterShareGroupOffsetsRequestTopicCollection newTopics = new AlterShareGroupOffsetsRequestTopicCollection(this.topics.size());
        for (AlterShareGroupOffsetsRequestTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "AlterShareGroupOffsetsRequestData(groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public AlterShareGroupOffsetsRequestTopicCollection topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterShareGroupOffsetsRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public AlterShareGroupOffsetsRequestData setTopics(AlterShareGroupOffsetsRequestTopicCollection v) {
        this.topics = v;
        return this;
    }

    public static class AlterShareGroupOffsetsRequestTopicCollection
    extends ImplicitLinkedHashMultiCollection<AlterShareGroupOffsetsRequestTopic> {
        public AlterShareGroupOffsetsRequestTopicCollection() {
        }

        public AlterShareGroupOffsetsRequestTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterShareGroupOffsetsRequestTopicCollection(Iterator<AlterShareGroupOffsetsRequestTopic> iterator) {
            super(iterator);
        }

        @Override
        public AlterShareGroupOffsetsRequestTopic find(String topicName) {
            AlterShareGroupOffsetsRequestTopic _key = new AlterShareGroupOffsetsRequestTopic();
            _key.setTopicName(topicName);
            return this.find(_key);
        }

        @Override
        public List<AlterShareGroupOffsetsRequestTopic> findAll(String topicName) {
            AlterShareGroupOffsetsRequestTopic _key = new AlterShareGroupOffsetsRequestTopic();
            _key.setTopicName(topicName);
            return this.findAll(_key);
        }

        public AlterShareGroupOffsetsRequestTopicCollection duplicate() {
            AlterShareGroupOffsetsRequestTopicCollection _duplicate = new AlterShareGroupOffsetsRequestTopicCollection(this.size());
            for (AlterShareGroupOffsetsRequestTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AlterShareGroupOffsetsRequestTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String topicName;
        List<AlterShareGroupOffsetsRequestPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(AlterShareGroupOffsetsRequestPartition.SCHEMA_0), "Each partition to alter offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AlterShareGroupOffsetsRequestTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public AlterShareGroupOffsetsRequestTopic() {
            this.topicName = "";
            this.partitions = new ArrayList<AlterShareGroupOffsetsRequestPartition>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterShareGroupOffsetsRequestTopic");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<AlterShareGroupOffsetsRequestPartition> newCollection = new ArrayList<AlterShareGroupOffsetsRequestPartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AlterShareGroupOffsetsRequestPartition(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                AlterShareGroupOffsetsRequestPartition partitionsElement = (AlterShareGroupOffsetsRequestPartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterShareGroupOffsetsRequestTopic");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (AlterShareGroupOffsetsRequestPartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AlterShareGroupOffsetsRequestTopic)) {
                return false;
            }
            AlterShareGroupOffsetsRequestTopic other = (AlterShareGroupOffsetsRequestTopic)obj;
            return !(this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterShareGroupOffsetsRequestTopic)) {
                return false;
            }
            AlterShareGroupOffsetsRequestTopic other = (AlterShareGroupOffsetsRequestTopic)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            return hashCode;
        }

        @Override
        public AlterShareGroupOffsetsRequestTopic duplicate() {
            AlterShareGroupOffsetsRequestTopic _duplicate = new AlterShareGroupOffsetsRequestTopic();
            _duplicate.topicName = this.topicName;
            ArrayList<AlterShareGroupOffsetsRequestPartition> newPartitions = new ArrayList<AlterShareGroupOffsetsRequestPartition>(this.partitions.size());
            for (AlterShareGroupOffsetsRequestPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "AlterShareGroupOffsetsRequestTopic(topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<AlterShareGroupOffsetsRequestPartition> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterShareGroupOffsetsRequestTopic setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public AlterShareGroupOffsetsRequestTopic setPartitions(List<AlterShareGroupOffsetsRequestPartition> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class AlterShareGroupOffsetsRequestPartition
    implements Message {
        int partitionIndex;
        long startOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("start_offset", Type.INT64, "The share-partition start offset."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AlterShareGroupOffsetsRequestPartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AlterShareGroupOffsetsRequestPartition() {
            this.partitionIndex = 0;
            this.startOffset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterShareGroupOffsetsRequestPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.startOffset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.startOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterShareGroupOffsetsRequestPartition");
            }
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterShareGroupOffsetsRequestPartition)) {
                return false;
            }
            AlterShareGroupOffsetsRequestPartition other = (AlterShareGroupOffsetsRequestPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.startOffset != other.startOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.startOffset >> 32) ^ (int)this.startOffset);
            return hashCode;
        }

        @Override
        public AlterShareGroupOffsetsRequestPartition duplicate() {
            AlterShareGroupOffsetsRequestPartition _duplicate = new AlterShareGroupOffsetsRequestPartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.startOffset = this.startOffset;
            return _duplicate;
        }

        public String toString() {
            return "AlterShareGroupOffsetsRequestPartition(partitionIndex=" + this.partitionIndex + ", startOffset=" + this.startOffset + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long startOffset() {
            return this.startOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterShareGroupOffsetsRequestPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public AlterShareGroupOffsetsRequestPartition setStartOffset(long v) {
            this.startOffset = v;
            return this;
        }
    }
}

