/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.metrics.internals.ConfluentMetricsContextProvider;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.K2RequestContext;
import org.apache.kafka.common.requests.K2RequestContextImpl;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

public class RequestContext
implements AuthorizableRequestContext {
    public final RequestHeader header;
    public final String connectionId;
    public final InetAddress clientAddress;
    public final Optional<Integer> clientPort;
    public final KafkaPrincipal principal;
    public final ListenerName listenerName;
    public final SecurityProtocol securityProtocol;
    public final ClientInformation clientInformation;
    public final PathAwareSniHostName sniHostName;
    public final boolean fromPrivilegedListener;
    public final Optional<KafkaPrincipalSerde> principalSerde;
    public final AuthenticationContext authenticationContext;
    private long requestId;
    public ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker;
    private final boolean isProxyModeLocal;
    private final BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2;
    private Optional<KafkaPrincipal> clusterLinkTenantPrincipal = Optional.empty();
    private Set<String> allBrokerZones = null;
    private Map<String, String> brokerToGatewayZoneMapping = null;
    public final boolean shouldLogForConnection;
    public final K2RequestContext k2RequestContext = new K2RequestContextImpl();
    public final ConfluentMetricsContextProvider confluentMetricsContextProvider;

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener) {
        this(header, connectionId, clientAddress, Optional.empty(), principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener, Optional.empty(), null, false, null, false, ConfluentMetricsContextProvider.INSTANCE);
    }

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, Optional<Integer> clientPort, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde) {
        this(header, connectionId, clientAddress, clientPort, principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener, principalSerde, null, false, null, false, ConfluentMetricsContextProvider.INSTANCE);
    }

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, Optional<Integer> clientPort, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, boolean isProxyModeLocal, BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2, boolean shouldLogForConnection) {
        this(header, connectionId, clientAddress, clientPort, principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener, principalSerde, null, isProxyModeLocal, fqdnPropertiesFromPpv2, shouldLogForConnection, ConfluentMetricsContextProvider.INSTANCE);
    }

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, Optional<Integer> clientPort, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, boolean isProxyModeLocal, BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2, boolean shouldLogForConnection, ConfluentMetricsContextProvider confluentMetricsContextProvider) {
        this.header = header;
        this.connectionId = connectionId;
        this.clientAddress = clientAddress;
        this.clientPort = clientPort;
        this.principal = principal;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.clientInformation = clientInformation;
        this.sniHostName = sniHostName;
        this.fromPrivilegedListener = fromPrivilegedListener;
        this.principalSerde = principalSerde;
        this.authenticationContext = authenticationContext;
        this.isProxyModeLocal = isProxyModeLocal;
        this.fqdnPropertiesFromPpv2 = fqdnPropertiesFromPpv2;
        this.shouldLogForConnection = shouldLogForConnection;
        this.confluentMetricsContextProvider = confluentMetricsContextProvider;
    }

    public RequestContext(RequestHeader header, String connectionId, Long requestId, InetAddress clientAddress, Optional<Integer> clientPort, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker, boolean isProxyModeLocal, BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2, boolean shouldLogForConnection, ConfluentMetricsContextProvider confluentMetricsContextProvider) {
        this(header, connectionId, clientAddress, clientPort, principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener, principalSerde, authenticationContext, isProxyModeLocal, fqdnPropertiesFromPpv2, shouldLogForConnection, confluentMetricsContextProvider);
        this.requestId = requestId;
        this.produceConsumeAuditLogTracker = produceConsumeAuditLogTracker;
    }

    public KafkaPrincipal getPrincipal() {
        return this.principal;
    }

    public void maybeEnableClusterLinkTenant(Function<String, KafkaPrincipal> tenantPrincipalBuilder) {
        if (this.header.clusterLinkTenant().isPresent()) {
            this.clusterLinkTenantPrincipal = Optional.of(tenantPrincipalBuilder.apply(this.header.clusterLinkTenant().get()));
        }
    }

    public KafkaPrincipal controllerRequestPrincipal() {
        return this.clusterLinkTenantPrincipal.orElse(this.principal);
    }

    public KafkaPrincipal quotaPrincipal() {
        return this.clusterLinkTenantPrincipal.orElse(this.principal);
    }

    public Optional<KafkaPrincipalSerde> getPrincipalSerde() {
        return this.principalSerde;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public RequestAndSize parseRequest(Readable readable) {
        if (this.isUnsupportedApiVersionsRequest()) {
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), 0, this.header.apiVersion());
            return new RequestAndSize(apiVersionsRequest, 0);
        }
        ApiKeys apiKey = this.header.apiKey();
        try {
            short apiVersion = this.header.apiVersion();
            return AbstractRequest.parseRequest(apiKey, apiVersion, readable, MessageContext.IDENTITY);
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error getting request for apiKey: " + String.valueOf((Object)apiKey) + ", apiVersion: " + this.header.apiVersion() + ", connectionId: " + this.connectionId + ", listenerName: " + String.valueOf(this.listenerName) + ", principal: " + String.valueOf(this.principal), ex);
        }
    }

    public RequestAndSize parseRequest(ByteBuffer buffer) {
        return this.parseRequest(new ByteBufferAccessor(buffer));
    }

    public boolean shouldIntercept() {
        return false;
    }

    public AbstractResponse intercept(AbstractRequest request, int throttleTimeMs) {
        throw new UnsupportedOperationException();
    }

    public ResponseSend buildResponseSend(AbstractResponse body) {
        return new ResponseSend(body.toSend(this.header.toResponseHeader(), this.apiVersion()), body);
    }

    public ByteBuffer buildResponseEnvelopePayload(AbstractResponse body) {
        return body.serializeWithHeader(this.header.toResponseHeader(), this.apiVersion());
    }

    private boolean isUnsupportedApiVersionsRequest() {
        return this.header.apiKey() == ApiKeys.API_VERSIONS && !this.header.isApiVersionSupported();
    }

    public short apiVersion() {
        if (this.isUnsupportedApiVersionsRequest()) {
            return 0;
        }
        return this.header.apiVersion();
    }

    public String connectionId() {
        return this.connectionId;
    }

    public AbstractResponse parsedResponse(AbstractResponse response, short version) {
        return response;
    }

    public boolean transformed() {
        return false;
    }

    @Override
    public String listenerName() {
        return this.listenerName.value();
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public InetAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    public boolean isProxyModeLocal() {
        return this.isProxyModeLocal;
    }

    @Override
    public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2() {
        return this.fqdnPropertiesFromPpv2;
    }

    @Override
    public int requestType() {
        return this.header.apiKey().id;
    }

    @Override
    public int requestVersion() {
        return this.header.apiVersion();
    }

    @Override
    public String clientId() {
        return this.header.clientId();
    }

    @Override
    public int correlationId() {
        return this.header.correlationId();
    }

    public PathAwareSniHostName sniHostName() {
        return this.sniHostName;
    }

    @Override
    public Optional<String> tenantPrefix() {
        return Optional.empty();
    }

    public ApiKeys apiKey() {
        return this.header.apiKey();
    }

    @Override
    public long sessionId() {
        return this.authenticationContext != null ? this.authenticationContext.sessionId() : -1L;
    }

    public synchronized void setAllBrokerZones(Set<String> allBrokerZones) {
        this.allBrokerZones = Set.copyOf(allBrokerZones);
    }

    public synchronized Set<String> allBrokerZones() {
        return this.allBrokerZones;
    }

    public synchronized void setBrokerToGatewayZoneMapping(Map<String, String> brokerToGatewayZoneMapping) {
        this.brokerToGatewayZoneMapping = Map.copyOf(brokerToGatewayZoneMapping);
    }

    public synchronized Map<String, String> brokerToGatewayZoneMapping() {
        return this.brokerToGatewayZoneMapping;
    }

    public boolean isPpv2EndpointSchemeEnabled() {
        return false;
    }

    public boolean isPpv2EndpointSchemeMapBrokerToGatewayZoneEnabled() {
        return false;
    }

    @Override
    public long kafkaRequestId() {
        return this.requestId;
    }

    public String toString() {
        String tenantPrefixString = this.tenantPrefix().map(prefix -> ", tenantPrefix=" + prefix).orElse("");
        return "RequestContext(header=" + String.valueOf(this.header) + ", connectionId='" + this.connectionId + "', clientAddress=" + String.valueOf(this.clientAddress) + ", principal=" + String.valueOf(this.principal) + ", listenerName=" + String.valueOf(this.listenerName) + ", securityProtocol=" + String.valueOf((Object)this.securityProtocol) + ", clientInformation=" + String.valueOf(this.clientInformation) + ", fromPrivilegedListener=" + this.fromPrivilegedListener + ", principalSerde=" + String.valueOf(this.principalSerde) + tenantPrefixString + ")";
    }

    public static class ResponseSend {
        private final Send send;
        private final AbstractResponse transformedResponse;
        private final List<Runnable> delayedActions;

        public ResponseSend(Send send, AbstractResponse transformedResponse) {
            this(send, transformedResponse, Collections.emptyList());
        }

        public ResponseSend(Send send, AbstractResponse transformedResponse, List<Runnable> delayedActions) {
            this.send = send;
            this.transformedResponse = transformedResponse;
            this.delayedActions = delayedActions;
        }

        public Send getSend() {
            return this.send;
        }

        public AbstractResponse getTransformedResponse() {
            return this.transformedResponse;
        }

        public List<Runnable> getDelayedActions() {
            return this.delayedActions;
        }

        public void addDelayedAction(Runnable action) {
            this.delayedActions.add(action);
        }
    }
}

