/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.ByteBufReceive;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteBufReceiveMultipleRequestBufferTest {
    private static final int MAX_RECEIVE_SIZE = 0x100000;
    private static final int REQUEST_SIZE_BYTES = 4;
    private static final String CLIENT_ID = "test_client_id";
    private static final short API_VERSION = 4;
    private static final ApiVersionsRequest API_VERSIONS_REQUEST = new ApiVersionsRequest.Builder().build((short)4);
    private static final MetadataRequest METADATA_REQUEST = new MetadataRequest.Builder(new MetadataRequestData().setTopics(List.of()).setAllowAutoTopicCreation(true)).build((short)4);
    private static Send apiVersionRequestSend;
    private static Send metadataRequestSend;
    private static ByteBuf serializedRequests;
    private ByteBufReceive receiveBuf;

    @BeforeAll
    public static void beforeAll() {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.API_VERSIONS, 4, CLIENT_ID, 100);
        apiVersionRequestSend = API_VERSIONS_REQUEST.toSend(requestHeader);
        requestHeader = new RequestHeader(ApiKeys.METADATA, 4, CLIENT_ID, 102);
        metadataRequestSend = METADATA_REQUEST.toSend(requestHeader);
    }

    @BeforeEach
    public void beforeEach() throws IOException {
        ByteBufferChannel channel = new ByteBufferChannel(apiVersionRequestSend.size() + metadataRequestSend.size());
        apiVersionRequestSend.writeTo((TransferableChannel)channel);
        metadataRequestSend.writeTo((TransferableChannel)channel);
        serializedRequests = Unpooled.wrappedBuffer((byte[])channel.buffer().array());
        this.receiveBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        this.receiveBuf.readFrom(serializedRequests);
        Assertions.assertTrue((boolean)serializedRequests.isReadable((int)metadataRequestSend.size()));
        Assertions.assertEquals((int)2, (int)serializedRequests.refCnt());
    }

    @AfterEach
    public void afterEach() {
        this.receiveBuf.close();
        Assertions.assertEquals((int)1, (int)serializedRequests.refCnt());
        serializedRequests.release();
    }

    @Test
    public void testParsesOnlyFirstRequest() {
        Assertions.assertEquals((long)(apiVersionRequestSend.size() - 4L), (long)this.receiveBuf.requestSize());
        Assertions.assertEquals((long)apiVersionRequestSend.size(), (long)this.receiveBuf.size());
        Assertions.assertTrue((boolean)this.receiveBuf.complete());
    }

    @Test
    public void testParseSecondRequest() {
        this.receiveBuf.close();
        Assertions.assertEquals((int)1, (int)serializedRequests.refCnt());
        this.receiveBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        this.receiveBuf.readFrom(serializedRequests);
        Assertions.assertFalse((boolean)serializedRequests.isReadable());
        Assertions.assertEquals((int)2, (int)serializedRequests.refCnt());
        Assertions.assertEquals((long)(metadataRequestSend.size() - 4L), (long)this.receiveBuf.requestSize());
        Assertions.assertEquals((long)metadataRequestSend.size(), (long)this.receiveBuf.size());
        Assertions.assertTrue((boolean)this.receiveBuf.complete());
    }
}

