/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class EchoStreamHandler
implements NettyStream.StreamHandler {
    private final NettyStream stream;
    private final Logger log;

    public EchoStreamHandler(NettyStream stream, LogContext logContext) {
        this.stream = stream;
        this.log = logContext.logger(EchoStreamHandler.class);
    }

    public void handleData(ByteBuf data) {
        this.stream.send(data.retain(), true);
        this.stream.receiveMore();
    }

    public void handleReadyForSend() {
    }

    public void handleException(Throwable t) {
        this.log.error("Error in stream handler", t);
        this.handleClose();
    }

    public void handleClose() {
        this.stream.closeStream();
    }

    public NettyStream stream() {
        return this.stream;
    }
}

