/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.netty.Http2AuthenticationContext;
import org.apache.kafka.common.network.netty.K2PStreamMetadata;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class Http2AuthenticationContextTest {
    Http2AuthenticationContextTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"127.0.0.1", "localhost"})
    void createsAuthenticationContextWithValidClientAddress(String clientAddress) throws UnknownHostException {
        K2PStreamMetadata headers = (K2PStreamMetadata)Mockito.mock(K2PStreamMetadata.class);
        Mockito.when((Object)headers.clientAddress()).thenReturn((Object)clientAddress);
        Mockito.when((Object)headers.clientPort()).thenReturn((Object)8080);
        Mockito.when((Object)headers.clientInformation()).thenReturn((Object)new ClientInformation("test", "1.0"));
        Mockito.when((Object)headers.clientId()).thenReturn((Object)"client-1");
        Http2AuthenticationContext context = new Http2AuthenticationContext(headers, SecurityProtocol.SASL_SSL, ListenerName.normalised((String)"listener-1"), 12345L);
        Assertions.assertEquals((Object)SecurityProtocol.SASL_SSL, (Object)context.securityProtocol());
        Assertions.assertEquals((Object)InetAddress.getByName(clientAddress), (Object)context.clientAddress());
        Assertions.assertEquals((Object)"LISTENER-1", (Object)context.listenerName());
        Assertions.assertEquals((long)12345L, (long)context.sessionId());
        Assertions.assertEquals(Optional.of(8080), (Object)context.clientPort());
        Assertions.assertEquals(Optional.of("client-1"), (Object)context.clientId());
    }

    @Test
    void throwsExceptionWhenClientAddressIsInvalid() {
        K2PStreamMetadata headers = (K2PStreamMetadata)Mockito.mock(K2PStreamMetadata.class);
        Mockito.when((Object)headers.clientAddress()).thenReturn((Object)"invalid-address");
        Assertions.assertThrows(UnknownHostException.class, () -> new Http2AuthenticationContext(headers, SecurityProtocol.SASL_SSL, ListenerName.normalised((String)"listener-1"), 12345L));
    }

    @Test
    void createsAuthenticationContextWithNullClientPort() throws UnknownHostException {
        K2PStreamMetadata headers = (K2PStreamMetadata)Mockito.mock(K2PStreamMetadata.class);
        Mockito.when((Object)headers.clientAddress()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)headers.clientPort()).thenReturn(null);
        Mockito.when((Object)headers.clientInformation()).thenReturn((Object)new ClientInformation("test", "1.0"));
        Mockito.when((Object)headers.clientId()).thenReturn((Object)"client-1");
        Http2AuthenticationContext context = new Http2AuthenticationContext(headers, SecurityProtocol.SASL_SSL, ListenerName.normalised((String)"listener-1"), 12345L);
        Assertions.assertEquals(Optional.empty(), (Object)context.clientPort());
    }
}

