/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.concurrent.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.network.netty.NettyClient;
import org.apache.kafka.common.network.netty.NettyClientTestBase;
import org.apache.kafka.common.network.netty.NettyHttp2Connection;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=1L, unit=TimeUnit.MINUTES)
public class NettyHttp2ConnectionTest
extends NettyClientTestBase {
    private NettyClient client;

    @Timeout(value=30L, unit=TimeUnit.SECONDS)
    @BeforeEach
    public void setupClient() {
        this.client = new NettyClient(NettyHttp2ConnectionTest.acceptAllSslContext(), this.eventLoopGroup, logContext);
    }

    @AfterEach
    public void closeClient() {
        this.client.shutdown().join();
    }

    @Test
    public void testStreamCreation() throws Exception {
        NettyHttp2Connection connection = (NettyHttp2Connection)this.client.createConnection(NettyHttp2ConnectionTest.serverAddress(), Integer.valueOf(0x100000), Integer.valueOf(0x100000)).join();
        Future streamFuture = connection.createStream((Http2Headers)new DefaultHttp2Headers(), (NettyStream.StreamHandler)Mockito.mock(NettyStream.StreamHandler.class));
        NettyHttp2Stream stream = (NettyHttp2Stream)streamFuture.get();
        Assertions.assertSame((Object)connection.channel(), (Object)stream.channel().parent());
        connection.close();
    }

    @Test
    public void testStreamCreationFails() {
        LogContext mockLogContext = (LogContext)Mockito.mock(LogContext.class);
        String errMsg = "Test Exception";
        Mockito.when((Object)mockLogContext.logger((Class)Mockito.any(Class.class))).thenCallRealMethod().thenCallRealMethod().thenCallRealMethod().thenThrow(new Throwable[]{new RuntimeException(errMsg)});
        NettyClient nettyClient = new NettyClient(NettyHttp2ConnectionTest.acceptAllSslContext(), this.eventLoopGroup, mockLogContext);
        NettyHttp2Connection connection = (NettyHttp2Connection)nettyClient.createConnection(NettyHttp2ConnectionTest.serverAddress(), Integer.valueOf(0x100000), Integer.valueOf(0x100000)).join();
        Future streamFuture = connection.createStream((Http2Headers)new DefaultHttp2Headers(), (NettyStream.StreamHandler)Mockito.mock(NettyStream.StreamHandler.class));
        ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> streamFuture.get());
        Assertions.assertInstanceOf(RuntimeException.class, (Object)executionException.getCause());
        Assertions.assertSame((Object)errMsg, (Object)executionException.getCause().getMessage());
        connection.close();
    }
}

