/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ExclusionOpResult {
    private final ExclusionOp op;
    private final Optional<ExclusionOperationError> errorOpt;

    public ExclusionOpResult(ExclusionOp op) {
        this(op, null);
    }

    public ExclusionOpResult(ExclusionOp op, ExclusionOperationError error) {
        this.op = Objects.requireNonNull(op);
        this.errorOpt = Optional.ofNullable(error);
    }

    public ExclusionOp.OpType opType() {
        return this.op.opType();
    }

    public String reason() {
        return this.op.reason();
    }

    public Optional<ExclusionOperationError> errorOpt() {
        return this.errorOpt;
    }

    public String toString() {
        return "ExclusionOpResult(op=" + String.valueOf(this.op) + ", errorOpt=" + String.valueOf(this.errorOpt) + "}";
    }
}

