/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.storage;

import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.metadata.storage.ScramParser;
import org.apache.kafka.raft.DynamicVoter;
import org.apache.kafka.raft.DynamicVoters;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;

public class Formatter {
    private PrintStream printStream = System.out;
    private List<Feature> supportedFeatures = Feature.PRODUCTION_FEATURES;
    private int nodeId = -1;
    private String clusterId = null;
    private final TreeSet<String> directories = new TreeSet();
    private MetadataVersion releaseVersion = null;
    protected Map<String, Short> featureLevels = new TreeMap<String, Short>();
    private BootstrapMetadata bootstrapMetadata;
    private boolean unstableFeatureVersionsEnabled = false;
    private boolean ignoreFormatted = false;
    private List<String> scramArguments = Collections.emptyList();
    private String controllerListenerName = null;
    private Optional<String> metadataLogDirectory = Optional.empty();
    private Optional<DynamicVoters> initialControllers = Optional.empty();
    private boolean noInitialControllersFlag = false;

    public Formatter setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
        return this;
    }

    public Formatter setSupportedFeatures(List<Feature> supportedFeatures) {
        this.supportedFeatures = supportedFeatures;
        return this;
    }

    public Formatter setNodeId(int nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public Formatter setClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Formatter setDirectories(Collection<String> directories) {
        this.directories.clear();
        this.directories.addAll(directories);
        return this;
    }

    public Formatter addDirectory(String directory) {
        this.directories.add(directory);
        return this;
    }

    public Collection<String> directories() {
        return this.directories;
    }

    public Formatter setReleaseVersion(MetadataVersion releaseVersion) {
        this.releaseVersion = releaseVersion;
        return this;
    }

    public Formatter setFeatureLevel(String featureName, Short level) {
        this.featureLevels.put(featureName, level);
        return this;
    }

    public Formatter setUnstableFeatureVersionsEnabled(boolean unstableFeatureVersionsEnabled) {
        this.unstableFeatureVersionsEnabled = unstableFeatureVersionsEnabled;
        return this;
    }

    public Formatter setIgnoreFormatted(boolean ignoreFormatted) {
        this.ignoreFormatted = ignoreFormatted;
        return this;
    }

    public Formatter setScramArguments(List<String> scramArguments) {
        this.scramArguments = scramArguments;
        return this;
    }

    public Formatter setControllerListenerName(String controllerListenerName) {
        this.controllerListenerName = controllerListenerName;
        return this;
    }

    public Formatter setMetadataLogDirectory(String metadataLogDirectory) {
        this.metadataLogDirectory = Optional.of(metadataLogDirectory);
        return this;
    }

    public Formatter setMetadataLogDirectory(Optional<String> metadataLogDirectory) {
        this.metadataLogDirectory = metadataLogDirectory;
        return this;
    }

    public Formatter setInitialControllers(DynamicVoters initialControllers) {
        this.initialControllers = Optional.of(initialControllers);
        return this;
    }

    public Formatter setNoInitialControllersFlag(boolean noInitialControllersFlag) {
        this.noInitialControllersFlag = noInitialControllersFlag;
        return this;
    }

    public Optional<DynamicVoters> initialVoters() {
        return this.initialControllers;
    }

    boolean hasDynamicQuorum() {
        return this.initialControllers.isPresent() || this.noInitialControllersFlag;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    public void run() throws Exception {
        if (this.nodeId < 0) {
            throw new RuntimeException("You must specify a valid non-negative node ID.");
        }
        if (this.clusterId == null) {
            throw new FormatterException("You must specify the cluster id.");
        }
        if (this.directories.isEmpty()) {
            throw new FormatterException("You must specify at least one directory to format");
        }
        if (this.controllerListenerName == null) {
            throw new FormatterException("You must specify the name of the initial controller listener.");
        }
        this.metadataLogDirectory.ifPresent(d -> {
            if (!this.directories.contains(d)) {
                throw new FormatterException("The specified metadata log directory, " + d + " was not one of the given directories: " + String.valueOf(this.directories));
            }
        });
        this.releaseVersion = this.calculateEffectiveReleaseVersion();
        this.featureLevels = this.calculateEffectiveFeatureLevels();
        this.bootstrapMetadata = this.calculateBootstrapMetadata();
        this.doFormat(this.bootstrapMetadata);
    }

    MetadataVersion calculateEffectiveReleaseVersion() {
        if (this.featureLevels.containsKey("confluent.metadata.version")) {
            if (this.featureLevels.containsKey("metadata.version")) {
                throw new FormatterException("Cannot use both --feature metadata.version and --feature confluent.metadata.version");
            }
            if (this.releaseVersion != null) {
                throw new FormatterException("Use --release-version instead of --feature confluent.metadata.version=X to avoid ambiguity.");
            }
            return this.verifyReleaseVersion(MetadataVersion.fromConfluentFeatureLevel((short)this.featureLevels.get("confluent.metadata.version")));
        }
        if (this.featureLevels.containsKey("metadata.version")) {
            if (this.releaseVersion != null) {
                throw new FormatterException("Use --release-version instead of --feature metadata.version=X to avoid ambiguity.");
            }
            return this.verifyReleaseVersion(MetadataVersion.fromApacheFeatureLevel((short)this.featureLevels.get("metadata.version")));
        }
        if (this.releaseVersion != null) {
            return this.verifyReleaseVersion(this.releaseVersion);
        }
        if (this.unstableFeatureVersionsEnabled) {
            return MetadataVersion.latestTesting();
        }
        return MetadataVersion.latestProduction();
    }

    MetadataVersion verifyReleaseVersion(MetadataVersion metadataVersion) {
        if (!this.unstableFeatureVersionsEnabled && !metadataVersion.isProduction()) {
            throw new FormatterException("confluent.metadata.version " + String.valueOf(metadataVersion) + " is not yet stable.");
        }
        return metadataVersion;
    }

    Map<String, Short> calculateEffectiveFeatureLevels() {
        short level;
        String featureName;
        TreeMap nameToSupportedFeature = new TreeMap();
        this.supportedFeatures.forEach(feature -> nameToSupportedFeature.put(feature.featureName(), feature));
        TreeMap<String, Short> newFeatureLevels = new TreeMap<String, Short>();
        for (Map.Entry<String, Short> entry : this.featureLevels.entrySet()) {
            featureName = entry.getKey();
            level = entry.getValue();
            if (!(featureName.equals("confluent.metadata.version") || featureName.equals("metadata.version") || nameToSupportedFeature.containsKey(featureName))) {
                throw new FormatterException("Unsupported feature: " + featureName + ". Supported features are: " + String.join((CharSequence)", ", nameToSupportedFeature.keySet()));
            }
            newFeatureLevels.put(featureName, level);
        }
        newFeatureLevels.put("confluent.metadata.version", this.releaseVersion.confluentFeatureLevel());
        this.supportedFeatures.forEach(supportedFeature -> {
            if (supportedFeature.featureName().equals("kraft.version")) {
                newFeatureLevels.put("kraft.version", this.effectiveKRaftFeatureLevel(Optional.ofNullable((Short)newFeatureLevels.get("kraft.version"))));
            } else if (!newFeatureLevels.containsKey(supportedFeature.featureName())) {
                newFeatureLevels.put(supportedFeature.featureName(), supportedFeature.defaultLevel(this.releaseVersion));
            }
        });
        for (Map.Entry<String, Short> entry : newFeatureLevels.entrySet()) {
            featureName = entry.getKey();
            if (featureName.equals("confluent.metadata.version") || featureName.equals("metadata.version")) continue;
            level = entry.getValue();
            Feature supportedFeature2 = (Feature)nameToSupportedFeature.get(featureName);
            FeatureVersion featureVersion = supportedFeature2.fromFeatureLevel(level, this.unstableFeatureVersionsEnabled);
            Feature.validateVersion((FeatureVersion)featureVersion, newFeatureLevels);
        }
        return newFeatureLevels;
    }

    private short effectiveKRaftFeatureLevel(Optional<Short> configuredKRaftVersionLevel) {
        if (configuredKRaftVersionLevel.isPresent()) {
            if (configuredKRaftVersionLevel.get() == 0) {
                if (this.hasDynamicQuorum()) {
                    throw new FormatterException("Cannot set kraft.version to " + String.valueOf(configuredKRaftVersionLevel.get()) + " if KIP-853 configuration is present. Try removing the --feature flag for kraft.version.");
                }
            } else if (!this.hasDynamicQuorum()) {
                throw new FormatterException("Cannot set kraft.version to " + String.valueOf(configuredKRaftVersionLevel.get()) + " unless KIP-853 configuration is present. Try removing the --feature flag for kraft.version.");
            }
            return configuredKRaftVersionLevel.get();
        }
        if (this.hasDynamicQuorum()) {
            return KRaftVersion.KRAFT_VERSION_1.featureLevel();
        }
        return KRaftVersion.KRAFT_VERSION_0.featureLevel();
    }

    BootstrapMetadata calculateBootstrapMetadata() throws Exception {
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromVersions(this.releaseVersion, this.featureLevels, "format command");
        ArrayList<ApiMessageAndVersion> bootstrapRecords = new ArrayList<ApiMessageAndVersion>(bootstrapMetadata.records());
        if (!this.scramArguments.isEmpty()) {
            if (!this.releaseVersion.isScramSupported()) {
                throw new FormatterException("SCRAM is only supported in confluent.metadata.version " + String.valueOf(MetadataVersion.IBP_3_5_IV2) + " or later.");
            }
            bootstrapRecords.addAll(ScramParser.parse(this.scramArguments));
        }
        return BootstrapMetadata.fromRecords(bootstrapRecords, "format command");
    }

    void doFormat(BootstrapMetadata bootstrapMetadata) throws Exception {
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(this.clusterId).setNodeId(this.nodeId).build();
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        loader.addLogDirs(this.directories);
        MetaPropertiesEnsemble ensemble = loader.load();
        ensemble.verify(Optional.of(this.clusterId), OptionalInt.of(this.nodeId), EnumSet.noneOf(MetaPropertiesEnsemble.VerificationFlag.class));
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(ensemble);
        if (!this.ignoreFormatted && !copier.logDirProps().isEmpty()) {
            String firstLogDir = copier.logDirProps().keySet().iterator().next();
            throw new FormatterException("Log directory " + firstLogDir + " is already formatted. Use --ignore-formatted to ignore this directory and format the others.");
        }
        if (!copier.errorLogDirs().isEmpty()) {
            copier.errorLogDirs().forEach(errorLogDir -> this.printStream.println("I/O error trying to read log directory " + errorLogDir + ". Ignoring..."));
            if (ensemble.emptyLogDirs().isEmpty() && copier.logDirProps().isEmpty()) {
                throw new FormatterException("No available log directories to format.");
            }
        }
        if (ensemble.emptyLogDirs().isEmpty()) {
            this.printStream.println("All of the log directories are already formatted.");
        } else {
            HashMap<String, DirectoryType> directoryTypes = new HashMap<String, DirectoryType>();
            for (String emptyLogDir : ensemble.emptyLogDirs()) {
                DirectoryType directoryType = DirectoryType.calculate(emptyLogDir, this.metadataLogDirectory.orElse(""), this.nodeId, this.initialControllers);
                directoryTypes.put(emptyLogDir, directoryType);
                Uuid directoryId = directoryType == DirectoryType.DYNAMIC_METADATA_VOTER_DIRECTORY ? ((DynamicVoter)this.initialControllers.get().voters().get(this.nodeId)).directoryId() : copier.generateValidDirectoryId();
                copier.setLogDirProps(emptyLogDir, new MetaProperties.Builder(metaProperties).setDirectoryId(directoryId).build());
            }
            copier.setPreWriteHandler((writeLogDir, __, ____) -> {
                this.printStream.printf("Formatting %s %s with %s %s.%n", ((DirectoryType)((Object)((Object)directoryTypes.get(writeLogDir)))).description(), writeLogDir, "confluent.metadata.version", this.releaseVersion);
                Files.createDirectories(Paths.get(writeLogDir, new String[0]), new FileAttribute[0]);
                BootstrapDirectory bootstrapDirectory = new BootstrapDirectory(writeLogDir);
                bootstrapDirectory.writeBinaryFile(bootstrapMetadata);
                if (((DirectoryType)((Object)((Object)directoryTypes.get(writeLogDir)))).isDynamicMetadataDirectory()) {
                    Formatter.writeDynamicQuorumSnapshot(writeLogDir, this.initialControllers.get(), this.featureLevels.get("kraft.version"), this.controllerListenerName);
                }
            });
            copier.setWriteErrorHandler((errorLogDir, e) -> {
                throw new FormatterException("Error while writing meta.properties file " + errorLogDir + ": " + String.valueOf(e));
            });
            copier.writeLogDirChanges();
        }
    }

    static void writeDynamicQuorumSnapshot(String writeLogDir, DynamicVoters initialControllers, short kraftVersion, String controllerListenerName) {
        File parentDir = new File(writeLogDir);
        File clusterMetadataDirectory = new File(parentDir, String.format("%s-%d", Topic.CLUSTER_METADATA_TOPIC_PARTITION.topic(), Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition()));
        VoterSet voterSet = initialControllers.toVoterSet(controllerListenerName);
        RecordsSnapshotWriter.Builder builder = new RecordsSnapshotWriter.Builder().setLastContainedLogTimestamp(Time.SYSTEM.milliseconds()).setMaxBatchSize(0x800000).setRawSnapshotWriter((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)clusterMetadataDirectory.toPath(), (OffsetAndEpoch)Snapshots.BOOTSTRAP_SNAPSHOT_ID)).setKraftVersion(KRaftVersion.fromFeatureLevel((short)kraftVersion)).setVoterSet(Optional.of(voterSet));
        try (RecordsSnapshotWriter writer = builder.build((RecordSerde)new MetadataRecordSerde());){
            writer.freeze();
        }
    }

    static enum DirectoryType {
        LOG_DIRECTORY,
        STATIC_METADATA_DIRECTORY,
        DYNAMIC_METADATA_NON_VOTER_DIRECTORY,
        DYNAMIC_METADATA_VOTER_DIRECTORY;


        String description() {
            switch (this.ordinal()) {
                case 0: {
                    return "data directory";
                }
                case 1: {
                    return "metadata directory";
                }
                case 2: {
                    return "dynamic metadata directory";
                }
                case 3: {
                    return "dynamic metadata voter directory";
                }
            }
            throw new RuntimeException("invalid enum type " + String.valueOf((Object)this));
        }

        boolean isDynamicMetadataDirectory() {
            return this == DYNAMIC_METADATA_NON_VOTER_DIRECTORY || this == DYNAMIC_METADATA_VOTER_DIRECTORY;
        }

        static DirectoryType calculate(String logDir, String metadataLogDirectory, int nodeId, Optional<DynamicVoters> initialControllers) {
            if (!logDir.equals(metadataLogDirectory)) {
                return LOG_DIRECTORY;
            }
            if (initialControllers.isEmpty()) {
                return STATIC_METADATA_DIRECTORY;
            }
            if (initialControllers.get().voters().containsKey(nodeId)) {
                return DYNAMIC_METADATA_VOTER_DIRECTORY;
            }
            return DYNAMIC_METADATA_NON_VOTER_DIRECTORY;
        }
    }
}

