/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.ConfigRepository;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;

public interface MetadataCache
extends ConfigRepository {
    public List<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> var1, ListenerName var2, boolean var3, boolean var4);

    public Set<String> getAllTopics();

    public Set<String> getAllTopics(Optional<String> var1);

    public Set<TopicPartition> getTopicPartitions(String var1);

    public boolean hasAliveBroker(int var1);

    public Optional<Long> getAliveBrokerEpoch(int var1);

    public boolean isBrokerFenced(int var1);

    public boolean isBrokerShuttingDown(int var1);

    public int getBrokerCellId(int var1);

    public boolean isBrokerDegraded(int var1);

    public boolean isBrokerComponentDegraded(int var1, BrokerComponent var2);

    public Uuid getTopicId(String var1);

    public Optional<String> getTopicName(Uuid var1);

    public Optional<TopicType> getTopicType(String var1);

    public Optional<Node> getAliveBrokerNode(int var1, ListenerName var2);

    public List<Node> getAliveBrokerNodes(ListenerName var1);

    public List<Node> getBrokerNodes(ListenerName var1);

    public Optional<LeaderAndIsr> getLeaderAndIsr(String var1, int var2);

    public Optional<Integer> numPartitions(String var1);

    public Map<String, Uuid> topicNamesToIds();

    public Map<Uuid, String> topicIdsToNames();

    public Optional<Node> getPartitionLeaderEndpoint(String var1, int var2, ListenerName var3);

    public Map<Integer, Node> getPartitionReplicaEndpoints(TopicPartition var1, ListenerName var2);

    public boolean contains(String var1);

    public boolean contains(TopicPartition var1);

    public MetadataVersion metadataVersion();

    public Optional<Integer> getRandomAliveBrokerId();

    public FinalizedFeatures features();

    public Optional<MirrorTopic> mirrorTopicState(String var1);

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData var1);

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData var1);

    public DescribeTopicPartitionsResponseData describeTopicResponse(Iterator<String> var1, ListenerName var2, Function<String, Integer> var3, int var4, boolean var5);

    public static Cluster toCluster(String clusterId, MetadataImage image) {
        HashMap brokerToNodes = new HashMap();
        image.cluster().brokers().values().stream().filter(broker -> !broker.fenced()).forEach(broker -> brokerToNodes.put(broker.id(), broker.nodes()));
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((partitionId, partition) -> {
            List nodes = (List)brokerToNodes.get(partition.leader);
            if (nodes != null) {
                nodes.forEach(node -> partitionInfos.add(new PartitionInfo(topic.name(), partitionId.intValue(), node, MetadataCache.toArray(partition.replicas, brokerToNodes), MetadataCache.toArray(partition.isr, brokerToNodes), (Node[])MetadataCache.getOfflineReplicas(image, partition).stream().map(brokerToNodes::get).flatMap(Collection::stream).toArray(Node[]::new))));
                if (Topic.isInternal((String)topic.name())) {
                    internalTopics.add(topic.name());
                }
            }
        }));
        Node controllerNode = Optional.ofNullable((List)brokerToNodes.get(MetadataCache.getRandomAliveBroker(image).orElse(-1))).map(nodes -> (Node)nodes.get(0)).orElse(Node.noNode());
        return new Cluster(clusterId, (Collection)brokerToNodes.values().stream().flatMap(Collection::stream).collect(Collectors.toList()), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    private static Node[] toArray(int[] replicas, Map<Integer, List<Node>> brokerToNodes) {
        return (Node[])Arrays.stream(replicas).mapToObj(brokerToNodes::get).flatMap(Collection::stream).toArray(Node[]::new);
    }

    private static List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>();
        for (int brokerId : partition.replicas) {
            BrokerRegistration broker = image.cluster().broker(brokerId);
            if (broker != null && !MetadataCache.isReplicaOffline(partition, broker)) continue;
            offlineReplicas.add(brokerId);
        }
        return offlineReplicas;
    }

    private static boolean isReplicaOffline(PartitionRegistration partition, BrokerRegistration broker) {
        return broker.fenced() || !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private static Optional<Integer> getRandomAliveBroker(MetadataImage image) {
        List<Integer> aliveBrokers = image.cluster().brokers().values().stream().filter(broker -> !broker.fenced()).map(BrokerRegistration::id).toList();
        if (aliveBrokers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(aliveBrokers.get(ThreadLocalRandom.current().nextInt(aliveBrokers.size())));
    }
}

