/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class NoOpMetadataEncryptor
implements MetadataEncryptor {
    public static final NoOpMetadataEncryptor INSTANCE = new NoOpMetadataEncryptor(Uuid.ZERO_UUID, new byte[0]);

    public NoOpMetadataEncryptor() {
        this(Uuid.ZERO_UUID, new byte[0]);
    }

    public NoOpMetadataEncryptor(Uuid id, byte[] secret) {
        if (!id.equals((Object)Uuid.ZERO_UUID)) {
            throw new RuntimeException("NoOpMetadataEncryptor cannot be created with a non-zero ID.");
        }
        if (secret.length != 0) {
            throw new RuntimeException("NoOpMetadataEncryptor cannot be created with a non-empty secret.");
        }
    }

    @Override
    public Uuid id() {
        return Uuid.ZERO_UUID;
    }

    @Override
    public byte[] decrypt(byte[] input) {
        throw new RuntimeException("No metadata encryptor configured.");
    }

    @Override
    public byte[] encrypt(byte[] input) {
        throw new RuntimeException("No metadata encryptor configured.");
    }

    @Override
    public ApiMessageAndVersion encrypt(ApiMessageAndVersion messageAndVersion) {
        return new ApiMessageAndVersion((ApiMessage)messageAndVersion.message().duplicate(), messageAndVersion.version());
    }

    @Override
    public byte[] secret() {
        return new byte[0];
    }
}

