/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.metadata.authorizer.AclStore;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.Visitor;

class AuthorizeVisitor
implements Visitor {
    private final String resourceName;
    private final AclOperation operation;
    private final String host;
    private StandardAcl matchingAcl;

    AuthorizeVisitor(String resourceName, AclOperation operation, String host) {
        this.resourceName = resourceName;
        this.operation = operation;
        this.host = host;
    }

    @Override
    public boolean visit(ResourceAcls resourceAcls) {
        return this.visitAclStore(resourceAcls);
    }

    @Override
    public boolean visit(PrefixNode node) {
        if (!this.visitAclStore(node)) {
            return false;
        }
        Map.Entry entry = node.children().floorEntry((Object)this.resourceName);
        if (entry == null) {
            return true;
        }
        String childPrefix = (String)entry.getKey();
        if (this.resourceName.startsWith(childPrefix)) {
            PrefixNode child = (PrefixNode)entry.getValue();
            return child.walk(this);
        }
        return true;
    }

    private boolean visitAclStore(AclStore aclStore) {
        Optional<StandardAcl> aclOpt = aclStore.findMatchingAcl(this.operation, this.host);
        if (!aclOpt.isPresent()) {
            return true;
        }
        this.matchingAcl = aclOpt.get();
        return this.matchingAcl.permissionType() == AclPermissionType.ALLOW;
    }

    public Optional<StandardAcl> matchingAcl() {
        return Optional.ofNullable(this.matchingAcl);
    }
}

