/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.server.common.CorruptCheckpointFileException;

public class CheckpointFileChecksumUtils {
    private static final String CHECKSUM_FIELD_PREFIX = "CHECKSUM-";
    private static final String CHECKSUM_FIELD_REGEX = "CHECKSUM-\\d+";
    private final boolean checksumProtectionEnabled;
    private final Checksum checksum;

    public CheckpointFileChecksumUtils(boolean checksumProtectionEnabled) {
        this.checksumProtectionEnabled = checksumProtectionEnabled;
        this.checksum = new CRC32C();
    }

    public void mayUpdateChecksum(String line) {
        if (this.checksumProtectionEnabled && line != null) {
            ByteBuffer buffer = ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8));
            Checksums.update((Checksum)this.checksum, (ByteBuffer)buffer, (int)buffer.remaining());
        }
    }

    public void mayUpdateChecksum(int readVersion, int expectedSize) {
        if (this.checksumProtectionEnabled) {
            Checksums.updateInt((Checksum)this.checksum, (int)readVersion);
            Checksums.updateInt((Checksum)this.checksum, (int)expectedSize);
        }
    }

    public void mayWriteChecksumLine(BufferedWriter writer) throws IOException {
        if (this.checksumProtectionEnabled) {
            writer.write(CHECKSUM_FIELD_PREFIX + this.checksum.getValue());
            writer.newLine();
        }
    }

    public void mayValidateChecksum(String line) {
        long expectedChecksum;
        if (this.checksumProtectionEnabled && (expectedChecksum = this.parseChecksum(line)) != this.checksum.getValue()) {
            throw new CorruptCheckpointFileException("Leader Epoch Cache file is corrupt (CRC is no longer valid). Stored/Expected CRC: " + expectedChecksum + "; Computed CRC: " + this.checksum.getValue());
        }
    }

    private long parseChecksum(String line) {
        if (line == null || line.isEmpty()) {
            throw new CorruptCheckpointFileException("Checksum Entry is missing from the Checkpoint File");
        }
        if (!line.matches(CHECKSUM_FIELD_REGEX)) {
            throw new CorruptCheckpointFileException("Checkpoint Entry doesn't exist in the expected format. Found this line: " + line);
        }
        return Long.parseLong(line.split("-")[1]);
    }
}

