/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public enum MetadataVersion {
    IBP_3_3_IV3(7, 107, "3.3-IV3", "CP-7.3-IV3", true),
    IBP_3_4_IV0(8, 108, "3.4-IV0", "CP-7.4-IV0", true),
    IBP_3_5_IV0(9, 109, "3.5-IV0", "CP-7.5-IV0", true),
    IBP_3_5_IV1(10, 110, "3.5-IV1", "CP-7.5-IV1", false),
    IBP_3_5_IV2(11, 111, "3.5-IV2", "CP-7.5-IV2", true),
    IBP_3_6_IV0(12, 112, "3.6-IV0", "CP-7.6-IV0", false),
    IBP_3_6_IV1(13, 113, "3.6-IV1", "CP-7.6-IV1", false),
    IBP_3_6_IV2(14, 114, "3.6-IV2", "CP-7.6-IV2", true),
    IBP_3_7_IV0(15, 115, "3.7-IV0", "CP-7.7-IV0", true),
    IBP_3_7_IV1(16, 116, "3.7-IV1", "CP-7.7-IV1", true),
    IBP_3_7_IV2(17, 117, "3.7-IV2", "CP-7.7-IV2", true),
    IBP_3_7_IV3(18, 118, "3.7-IV3", "CP-7.7-IV3", false),
    IBP_3_7_IV4(19, 119, "3.7-IV4", "CP-7.7-IV4", false),
    IBP_3_8_IV0A(20, 120, "3.8-IV0", "CP-7.8-IV0A", true),
    IBP_3_8_IV0B(20, 121, "3.8-IV0", "CP-7.8-IV0B", true),
    IBP_3_9_IV0A(21, 122, "3.9-IV0", "CP-7.9-IV0A", false),
    IBP_3_9_IV0B(21, 123, "3.9-IV0", "CP-7.9-IV0B", true),
    IBP_4_0_IV0A(22, 124, "4.0-IV0", "CP-8.0-IV0A", false),
    IBP_4_0_IV1A(23, 125, "4.0-IV1", "CP-8.0-IV1A", true),
    IBP_4_0_IV2A(24, 126, "4.0-IV2", "CP-8.0-IV2A", false),
    IBP_4_0_IV3A(25, 127, "4.0-IV3", "CP-8.0-IV3A", false),
    IBP_4_0_IV3B(25, 128, "4.0-IV3", "CP-8.0-IV3B", true),
    IBP_4_1_IV0A(26, 129, "4.1-IV0", "CP-8.1-IV0A", true),
    IBP_4_1_IV0B(26, 130, "4.1-IV0", "CP-8.1-IV0B", false),
    IBP_4_1_IV1A(27, 131, "4.1-IV1", "CP-8.1-IV1A", false),
    IBP_4_2_IV0A(28, 132, "4.2-IV0", "CP-8.2-IV0A", false),
    IBP_4_2_IV1A(29, 133, "4.2-IV1", "CP-8.2-IV1A", false);

    public static final String APACHE_FEATURE_NAME = "metadata.version";
    public static final String CONFLUENT_FEATURE_NAME = "confluent.metadata.version";
    public static final String CONFLUENT_RELEASE_PREFIX = "CP-";
    public static final MetadataVersion MINIMUM_VERSION;
    public static final MetadataVersion LATEST_PRODUCTION;
    public static final MetadataVersion[] VERSIONS;
    private final short apacheFeatureLevel;
    private final short confluentFeatureLevel;
    private final String apacheRelease;
    private final String apacheReleaseWithSuffix;
    private final String confluentRelease;
    private final String shortApacheRelease;
    private final String shortConfluentRelease;
    private final String confluentReleaseWithOutSuffix;
    private final boolean didMetadataChange;
    private static final Map<String, MetadataVersion> IBP_VERSIONS;
    private static final Map<String, MetadataVersion> CONFLUENT_VERSIONS;

    private MetadataVersion(int apacheFeatureLevel, int confluentFeatureLevel, String apacheRelease, String confluentRelease) {
        this(apacheFeatureLevel, confluentFeatureLevel, apacheRelease, confluentRelease, true);
    }

    static String stripIv(String input) {
        int i = input.lastIndexOf("-IV");
        if (i < 0) {
            throw new RuntimeException("No -IV found in string " + input);
        }
        return input.substring(0, i);
    }

    private MetadataVersion(int apacheFeatureLevel, int confluentFeatureLevel, String apacheRelease, String confluentRelease, boolean didMetadataChange) {
        this.apacheFeatureLevel = (short)apacheFeatureLevel;
        this.confluentFeatureLevel = (short)confluentFeatureLevel;
        this.apacheRelease = apacheRelease;
        if (!confluentRelease.startsWith(CONFLUENT_RELEASE_PREFIX)) {
            throw new RuntimeException("The Confluent release string must start with CP-");
        }
        if (confluentFeatureLevel >= 120) {
            char lastChar = confluentRelease.charAt(confluentRelease.length() - 1);
            if (lastChar < 'A' || lastChar > 'Z') {
                throw new RuntimeException("The Confluent release string must end with a suffix from A to Z");
            }
            this.apacheReleaseWithSuffix = apacheRelease + lastChar;
            this.confluentReleaseWithOutSuffix = confluentRelease.substring(0, confluentRelease.length() - 1);
        } else {
            this.apacheReleaseWithSuffix = apacheRelease;
            this.confluentReleaseWithOutSuffix = confluentRelease;
        }
        this.confluentRelease = confluentRelease;
        this.didMetadataChange = didMetadataChange;
        if (apacheRelease.equals("0.8.0") || apacheRelease.equals("0.8.1") || apacheRelease.equals("0.8.2") || apacheRelease.equals("0.9.0")) {
            this.shortApacheRelease = apacheRelease;
            this.shortConfluentRelease = confluentRelease;
        } else {
            this.shortApacheRelease = MetadataVersion.stripIv(apacheRelease);
            this.shortConfluentRelease = MetadataVersion.stripIv(confluentRelease);
        }
    }

    public short apacheFeatureLevel() {
        return this.apacheFeatureLevel;
    }

    public short confluentFeatureLevel() {
        return this.confluentFeatureLevel;
    }

    public boolean isScramSupported() {
        return this.isAtLeast(IBP_3_5_IV2);
    }

    public boolean isLeaderEpochBumpRequiredOnIsrShrink() {
        return !this.isAtLeast(IBP_3_6_IV0);
    }

    public boolean isMetadataTransactionSupported() {
        return this.isAtLeast(IBP_3_6_IV1);
    }

    public boolean isDelegationTokenSupported() {
        return this.isAtLeast(IBP_3_6_IV2);
    }

    public boolean isDirectoryAssignmentSupported() {
        return this.isAtLeast(IBP_3_7_IV2);
    }

    public boolean isElrSupported() {
        return this.isAtLeast(IBP_4_0_IV1A);
    }

    public boolean isOtelTracingSupported() {
        return this.isAtLeast(IBP_3_7_IV2);
    }

    public boolean isExternalConnectivitySupported() {
        return this.isAtLeast(IBP_3_7_IV2);
    }

    public boolean isMigrationSupported() {
        return this.isAtLeast(IBP_3_4_IV0);
    }

    public boolean isCellsSupported() {
        return this.isAtLeast(IBP_3_5_IV0);
    }

    public boolean isSettingBrokerHealthSupported() {
        return this.isAtLeast(IBP_3_5_IV0);
    }

    public boolean isSettingBrokerMetadataEncryptorsSupported() {
        return this.isAtLeast(IBP_3_5_IV0);
    }

    public boolean isSettingControllerMetadataEncryptorsSupported() {
        return this.isControllerRegistrationSupported();
    }

    public boolean isTopicPlacementSupported() {
        return this.isAtLeast(IBP_3_5_IV0);
    }

    public boolean isLinkCoordinatorSupported() {
        return this.isAtLeast(IBP_3_5_IV0);
    }

    public boolean isAlterMirrorsRequestSupported() {
        return this.isAtLeast(IBP_3_6_IV1);
    }

    public short registerBrokerRecordVersion() {
        if (this.isDirectoryAssignmentSupported()) {
            return 3;
        }
        if (this.isSettingBrokerHealthSupported() || this.isMigrationSupported() || this.isSettingBrokerMetadataEncryptorsSupported()) {
            return 2;
        }
        return 1;
    }

    public short registerControllerRecordVersion() {
        if (this.isAtLeast(IBP_3_7_IV0)) {
            return 0;
        }
        throw new RuntimeException("Controller registration is not supported in MetadataVersion " + String.valueOf((Object)this));
    }

    public boolean isControllerRegistrationSupported() {
        return this.isAtLeast(IBP_3_7_IV0);
    }

    public boolean isClusterLinkingFailbackSupported() {
        return this.isAtLeast(IBP_3_7_IV1);
    }

    public boolean isLeaderEpochBumpedOnMirrorTransition() {
        return this.isAtLeast(IBP_3_9_IV0B);
    }

    public short mirrorRecordVersion() {
        return (short)(this.isClusterLinkingFailbackSupported() ? 1 : 0);
    }

    public short mirrorChangeRecordVersion() {
        if (this.isLeaderEpochBumpedOnMirrorTransition()) {
            return 2;
        }
        if (this.isClusterLinkingFailbackSupported()) {
            return 1;
        }
        return 0;
    }

    public boolean isSwitchoverControlPlaneTimestampSupported() {
        return this.isAtLeast(IBP_4_0_IV3B);
    }

    public short clusterLinkChangeRecordVersion() {
        if (this.isSwitchoverControlPlaneTimestampSupported()) {
            return 1;
        }
        return 0;
    }

    public boolean isCellMigrationSupported() {
        return this.isAtLeast(IBP_3_7_IV2);
    }

    public boolean isTenantStripingSupported() {
        return this.isAtLeast(IBP_3_8_IV0B);
    }

    public boolean isConfluentKeyValueStreamsSupported() {
        return this.isAtLeast(IBP_4_1_IV0A);
    }

    public short tenantRecordVersion() {
        if (this.isTenantStripingSupported()) {
            return 1;
        }
        return 0;
    }

    public short partitionChangeRecordVersion() {
        if (this.isElrSupported()) {
            return 2;
        }
        if (this.isDirectoryAssignmentSupported()) {
            return 1;
        }
        return 0;
    }

    public short partitionRecordVersion() {
        if (this.isElrSupported()) {
            return 2;
        }
        if (this.isDirectoryAssignmentSupported()) {
            return 1;
        }
        return 0;
    }

    public short fetchRequestVersion() {
        if (this.isAtLeast(IBP_4_1_IV1A)) {
            return 18;
        }
        if (this.isAtLeast(IBP_3_9_IV0A)) {
            return 17;
        }
        if (this.isAtLeast(IBP_3_7_IV4)) {
            return 16;
        }
        if (this.isAtLeast(IBP_3_5_IV1)) {
            return 15;
        }
        if (this.isAtLeast(IBP_3_5_IV0)) {
            return 14;
        }
        return 13;
    }

    public short listOffsetRequestVersion() {
        if (this.isAtLeast(IBP_4_0_IV3A)) {
            return 10;
        }
        if (this.isAtLeast(IBP_3_9_IV0A)) {
            return 9;
        }
        if (this.isAtLeast(IBP_3_5_IV0)) {
            return 8;
        }
        return 7;
    }

    public boolean isTopicTypeSupported() {
        return this.isAtLeast(IBP_3_7_IV1);
    }

    public boolean isVirtualTopicSupported() {
        return this.isAtLeast(IBP_3_8_IV0A);
    }

    public boolean isPushReplicationSupported() {
        return this.isAtLeast(IBP_4_1_IV1A);
    }

    public boolean isProduction() {
        return this.compareTo(LATEST_PRODUCTION) <= 0;
    }

    public String shortVersion() {
        return this.shortApacheRelease;
    }

    public String version() {
        return this.apacheRelease;
    }

    public String versionWithSuffix() {
        return this.apacheReleaseWithSuffix;
    }

    public String shortConfluentRelease() {
        return this.shortConfluentRelease;
    }

    public String confluentRelease() {
        return this.confluentRelease;
    }

    public String confluentReleaseWithOutSuffix() {
        return this.confluentReleaseWithOutSuffix;
    }

    public String apacheRelease() {
        return this.apacheRelease;
    }

    public boolean didMetadataChange() {
        return this.didMetadataChange;
    }

    Optional<MetadataVersion> previous() {
        int idx = this.ordinal();
        if (idx > 0) {
            return Optional.of(VERSIONS[idx - 1]);
        }
        return Optional.empty();
    }

    public static MetadataVersion fromVersionString(String versionString) {
        int numSegments = 2;
        String[] versionSegments = versionString.split(Pattern.quote("."));
        String key = numSegments >= versionSegments.length ? versionString : String.join((CharSequence)".", Arrays.copyOfRange(versionSegments, 0, numSegments));
        MetadataVersion result = IBP_VERSIONS.get(key);
        if (result == null && (result = CONFLUENT_VERSIONS.get(key)) == null) {
            throw new IllegalArgumentException("Version " + versionString + " is not a valid version. The minimum version is " + String.valueOf((Object)MINIMUM_VERSION) + " and the maximum version is " + String.valueOf((Object)MetadataVersion.latestTesting()));
        }
        return result;
    }

    public static MetadataVersion fromConfluentFeatureLevel(short version) {
        short oldStyleVersion = 7;
        if (version == oldStyleVersion) {
            return IBP_3_3_IV3;
        }
        for (MetadataVersion metadataVersion : MetadataVersion.values()) {
            if (metadataVersion.confluentFeatureLevel() != version) continue;
            return metadataVersion;
        }
        throw new IllegalArgumentException("No Confluent MetadataVersion with metadata version " + version + ". Valid feature levels are from " + oldStyleVersion + " to " + MetadataVersion.latestTesting().confluentFeatureLevel + ".");
    }

    public static MetadataVersion fromApacheFeatureLevel(short version) {
        for (MetadataVersion metadataVersion : MetadataVersion.values()) {
            if (metadataVersion.apacheFeatureLevel() != version) continue;
            return metadataVersion;
        }
        throw new IllegalArgumentException("No MetadataVersion with feature level " + version + ". Valid feature levels are from " + MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel + " to " + MetadataVersion.latestTesting().apacheFeatureLevel + ".");
    }

    public static MetadataVersion latestTesting() {
        return VERSIONS[VERSIONS.length - 1];
    }

    public static MetadataVersion latestProduction() {
        return LATEST_PRODUCTION;
    }

    public static boolean checkIfMetadataChanged(MetadataVersion sourceVersion, MetadataVersion targetVersion) {
        MetadataVersion lowVersion;
        MetadataVersion highVersion;
        if (sourceVersion == targetVersion) {
            return false;
        }
        if (sourceVersion.compareTo(targetVersion) < 0) {
            highVersion = targetVersion;
            lowVersion = sourceVersion;
        } else {
            highVersion = sourceVersion;
            lowVersion = targetVersion;
        }
        return MetadataVersion.checkIfMetadataChangedOrdered(highVersion, lowVersion);
    }

    private static boolean checkIfMetadataChangedOrdered(MetadataVersion highVersion, MetadataVersion lowVersion) {
        Optional<MetadataVersion> prev;
        MetadataVersion version = highVersion;
        while (!version.didMetadataChange() && version != lowVersion && (prev = version.previous()).isPresent()) {
            version = prev.get();
        }
        return version != lowVersion;
    }

    public boolean isAtLeast(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isLessThan(MetadataVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public String toString() {
        return this.versionWithSuffix();
    }

    static {
        MINIMUM_VERSION = IBP_3_3_IV3;
        LATEST_PRODUCTION = IBP_4_1_IV1A;
        MetadataVersion[] enumValues = MetadataVersion.values();
        VERSIONS = Arrays.copyOf(enumValues, enumValues.length);
        IBP_VERSIONS = new HashMap<String, MetadataVersion>();
        CONFLUENT_VERSIONS = new HashMap<String, MetadataVersion>();
        for (MetadataVersion metadataVersion : VERSIONS) {
            MetadataVersion shadowedByConfluentRelease;
            if (metadataVersion.isProduction()) {
                IBP_VERSIONS.put(metadataVersion.shortVersion(), metadataVersion);
                IBP_VERSIONS.put(metadataVersion.version(), metadataVersion);
            }
            IBP_VERSIONS.put(metadataVersion.versionWithSuffix(), metadataVersion);
            String thisConfluentRelease = metadataVersion.confluentRelease();
            if (!metadataVersion.name().startsWith("IBP_0_8_") && (shadowedByConfluentRelease = CONFLUENT_VERSIONS.remove(thisConfluentRelease)) != null) {
                throw new IllegalStateException(String.format("Duplicate Confluent Release %s: %s and %s", thisConfluentRelease, shadowedByConfluentRelease.name(), metadataVersion.name()));
            }
            if (metadataVersion.isProduction()) {
                CONFLUENT_VERSIONS.put(metadataVersion.shortConfluentRelease(), metadataVersion);
                CONFLUENT_VERSIONS.put(metadataVersion.confluentReleaseWithOutSuffix(), metadataVersion);
            }
            CONFLUENT_VERSIONS.put(thisConfluentRelease, metadataVersion);
        }
    }
}

