/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUsageBasedThrottlingConfig {
    private static final Logger log = LoggerFactory.getLogger(DiskUsageBasedThrottlingConfig.class);
    public static final long MIN_DISK_THRESHOLD_BYTES = 0x40000000L;
    public static final long MIN_THROUGHPUT_BYTES_PER_SEC = 16384L;
    public static final long DEFAULT_DISK_CHECK_FREQUENCY_MS = TimeUnit.SECONDS.toMillis(60L);
    public static final double MIN_FREE_DISK_RECOVERY_FACTOR = 1.0;
    public static final long DEFAULT_FREE_DISK_THRESHOLD_BYTES = 0x500000000L;
    public static final long DEFAULT_THROTTLED_PRODUCE_THROUGHPUT = 131072L;
    public static final List<String> DEFAULT_LOG_DIRS = new ArrayList<String>();
    public static final boolean DEFAULT_ENABLE_DISK_BASED_THROTTLING = false;
    public static final double DEFAULT_FREE_DISK_THRESHOLD_BYTES_RECOVERY_FACTOR = 1.5;
    public static final boolean DEFAULT_CLUSTER_LINK_ENABLED = false;
    public final long freeDiskThresholdBytes;
    public final long throttledProduceThroughput;
    public final List<String> logDirs;
    public final boolean enableDiskBasedThrottling;
    public final long diskCheckFrequencyMs;
    public final double freeDiskThresholdBytesRecoveryFactor;
    public final boolean clusterLinkEnabled;

    public DiskUsageBasedThrottlingConfig() {
        this(0x500000000L, 131072L, DEFAULT_LOG_DIRS, false, DEFAULT_DISK_CHECK_FREQUENCY_MS, 1.5, false);
    }

    public DiskUsageBasedThrottlingConfig(long freeDiskThresholdBytes, long throttledProduceThroughput, List<String> logDirs, boolean enableDiskBasedThrottling, double freeDiskThresholdBytesRecoveryFactor, boolean clusterLinkEnabled) {
        this(freeDiskThresholdBytes, throttledProduceThroughput, logDirs, enableDiskBasedThrottling, DEFAULT_DISK_CHECK_FREQUENCY_MS, freeDiskThresholdBytesRecoveryFactor, clusterLinkEnabled);
    }

    public DiskUsageBasedThrottlingConfig(List<String> logDirs, boolean enableDiskBasedThrottling) {
        this(0x500000000L, 131072L, logDirs, enableDiskBasedThrottling, DEFAULT_DISK_CHECK_FREQUENCY_MS);
    }

    public DiskUsageBasedThrottlingConfig(long freeDiskThresholdBytes, long throttledProduceThroughput) {
        this(freeDiskThresholdBytes, throttledProduceThroughput, DEFAULT_LOG_DIRS, false, DEFAULT_DISK_CHECK_FREQUENCY_MS);
    }

    public DiskUsageBasedThrottlingConfig(long throttledProduceThroughput, List<String> logDirs, boolean enableDiskBasedThrottling, long diskCheckFrequencyMs) {
        this(0x500000000L, throttledProduceThroughput, logDirs, enableDiskBasedThrottling, diskCheckFrequencyMs);
    }

    public DiskUsageBasedThrottlingConfig(long freeDiskThresholdBytes, long throttledProduceThroughput, List<String> logDirs, boolean enableDiskBasedThrottling, long diskCheckFrequencyMs) {
        this(freeDiskThresholdBytes, throttledProduceThroughput, logDirs, enableDiskBasedThrottling, diskCheckFrequencyMs, 1.5);
    }

    public DiskUsageBasedThrottlingConfig(long freeDiskThresholdBytes, long throttledProduceThroughput, List<String> logDirs, boolean enableDiskBasedThrottling, long diskCheckFrequencyMs, double freeDiskThresholdBytesRecoveryFactor) {
        this(freeDiskThresholdBytes, throttledProduceThroughput, logDirs, enableDiskBasedThrottling, diskCheckFrequencyMs, freeDiskThresholdBytesRecoveryFactor, false);
    }

    public DiskUsageBasedThrottlingConfig(long freeDiskThresholdBytes, long throttledProduceThroughput, List<String> logDirs, boolean enableDiskBasedThrottling, long diskCheckFrequencyMs, double freeDiskThresholdBytesRecoveryFactor, boolean clusterLinkEnabled) {
        this(freeDiskThresholdBytes, throttledProduceThroughput, logDirs, enableDiskBasedThrottling, diskCheckFrequencyMs, freeDiskThresholdBytesRecoveryFactor, clusterLinkEnabled, false);
    }

    private DiskUsageBasedThrottlingConfig(long freeDiskThresholdBytes, long throttledProduceThroughput, List<String> logDirs, boolean enableDiskBasedThrottling, long diskCheckFrequencyMs, double freeDiskThresholdBytesRecoveryFactor, boolean clusterLinkEnabled, boolean calledByCopyFunction) {
        if (logDirs.isEmpty()) {
            log.info("Empty logDirs received! Disk based throttling won't be activated!");
        }
        this.freeDiskThresholdBytes = DiskUsageBasedThrottlingConfig.getSanitisedConfig("confluent.backpressure.disk.free.threshold.bytes", freeDiskThresholdBytes, 0x40000000L, calledByCopyFunction);
        this.throttledProduceThroughput = DiskUsageBasedThrottlingConfig.getSanitisedConfig("confluent.backpressure.disk.produce.bytes.per.second", throttledProduceThroughput, 16384L, calledByCopyFunction);
        this.logDirs = logDirs;
        this.enableDiskBasedThrottling = !logDirs.isEmpty() && enableDiskBasedThrottling;
        this.diskCheckFrequencyMs = diskCheckFrequencyMs;
        this.freeDiskThresholdBytesRecoveryFactor = DiskUsageBasedThrottlingConfig.getSanitisedConfig("confluent.backpressure.disk.threshold.recovery.factor", freeDiskThresholdBytesRecoveryFactor, 1.0, calledByCopyFunction);
        this.clusterLinkEnabled = clusterLinkEnabled;
    }

    public DiskUsageBasedThrottlingConfig copy(long freeDiskThresholdBytes, long throttledProduceThroughput) {
        return new DiskUsageBasedThrottlingConfig(freeDiskThresholdBytes, throttledProduceThroughput, this.logDirs, this.enableDiskBasedThrottling, this.diskCheckFrequencyMs, this.freeDiskThresholdBytesRecoveryFactor, this.clusterLinkEnabled, true);
    }

    public DiskUsageBasedThrottlingConfig copy(long freeDiskThresholdBytes, long throttledProduceThroughput, long diskCheckFrequencyMs) {
        return new DiskUsageBasedThrottlingConfig(freeDiskThresholdBytes, throttledProduceThroughput, this.logDirs, this.enableDiskBasedThrottling, diskCheckFrequencyMs, this.freeDiskThresholdBytesRecoveryFactor, this.clusterLinkEnabled, true);
    }

    public DiskUsageBasedThrottlingConfig copy(long freeDiskThresholdBytes, boolean enableDiskBasedThrottling) {
        return new DiskUsageBasedThrottlingConfig(freeDiskThresholdBytes, this.throttledProduceThroughput, this.logDirs, enableDiskBasedThrottling, this.diskCheckFrequencyMs, this.freeDiskThresholdBytesRecoveryFactor, this.clusterLinkEnabled, true);
    }

    public DiskUsageBasedThrottlingConfig copy(long freeDiskThresholdBytes) {
        return new DiskUsageBasedThrottlingConfig(freeDiskThresholdBytes, this.throttledProduceThroughput, this.logDirs, this.enableDiskBasedThrottling, this.diskCheckFrequencyMs, this.freeDiskThresholdBytesRecoveryFactor, this.clusterLinkEnabled, true);
    }

    private static long getSanitisedConfig(String configName, long suppliedValue, long minimumValue, boolean calledByCopyFunction) {
        if (calledByCopyFunction) {
            return suppliedValue;
        }
        if (suppliedValue < minimumValue) {
            log.warn("Illegal value for {}: {}. Will be set to: {}", new Object[]{configName, suppliedValue, minimumValue});
        }
        return Math.max(suppliedValue, minimumValue);
    }

    private static double getSanitisedConfig(String configName, double suppliedValue, double minimumValue, boolean calledByCopyFunction) {
        if (calledByCopyFunction) {
            return suppliedValue;
        }
        if (suppliedValue < minimumValue) {
            log.warn("Illegal value for {}: {}. Will be set to: {}", new Object[]{configName, suppliedValue, minimumValue});
        }
        return Math.max(suppliedValue, minimumValue);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiskUsageBasedThrottlingConfig)) {
            return false;
        }
        DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig = (DiskUsageBasedThrottlingConfig)object;
        return this.freeDiskThresholdBytes == diskUsageBasedThrottlingConfig.freeDiskThresholdBytes && this.throttledProduceThroughput == diskUsageBasedThrottlingConfig.throttledProduceThroughput && this.logDirs.equals(diskUsageBasedThrottlingConfig.logDirs) && this.enableDiskBasedThrottling == diskUsageBasedThrottlingConfig.enableDiskBasedThrottling && this.diskCheckFrequencyMs == diskUsageBasedThrottlingConfig.diskCheckFrequencyMs && this.freeDiskThresholdBytesRecoveryFactor == diskUsageBasedThrottlingConfig.freeDiskThresholdBytesRecoveryFactor && this.clusterLinkEnabled == diskUsageBasedThrottlingConfig.clusterLinkEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.freeDiskThresholdBytes, this.throttledProduceThroughput, this.logDirs, this.enableDiskBasedThrottling, this.diskCheckFrequencyMs, this.freeDiskThresholdBytesRecoveryFactor, this.clusterLinkEnabled);
    }

    public String toString() {
        return "DiskUsageBasedThrottlingConfig{freeDiskThresholdBytes=" + this.freeDiskThresholdBytes + ", throttledProduceThroughput=" + this.throttledProduceThroughput + ", logDirs=" + String.valueOf(this.logDirs) + ", enableDiskBasedThrottling=" + this.enableDiskBasedThrottling + ", diskCheckFrequencyMs=" + this.diskCheckFrequencyMs + ", freeDiskThresholdBytesRecoveryFactor=" + this.freeDiskThresholdBytesRecoveryFactor + ", clusterLinkEnabled=" + this.clusterLinkEnabled + "}";
    }
}

