/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.server.OffsetTruncationState;
import org.apache.kafka.server.ReplicaState;

public interface ClusterLinkReplicaState {
    public static final Waiting WAITING = new Waiting();
    public static final FetchingLatestOffset FETCHING_LATEST_OFFSET = new FetchingLatestOffset();
    public static final FetchingEarliestOffset FETCHING_EARLIEST_OFFSET = new FetchingEarliestOffset();
    public static final InitializingK2 INITIALIZING_K2 = new InitializingK2();

    public static final class Waiting
    implements ReplicaState {
        private Waiting() {
        }

        public String toString() {
            return "Waiting";
        }
    }

    public static final class FetchingLatestOffset
    implements ReplicaState {
        private FetchingLatestOffset() {
        }

        public String toString() {
            return "FetchingLatestOffset";
        }
    }

    public static final class FetchingEarliestOffset
    implements ReplicaState {
        private FetchingEarliestOffset() {
        }

        public String toString() {
            return "FetchingEarliestOffset";
        }
    }

    public static final class InitializingK2
    implements ReplicaState {
        private InitializingK2() {
        }

        public String toString() {
            return "InitializingK2";
        }
    }

    public static final class ValidatingTruncation
    implements ReplicaState {
        public final OffsetTruncationState truncationState;
        public Optional<Function<MetadataResponseData.MetadataResponseTopic, Boolean>> processTopicIdResponse = Optional.empty();
        public Optional<Supplier<Boolean>> failOnHigherLogEpoch = Optional.empty();
        public Optional<Function<Optional<OffsetForLeaderEpochResponseData.EpochEndOffset>, Boolean>> processSourceEpochResponse = Optional.empty();
        public Optional<Supplier<Boolean>> failOnTruncationBelowHwmDisallowed = Optional.empty();
        public Optional<OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> sourceEpochValidationData = Optional.empty();

        public ValidatingTruncation(OffsetTruncationState truncationState) {
            this.truncationState = truncationState;
        }

        public boolean hasValidationsPending() {
            return this.processTopicIdResponse.isPresent() || this.failOnHigherLogEpoch.isPresent() || this.processSourceEpochResponse.isPresent() || this.failOnTruncationBelowHwmDisallowed.isPresent();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValidatingTruncation)) {
                return false;
            }
            ValidatingTruncation that = (ValidatingTruncation)o;
            return this.truncationState.equals(that.truncationState);
        }

        public int hashCode() {
            return this.truncationState.hashCode();
        }

        public String toString() {
            return "ValidatingTruncation(" + String.valueOf(this.truncationState) + ")";
        }
    }
}

