/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.network.GenericConnectionQuotaEntity;
import org.apache.kafka.network.ListenerConnectionQuotaEntity;

public class ListenerIpQuotaEntity
implements ListenerConnectionQuotaEntity,
GenericConnectionQuotaEntity {
    private final InetAddress ip;
    private final String listenerName;

    public ListenerIpQuotaEntity(InetAddress ip, String listenerName) {
        this.ip = ip;
        this.listenerName = listenerName;
    }

    @Override
    public String rateSensorName() {
        return "Connection-Accept-Rate-" + this.listenerName + "-" + this.ip.getHostAddress();
    }

    @Override
    public String countSensorName() {
        return "Connection-Count-" + this.listenerName + "-" + this.ip.getHostAddress();
    }

    @Override
    public long sensorExpiration() {
        return INACTIVE_SENSOR_EXPIRATION_TIME_SECONDS;
    }

    @Override
    public String quotaMetricName() {
        return "connection-tokens";
    }

    @Override
    public String countMetricName() {
        return "authenticated-unthrottled-connection-count";
    }

    @Override
    public Map<String, String> metricTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", this.ip.getHostAddress());
        tags.put("listener", this.listenerName);
        return tags;
    }

    @Override
    public String domain() {
        return "listener-ip";
    }

    @Override
    public String entityName() {
        return this.ip.getHostAddress();
    }
}

