/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.storage.SegmentMetadataLayoutPutMode;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.BrokerSecurityConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.config.BrokerHealthCriteria;
import org.apache.kafka.server.config.QuotaCoordinatorDefaultConfig;

public class Defaults {
    public static final int BROKER_ID = -1;
    public static final int EMPTY_NODE_ID = -1;
    public static final long SERVER_MAX_STARTUP_TIME_MS = Long.MAX_VALUE;
    public static final int MIGRATION_METADATA_MIN_BATCH_SIZE = 200;
    public static final String AUTHORIZER_CLASS_NAME = "";
    public static final boolean REQUEST_PIPELINING_ENABLE = true;
    public static final int REQUEST_PIPELINING_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = 5;
    public static final short PRODUCER_MIN_ACKS = 0;
    public static final boolean METADATA_REJECT_WHEN_THROTTLED_ENABLE = false;
    public static final int PRODUCER_ID_CACHE_LIMIT = Integer.MAX_VALUE;
    public static final int TOPIC_METADATA_THROTTLE_PRECHECK_PARTITION_COUNT_THRESHOLD = 1000;
    public static final boolean PRODUCER_ID_THROTTLE_ENABLE = false;
    public static final int PRODUCER_ID_THROTTLE_ENABLE_THRESHOLD_PERCENTAGE = 100;
    public static final int PRODUCER_ID_CACHE_BROKER_HARD_LIMIT = -1;
    public static final int PRODUCER_ID_CACHE_TENANT_HARD_LIMIT = -1;
    public static final int PRODUCER_ID_CACHE_PARTITION_HARD_LIMIT = -1;
    public static final int PRODUCER_ID_CACHE_EXTRA_EVICTION_PERCENTAGE = 0;
    public static final long PRODUCER_ID_CACHE_EVICTION_MINIMAL_EXPIRATION_MS = 900000L;
    public static final int MAX_INCREMENTAL_FETCH_SESSION_CACHE_SLOTS = 1000;
    public static final boolean FETCH_PARTITION_PRUNING_ENABLE = true;
    public static final boolean CONSUMER_FETCH_PARTITION_PRUNING_ENABLE = true;
    public static final boolean FETCH_FROM_FOLLOWER_REQUIRE_LEADER_EPOCH = false;
    public static final long QUOTA_BYTES_PER_SECOND = Long.MAX_VALUE;
    public static final int NUM_PRODUCER_ID_QUOTA_SAMPLES = 11;
    public static final long LEADER_REPLICATION_THROTTLED_RATE = Long.MAX_VALUE;
    public static final long FOLLOWER_REPLICATION_THROTTLED_RATE = Long.MAX_VALUE;
    public static final String LEADER_REPLICATION_THROTTLED_REPLICAS = "none";
    public static final String FOLLOWER_REPLICATION_THROTTLED_REPLICAS = "none";
    public static final int PRODUCER_ID_QUOTA_WINDOW_SIZE_SECONDS = 1;
    public static final boolean CONFLUENT_INTERNAL_METRICS_ENABLE = false;
    public static final long ACKS_EQUAL_TO_ONE_REQUEST_REPLICATION_LAG_THRESHOLD_MS = -1L;
    public static final String SSL_PROTOCOL = "TLSv1.3";
    public static final String SSL_ENABLED_PROTOCOLS = "TLSv1.2,TLSv1.3";
    public static final String SSL_KEYSTORE_TYPE = "JKS";
    public static final String SSL_TRUSTSTORE_TYPE = "JKS";
    public static final String SSL_KEY_MANAGER_ALGORITHM = SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM;
    public static final String SSL_TRUST_MANAGER_ALGORITHM = SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;
    public static final String SSL_ENDPOINT_IDENTIFICATION_ALGORITHM = "https";
    public static final String SSL_CLIENT_AUTHENTICATION = SslClientAuth.NONE.name().toLowerCase(Locale.ROOT);
    public static final String[] SSL_CLIENT_AUTHENTICATION_VALID_VALUES = (String[])SslClientAuth.VALUES.stream().map(v -> v.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
    public static final String SSL_PRINCIPAL_MAPPING_RULES = "DEFAULT";
    public static final long CONNECTIONS_MAX_REAUTH_MS = 0L;
    public static final int SERVER_MAX_RECEIVE_SIZE = 524288;
    public static final Class<? extends KafkaPrincipalBuilder> PRINCIPAL_BUILDER = DefaultKafkaPrincipalBuilder.class;
    public static final String SASL_MECHANISM_INTER_BROKER_PROTOCOL = "GSSAPI";
    public static final List<String> SASL_ENABLED_MECHANISMS = BrokerSecurityConfigs.DEFAULT_SASL_ENABLED_MECHANISMS;
    public static final String SASL_KERBEROS_KINIT_CMD = "/usr/bin/kinit";
    public static final double SASL_KERBEROS_TICKET_RENEW_WINDOW_FACTOR = 0.8;
    public static final double SASL_KERBEROS_TICKET_RENEW_JITTER = 0.05;
    public static final long SASL_KERBEROS_MIN_TIME_BEFORE_RELOGIN = 60000L;
    public static final List<String> SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES = BrokerSecurityConfigs.DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES;
    public static final double SASL_LOGIN_REFRESH_WINDOW_FACTOR = 0.8;
    public static final double SASL_LOGIN_REFRESH_WINDOW_JITTER = 0.05;
    public static final short SASL_LOGIN_REFRESH_MIN_PERIOD_SECONDS = 60;
    public static final short SASL_LOGIN_REFRESH_BUFFER_SECONDS = 300;
    public static final long SASL_LOGIN_RETRY_BACKOFF_MAX_MS = 10000L;
    public static final long SASL_LOGIN_RETRY_BACKOFF_MS = 100L;
    public static final String SASL_OAUTH_BEARER_SCOPE_CLAIM_NAME = "scope";
    public static final String SASL_OAUTH_BEARER_SUB_CLAIM_NAME = "sub";
    public static final long SASL_OAUTH_BEARER_JWKS_ENDPOINT_REFRESH_MS = 3600000L;
    public static final long SASL_OAUTH_BEARER_JWKS_ENDPOINT_RETRY_BACKOFF_MAX_MS = 10000L;
    public static final long SASL_OAUTH_BEARER_JWKS_ENDPOINT_RETRY_BACKOFF_MS = 100L;
    public static final int SASL_OAUTH_BEARER_CLOCK_SKEW_SECONDS = 30;
    public static final long DELEGATION_TOKEN_MAX_LIFE_TIME_MS = 604800000L;
    public static final long DELEGATION_TOKEN_EXPIRY_TIME_MS = 86400000L;
    public static final long DELEGATION_TOKEN_EXPIRY_CHECK_INTERVAL_MS = 3600000L;
    public static final List<String> QUORUM_VOTERS = QuorumConfig.DEFAULT_QUORUM_VOTERS;
    public static final int QUORUM_ELECTION_TIMEOUT_MS = 1000;
    public static final int QUORUM_FETCH_TIMEOUT_MS = 2000;
    public static final int QUORUM_ELECTION_BACKOFF_MS = 1000;
    public static final int QUORUM_LINGER_MS = 25;
    public static final int QUORUM_REQUEST_TIMEOUT_MS = 2000;
    public static final int QUORUM_RETRY_BACKOFF_MS = 20;
    public static final boolean DISK_IO_MANAGER_ENABLE = false;
    public static final long DISK_THROUGHPUT_LIMIT_BYTE_PER_SEC = 10485760000L;
    public static final long DISK_THROUGHPUT_HEADROOM_BYTE_PER_SEC = 0xA00000L;
    public static final long DISK_THROUGHPUT_QUOTA_FOR_TIER_ARCHIVE_BYTE_PER_SEC = 1048576000L;
    public static final long DISK_THROUGHPUT_THROTTLED_QUOTA_FOR_TIER_ARCHIVE_BYTE_PER_SEC = 0x6400000L;
    public static final boolean TIER_FEATURE = false;
    public static final String TIER_BACKEND = "";
    public static final String TIER_METADATA_BOOTSTRAP_SERVERS = null;
    public static final long TIER_METADATA_MAX_POLL_MS = 100L;
    public static final long TIER_METADATA_CATCHUP_MAX_POLL_MS = 0L;
    public static final int TIER_METADATA_REQUEST_TIMEOUT_MS = 30000;
    public static final String TIER_METADATA_NAMESPACE = null;
    public static final short TIER_METADATA_NUM_PARTITIONS = 50;
    public static final boolean TIER_TOPIC_PRODUCER_ENABLE_IDEMPOTENCE = true;
    public static final boolean TIER_TOPIC_DATA_LOSS_DETECTION_ENABLE = true;
    public static final long TIER_TOPIC_DATA_LOSS_DETECTION_MAX_TIMEOUT_MS = 900000L;
    public static final boolean TIER_TOPIC_FENCING_DURING_DATA_LOSS_ENABLE = false;
    public static final boolean TIER_TOPIC_MATERIALIZATION_FROM_SNAPSHOT_ENABLE = false;
    public static final short TIER_METADATA_REPLICATION_FACTOR = 3;
    public static final String TIER_S3_BUCKET = null;
    public static final String TIER_S3_REGION = null;
    public static final String TIER_S3_PREFIX = "";
    public static final String TIER_S3_SSE_ALGORITHM = "AES256";
    public static final String TIER_S3_SSE_CUSTOMER_ENCRYPTION_KEY = null;
    public static final String TIER_GCS_SSE_CUSTOMER_ENCRYPTION_KEY = null;
    public static final String TIER_S3_CRED_FILE_PATH = null;
    public static final String TIER_S3_ENDPOINT_OVERRIDE = null;
    public static final boolean TIER_S3_FORCE_PATH_STYLE_ACCESS = false;
    public static final String TIER_S3_SIGNER_OVERRIDE = null;
    public static final int TIER_S3_AUTO_ABORT_THRESHOLD_BYTES = 500000;
    public static final String TIER_S3_ASSUME_ROLE_ARN = null;
    public static final String TIER_S3_USER_AGENT_PREFIX = "APN/1.0 Confluent/1.0 TieredStorageS3/1.0";
    public static final String TIER_S3_SSL_PROTOCOL = "TLSv1.3";
    public static final String TIER_S3_SSL_ENABLED_PROTOCOLS = "TLSv1.2,TLSv1.3";
    public static final String TIER_S3_SSL_TRUST_STORE_LOCATION = null;
    public static final Password TIER_S3_SSL_TRUST_STORE_PASSWORD = null;
    public static final String TIER_S3_SSL_TRUST_STORE_TYPE = null;
    public static final String TIER_S3_SSL_KEY_STORE_LOCATION = null;
    public static final Password TIER_S3_SSL_KEY_STORE_PASSWORD = null;
    public static final String TIER_S3_SSL_KEY_STORE_TYPE = null;
    public static final Password TIER_S3_SSL_KEY_PASSWORD = null;
    public static final String TIER_S3_SSL_PROVIDER = null;
    public static final String TIER_S3_SECURITY_PROVIDERS = null;
    public static final String TIER_S3_STORAGE_CLASS_OVERRIDE = "";
    public static final boolean TIER_S3_IPV6_ENABLED = true;
    public static final boolean TIER_S3_V2_ENABLED = false;
    public static final int TIER_FETCHER_NUM_THREADS = 4;
    public static final int TIER_FETCHER_OFFSET_CACHE_SIZE = 200000;
    public static final int TIER_FETCHER_OFFSET_CACHE_EXPIRATION_MS = 1800000;
    public static final int TIER_FETCHER_OFFSET_CACHE_EXPIRY_PERIOD_MS = 60000;
    public static final long TIER_FETCHER_MEMORY_POOL_SIZE_BYTES = 0L;
    public static final boolean TIER_FETCHER_ASYNC_ENABLE = false;
    public static final int TIER_FETCHER_ASYNC_OFFSET_FOR_TIMESTAMP_PARALLELISM = 1;
    public static final boolean TIER_PREFETCH_CACHE_ENABLE = false;
    public static final long TIER_PREFETCH_CACHE_RANGE_BYTES = 0x500000L;
    public static final long TIER_PREFETCH_CACHE_ENTRY_SIZE_BYTES = 0x100000L;
    public static final long TIER_PREFETCH_CACHE_TOTAL_SIZE_BYTES = 0xC800000L;
    public static final boolean TIER_FETCH_BASED_ON_SEGMENT_AND_METADATA_LAYOUT_FIELD = false;
    public static final int TIER_MAX_PARTITION_FETCH_BYTES_OVERRIDE = 0;
    public static final int TIER_OBJECT_FETCHER_THREADS = 1;
    public static final int TIER_PARTITION_STATE_COMMIT_INTERVAL = 15000;
    public static final boolean TIER_PARTITION_STATE_CLEANUP_ENABLE = false;
    public static final long TIER_PARTITION_STATE_CLEANUP_DELAY_MS = 2592000000L;
    public static final long TIER_PARTITION_STATE_CLEANUP_INTERVAL_MS = 86400000L;
    public static final long TIER_FENCED_SEGMENT_DELETE_DELAY_MS = 600000L;
    public static final int TIER_ARCHIVER_NUM_THREADS = 2;
    public static final String TIER_GCS_BUCKET = null;
    public static final String TIER_GCS_PREFIX = "";
    public static final String TIER_GCS_REGION = null;
    public static final int TIER_GCS_WRITE_CHUNK_SIZE = 0;
    public static final String TIER_GCS_CRED_FILE_PATH = null;
    public static final long TIER_TOPIC_DELETE_CHECK_INTERVAL_MS = 300000L;
    public static final int TIER_TOPIC_DELETE_MAX_IN_PROGRESS_PARTITIONS = 100;
    public static final long TIER_TOPIC_DELETE_BACKOFF_MS = 21600000L;
    public static final boolean TENANT_AWARE_ENCRYPTION_KEY_MANAGER_ENABLE = false;
    public static final long TENANT_AWARE_ENCRYPTION_KEY_MANAGER_KEY_ROTATION_INTERVAL_MS = TimeUnit.DAYS.toMillis(365L);
    public static final int TENANT_AWARE_ENCRYPTION_KEY_MANAGER_MAX_TENANT_KEY_CACHE_SIZE = 100;
    public static final long TENANT_AWARE_ENCRYPTION_KEY_MANAGER_TENANT_KEY_CACHE_EVICTION_TIME_SEC = TimeUnit.DAYS.toSeconds(2L);
    public static final boolean TENANT_AWARE_ENCRYPTION_KEY_MANAGER_PROACTIVE_KEY_GENERATION_ENABLE = false;
    public static final long ENCRYPTION_KEY_MANAGER_KEY_ROTATION_INTERVAL_MS = TimeUnit.DAYS.toMillis(365L);
    public static final long PREFER_TIER_FETCH_MS = -1L;
    public static final String TIER_SEGMENT_METADATA_LAYOUT_PUT_MODE = SegmentMetadataLayoutPutMode.LegacyMultiObject.name();
    public static final boolean TIER_CLEANER_FEATURE_ENABLE = false;
    public static final boolean TIER_CLEANER_ENABLE = false;
    public static final String TIER_CLEANER_EXCLUDED_TOPICS = "^_confluent.*";
    public static final int TIER_CLEANER_NUM_THREADS = 2;
    public static final double TIER_CLEANER_COMPACT_MIN_EFFICIENCY = 0.5;
    public static final double TIER_CLEANER_IO_MAX_BYTES_PER_SECOND = Double.MAX_VALUE;
    public static final long TIER_CLEANER_DEDUPE_BUFFER_SIZE = 0x8000000L;
    public static final int TIER_CLEANER_IO_BUFFER_SIZE = 0xA00000;
    public static final double TIER_CLEANER_DEDUPE_BUFFER_LOAD_FACTOR = 0.9;
    public static final int TIER_CLEANER_DUAL_COMPACTION_VALIDATION_PERCENT = 0;
    public static final long TIER_CLEANER_DUAL_COMPACTION_VALIDATION_MAX_BYTES = 0x40000000L;
    public static final boolean TIER_PARTITION_STATE_METADATA_SNAPSHOTS_ENABLE = false;
    public static final long TIER_PARTITION_STATE_METADATA_SNAPSHOTS_INTERVAL_MS = TimeUnit.DAYS.toMillis(1L);
    public static final int TIER_PARTITION_STATE_METADATA_SNAPSHOTS_THREADS = 2;
    public static final int TIER_PARTITION_STATE_METADATA_SNAPSHOTS_MIN_THREADS = 1;
    public static final int TIER_PARTITION_STATE_METADATA_SNAPSHOTS_MAX_THREADS = 10;
    public static final int TIER_PARTITION_STATE_METADATA_SNAPSHOTS_RETENTION_DAYS = 7;
    public static final int TIER_PARTITION_STATE_METADATA_SNAPSHOTS_MIN_RETENTION_DAYS = 2;
    public static final boolean TIER_TOPIC_SNAPSHOTS_ENABLE = false;
    public static final long TIER_TOPIC_SNAPSHOTS_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    public static final long TIER_TOPIC_SNAPSHOTS_MIN_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    public static final long TIER_TOPIC_SNAPSHOTS_MIN_RECORDS_PER_SNAPSHOT = 1000L;
    public static final long TIER_TOPIC_SNAPSHOTS_MAX_RECORDS_PER_SNAPSHOT = 100000L;
    public static final int TIER_TOPIC_SNAPSHOTS_RETENTION_HOURS = 168;
    public static final int TIER_TOPIC_SNAPSHOTS_MIN_RETENTION_HOURS = 24;
    public static final String TIER_AZURE_BLOCK_BLOB_CRED_FILE_PATH = null;
    public static final String TIER_AZURE_BLOCK_BLOB_CONTAINER = null;
    public static final String TIER_AZURE_BLOCK_BLOB_ENDPOINT = null;
    public static final int TIER_AZURE_BLOCK_BLOB_AUTO_ABORT_THRESHOLD_BYTES = 500000;
    public static final String TIER_AZURE_BLOCK_BLOB_PREFIX = "";
    public static final boolean CUSTOM_LIFECYCLE_MANAGER_ENABLED = false;
    public static final int CUSTOM_LIFECYCLE_MANAGER_FREQUENCY_IN_HOURS = 6;
    public static final int CLM_MAX_BACKUP_IN_DAYS = 3;
    public static final String CLM_TOPIC_RETENTION_IN_DAYS_TO_BACKUP_IN_DAYS = "0:0,3:3";
    public static final int CLM_MIN_DELAY_IN_MINUTES = 30;
    public static final int CLM_THREAD_POOL_SIZE = 2;
    public static final int CLM_LIST_OBJECT_THREAD_POOL_SIZE = 1;
    public static final boolean BROKER_HEALTH_MANAGER_ENABLED = true;
    public static final boolean BROKER_HEALTH_MANAGER_MITIGATION_ENABLED = false;
    public static final int BROKER_HEALTH_MANAGER_SAMPLE_DURATION_MS = 1000;
    public static final int BROKER_HEALTH_MANAGER_HARD_KILL_DURATION_MS = 60000;
    public static final int BROKER_HEALTH_MANAGER_NUM_SAMPLES_BEFORE_BROKER_UNHEALTHY = 180;
    public static final int BROKER_HEALTH_MANAGER_NUM_SAMPLES_BEFORE_BROKER_SUSPECT = 30;
    public static final int BROKER_HEALTH_MANAGER_PERCENTAGE_UNHEALTHY_SAMPLES_FOR_HEALTHY_TO_SUSPECT_STATE_TRANSITION = 90;
    public static final int BROKER_HEALTH_MANAGER_PERCENTAGE_UNHEALTHY_SAMPLES_FOR_SUSPECT_TO_UNHEALTHY_STATE_TRANSITION = 70;
    public static final String BROKER_HEALTH_MANAGER_STORAGE_REQUEST_HANDLER_THREADS_STUCK_CRITERIA = BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AnyThreadStuck.toString();
    public static final String BROKER_HEALTH_MANAGER_STORAGE_BACKGROUND_THREADS_STUCK_CRITERIA = BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AnyThreadStuck.toString();
    public static final String BROKER_HEALTH_MANAGER_STORAGE_NETWORK_THREADS_STUCK_CRITERIA = BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AnyThreadStuck.toString();
    public static final String BROKER_HEALTH_MANAGER_ENGINE_REQUEST_HANDLER_THREADS_STUCK_CRITERIA = BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AllThreadsStuck.toString();
    public static final boolean NETWORK_HEALTH_MANAGER_ENABLED = false;
    public static final boolean NETWORK_HEALTH_MANAGER_MITIGATION_ENABLED = false;
    public static final int NETWORK_HEALTH_MANAGER_SAMPLE_DURATION_MS = 1000;
    public static final int NETWORK_HEALTH_MANAGER_NETWORK_SAMPLE_WINDOW_SIZE = 120;
    public static final int NETWORK_HEALTH_MANAGER_MIN_HEALTHY_NETWORK_SAMPLES = 3;
    public static final int NETWORK_HEALTH_MANAGER_MIN_PERCENTAGE_HEALTHY_NETWORK_SAMPLES = 3;
    public static final boolean NETWORK_HEALTH_MANAGER_EXTERNAL_CONNECTIVITY_STARTUP_ENABLED = false;
    public static final String NETWORK_HEALTH_MANAGER_EXTERNAL_LISTENER_NAME = "EXTERNAL";
    public static final int ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS = ConfluentConfigs.ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_DEFAULT;
    public static final int ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE = ConfluentConfigs.ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE_DEFAULT;
    public static final int AUTOMATIC_ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS = ConfluentConfigs.AUTOMATIC_ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS_DEFAULT;
    public static final String TOPIC_PLACEMENT_CONSTRAINTS = "";
    public static final long STORAGE_PROBE_PERIOD_MS = -1L;
    public static final long STORAGE_PROBE_SLOW_WRITE_THRESHOLD_MS = 5000L;
    public static final boolean STORAGE_PROBE_DISK_METRICS_COLLECTION_ENABLED = false;
    public static final long TIER_BUCKET_PROBE_PERIOD_MS = -1L;
    public static final long BROKER_STARTUP_REGISTRATION_DELAY = 0L;
    public static final int MAX_REQUEST_PARTITION_SIZE_LIMIT = 2000;
    public static final boolean QUOTAS_DYNAMIC_QUOTA_ENABLED = false;
    public static final int QUOTAS_TOPIC_PARTITIONS = 50;
    public static final short QUOTAS_TOPIC_REPLICATION_FACTOR = 3;
    public static final int QUOTAS_TOPIC_SEGMENT_BYTES = 0x6400000;
    public static final int QUOTAS_LOAD_BUFFER_SIZE = 0x500000;
    public static final CompressionType QUOTAS_TOPIC_COMPRESSION_TYPE = QuotaCoordinatorDefaultConfig.DEFAULT_COMPRESSION_TYPE;
    public static final int QUOTAS_TOPIC_APPEND_TIMEOUT_MS = 5000;
    public static final String QUOTAS_TOPIC_PLACEMENT_CONSTRAINTS = "";
    public static final int QUOTAS_EXPIRATION_TIME_MS = 604800000;
    public static final int QUOTAS_EXPIRATION_INTERVAL_MS = 3600000;
    public static final int QUOTAS_CONSUMPTION_EXPIRATION_TIME_MS = 600000;
    public static final double QUOTAS_LAZY_EVALUATION_THRESHOLD = 0.5;
    public static final boolean ELASTIC_CKU_ENABLED = false;
    public static final boolean ELASTIC_CKU_SCALE_TO_ZERO_ENABLED = false;
    public static final boolean TENANT_LATENCY_METRIC_ENABLED = false;
    public static final long CLUSTER_LINK_IO_MAX_BYTES_PER_SECOND = Long.MAX_VALUE;
    public static final ConfluentConfigs.ClusterLinkQuotaMode CLUSTER_LINK_QUOTA_MODE = ConfluentConfigs.ClusterLinkQuotaMode.CLUSTER_LINK_ONLY;
    public static final int NUM_CLUSTER_LINK_REPLICATION_QUOTA_SAMPLES = 11;
    public static final int CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS = 2;
    public static final int CLUSTER_LINK_REQUEST_QUOTA_CAPACITY = 400;
    public static final int CLUSTER_LINK_FETCH_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    public static final int CLUSTER_LINK_FETCH_RESPONSE_MIN_BYTES = 1;
    public static final boolean CLUSTER_LINK_METADATA_TOPIC_ENABLE = false;
    public static final short CLUSTER_LINK_METADATA_TOPIC_REPLICATION_FACTOR = 3;
    public static final short CLUSTER_LINK_METADATA_TOPIC_MIN_IN_SYNC_REPLICAS = 2;
    public static final long CLUSTER_LINK_METADATA_TOPIC_CREATE_RETRY_DELAY_MS = 1000L;
    public static final boolean CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT = ConfluentConfigs.CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT_DEFAULT;
    public static final int CLUSTER_LINK_IN_SYNC_FETCH_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    public static final int CLUSTER_LINK_IN_SYNC_FETCH_RESPONSE_MIN_BYTES = 1;
    public static final String CLUSTER_LINK_FETCHER_THREAD_POOL_MODE_DEFAULT = ClusterLinkConfig.FetcherThreadPoolMode.ENDPOINT.toString();
    public static final int K2_TOPIC_METADATA_REFRESH_MS = 10000;
    public static final int K2_STARTUP_TIMEOUT_MS = 60000;
}

