/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;

public class ReplicationConfigs {
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String CONTROLLER_SOCKET_TIMEOUT_MS_CONFIG = "controller.socket.timeout.ms";
    public static final int CONTROLLER_SOCKET_TIMEOUT_MS_DEFAULT = 30000;
    public static final String CONTROLLER_SOCKET_TIMEOUT_MS_DOC = "The socket timeout for controller-to-broker channels.";
    public static final String DEFAULT_REPLICATION_FACTOR_CONFIG = "default.replication.factor";
    public static final int REPLICATION_FACTOR_DEFAULT = 1;
    public static final String DEFAULT_REPLICATION_FACTOR_DOC = "The replication factor for automatically created topics, and for topics created with -1 as the replication factor";
    public static final String REPLICA_LAG_TIME_MAX_MS_CONFIG = "replica.lag.time.max.ms";
    public static final long REPLICA_LAG_TIME_MAX_MS_DEFAULT = 30000L;
    public static final String REPLICA_LAG_TIME_MAX_MS_DOC = "If a follower hasn't sent any fetch requests or hasn't consumed up to the leader's log end offset for at least this time, the leader will remove the follower from ISR";
    public static final String REPLICA_SOCKET_TIMEOUT_MS_CONFIG = "replica.socket.timeout.ms";
    public static final int REPLICA_SOCKET_TIMEOUT_MS_DEFAULT = 30000;
    public static final String REPLICA_SOCKET_TIMEOUT_MS_DOC = "The socket timeout for network requests. Its value should be at least replica.fetch.wait.max.ms";
    public static final String REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_CONFIG = "replica.socket.receive.buffer.bytes";
    public static final int REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_DEFAULT = 65536;
    public static final String REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_DOC = "The socket receive buffer for network requests to the leader for replicating data";
    public static final String REPLICA_FETCH_MAX_BYTES_CONFIG = "replica.fetch.max.bytes";
    public static final int REPLICA_FETCH_MAX_BYTES_DEFAULT = 0x100000;
    public static final String REPLICA_FETCH_MAX_BYTES_DOC = "The number of bytes of messages to attempt to fetch for each partition. This is not an absolute maximum, if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).";
    public static final String REPLICA_FETCH_WAIT_MAX_MS_CONFIG = "replica.fetch.wait.max.ms";
    public static final int REPLICA_FETCH_WAIT_MAX_MS_DEFAULT = 500;
    public static final String REPLICA_FETCH_WAIT_MAX_MS_DOC = "The maximum wait time for each fetcher request issued by follower replicas. This value should always be less than the replica.lag.time.max.ms at all times to prevent frequent shrinking of ISR for low throughput topics";
    public static final String REPLICA_FETCH_MIN_BYTES_CONFIG = "replica.fetch.min.bytes";
    public static final int REPLICA_FETCH_MIN_BYTES_DEFAULT = 1;
    public static final String REPLICA_FETCH_MIN_BYTES_DOC = "Minimum bytes expected for each fetch response. If not enough bytes, wait up to <code>replica.fetch.wait.max.ms</code> (broker config).";
    public static final String REPLICA_FETCH_BACKOFF_MS_CONFIG = "replica.fetch.backoff.ms";
    public static final int REPLICA_FETCH_BACKOFF_MS_DEFAULT = 1000;
    public static final String REPLICA_FETCH_BACKOFF_MS_DOC = "The base amount of time to wait when fetch partition error occurs. The backoff increases exponentially for each consecutive failure up to replica.fetch.backoff.ms";
    public static final String REPLICA_FETCH_BACKOFF_MAX_MS_CONFIG = "confluent.replica.fetch.backoff.max.ms";
    public static final int REPLICA_FETCH_BACKOFF_MAX_MS_DEFAULT = 1000;
    public static final String REPLICA_FETCH_BACKOFF_MAX_MS_DOC = "The maximum amount of time in milliseconds to wait when fetch partition fails repeatedly. If provided, the backoff will increase exponentially for each consecutive failure, up to this maximum.";
    public static final String REPLICA_FETCH_CONNECTIONS_MODE_CONFIG = "confluent.replica.fetch.connections.mode";
    public static final String REPLICA_FETCH_CONNECTIONS_MODE_DOC = "Mode of how replicas are distributed among fetcher threads. <code>combined</code>: replicas will be added to default fetcher threads and no extra in-sync fetcher threads will be created. Fetch request connections will have combined in-sync and out-of-sync replicas.<code>isolated</code>: replicas will be added to default fetcher threads initially. When a replica becomes in-sync, it will be migrated to a new in-sync fetcher thread thus not blocked by out-of-sync replicas in a fetch request.";
    public static final String REPLICA_FETCH_RESPONSE_MAX_BYTES_CONFIG = "replica.fetch.response.max.bytes";
    public static final int REPLICA_FETCH_RESPONSE_MAX_BYTES_DEFAULT = 0xA00000;
    public static final String REPLICA_FETCH_RESPONSE_MAX_BYTES_DOC = "Maximum bytes expected for the entire fetch response. Records are fetched in batches, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. As such, this is not an absolute maximum. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).";
    public static final String NUM_REPLICA_FETCHERS_CONFIG = "num.replica.fetchers";
    public static final int NUM_REPLICA_FETCHERS_DEFAULT = 1;
    public static final String NUM_REPLICA_FETCHERS_DOC = "Number of fetcher threads used to replicate records from each source broker. The total number of fetchers on each broker is bound by <code>num.replica.fetchers</code> multiplied by the number of brokers in the cluster.Increasing this value can increase the degree of I/O parallelism in the follower and leader broker at the cost of higher CPU and memory utilization.";
    public static final String REPLICA_HIGH_WATERMARK_CHECKPOINT_INTERVAL_MS_CONFIG = "replica.high.watermark.checkpoint.interval.ms";
    public static final long REPLICA_HIGH_WATERMARK_CHECKPOINT_INTERVAL_MS_DEFAULT = 5000L;
    public static final String REPLICA_HIGH_WATERMARK_CHECKPOINT_INTERVAL_MS_DOC = "The frequency with which the high watermark is saved out to disk";
    public static final String FETCH_PURGATORY_PURGE_INTERVAL_REQUESTS_CONFIG = "fetch.purgatory.purge.interval.requests";
    public static final int FETCH_PURGATORY_PURGE_INTERVAL_REQUESTS_DEFAULT = 1000;
    public static final String FETCH_PURGATORY_PURGE_INTERVAL_REQUESTS_DOC = "The purge interval (in number of requests) of the fetch request purgatory";
    public static final String PRODUCER_PURGATORY_PURGE_INTERVAL_REQUESTS_CONFIG = "producer.purgatory.purge.interval.requests";
    public static final int PRODUCER_PURGATORY_PURGE_INTERVAL_REQUESTS_DEFAULT = 1000;
    public static final String PRODUCER_PURGATORY_PURGE_INTERVAL_REQUESTS_DOC = "The purge interval (in number of requests) of the producer request purgatory";
    public static final String DELETE_RECORDS_PURGATORY_PURGE_INTERVAL_REQUESTS_CONFIG = "delete.records.purgatory.purge.interval.requests";
    public static final int DELETE_RECORDS_PURGATORY_PURGE_INTERVAL_REQUESTS_DEFAULT = 1;
    public static final String DELETE_RECORDS_PURGATORY_PURGE_INTERVAL_REQUESTS_DOC = "The purge interval (in number of requests) of the delete records request purgatory";
    public static final String LEADER_IMBALANCE_CHECK_INTERVAL_SECONDS_CONFIG = "leader.imbalance.check.interval.seconds";
    public static final int LEADER_IMBALANCE_CHECK_INTERVAL_SECONDS_DEFAULT = 300;
    public static final String LEADER_IMBALANCE_CHECK_INTERVAL_SECONDS_DOC = "The frequency with which the partition rebalance check is triggered by the controller";
    public static final String UNCLEAN_LEADER_ELECTION_INTERVAL_MS_CONFIG = "unclean.leader.election.interval.ms";
    public static final long UNCLEAN_LEADER_ELECTION_INTERVAL_MS_DEFAULT = TimeUnit.MINUTES.toMillis(5L);
    public static final String UNCLEAN_LEADER_ELECTION_INTERVAL_MS_DOC = "The frequency with which the controller checks if it should perform an unclean leader election for leaderless partitions.";
    public static final String UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG = ServerTopicConfigSynonyms.serverSynonym((String)"unclean.leader.election.enable");
    public static final String UNCLEAN_LEADER_ELECTION_ENABLE_DOC = "Indicates whether to enable replicas not in the ISR set to be elected as leader as a last resort, even though doing so may result in data loss<p>Note: In KRaft mode, when enabling this config dynamically, it needs to wait for the unclean leader election thread to trigger election periodically (default is 5 minutes). Please run `kafka-leader-election.sh` with `unclean` option to trigger the unclean leader election immediately if needed.</p>";
    public static final String INTER_BROKER_SECURITY_PROTOCOL_CONFIG = "security.inter.broker.protocol";
    public static final String INTER_BROKER_SECURITY_PROTOCOL_DEFAULT = SecurityProtocol.PLAINTEXT.toString();
    public static final String INTER_BROKER_LISTENER_NAME_CONFIG = "inter.broker.listener.name";
    public static final String INTER_BROKER_SECURITY_PROTOCOL_DOC = "Security protocol used to communicate between brokers. It is an error to set this and inter.broker.listener.name properties at the same time.";
    public static final String INTER_BROKER_LISTENER_NAME_DOC = "Name of listener used for communication between brokers. If this is unset, the listener name is defined by security.inter.broker.protocol. It is an error to set this and security.inter.broker.protocol properties at the same time.";
    public static final String REPLICA_SELECTOR_CLASS_CONFIG = "replica.selector.class";
    public static final String REPLICA_SELECTOR_CLASS_DOC = "The fully qualified class name that implements ReplicaSelector. This is used by the broker to find the preferred read replica. By default, we use an implementation that returns the leader.";
    public static final String AUTO_LEADER_REBALANCE_ENABLE_CONFIG = "auto.leader.rebalance.enable";
    public static final boolean AUTO_LEADER_REBALANCE_ENABLE_DEFAULT = true;
    public static final String AUTO_LEADER_REBALANCE_ENABLE_DOC = String.format("Enables auto leader balancing. A background thread checks the distribution of partition leaders at regular intervals, configurable by %s. If the leader is imbalanced, leader rebalance to the preferred leader for partitions is triggered.", "leader.imbalance.check.interval.seconds");
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("controller.socket.timeout.ms", ConfigDef.Type.INT, (Object)30000, ConfigDef.Importance.MEDIUM, "The socket timeout for controller-to-broker channels.").define("default.replication.factor", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, "The replication factor for automatically created topics, and for topics created with -1 as the replication factor").define("replica.lag.time.max.ms", ConfigDef.Type.LONG, (Object)30000L, ConfigDef.Importance.HIGH, "If a follower hasn't sent any fetch requests or hasn't consumed up to the leader's log end offset for at least this time, the leader will remove the follower from ISR").define("replica.socket.timeout.ms", ConfigDef.Type.INT, (Object)30000, ConfigDef.Importance.HIGH, "The socket timeout for network requests. Its value should be at least replica.fetch.wait.max.ms").define("replica.socket.receive.buffer.bytes", ConfigDef.Type.INT, (Object)65536, ConfigDef.Importance.HIGH, "The socket receive buffer for network requests to the leader for replicating data").define("replica.fetch.max.bytes", ConfigDef.Type.INT, (Object)0x100000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The number of bytes of messages to attempt to fetch for each partition. This is not an absolute maximum, if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("replica.fetch.wait.max.ms", ConfigDef.Type.INT, (Object)500, ConfigDef.Importance.HIGH, "The maximum wait time for each fetcher request issued by follower replicas. This value should always be less than the replica.lag.time.max.ms at all times to prevent frequent shrinking of ISR for low throughput topics").define("replica.fetch.backoff.ms", ConfigDef.Type.INT, (Object)1000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The base amount of time to wait when fetch partition error occurs. The backoff increases exponentially for each consecutive failure up to replica.fetch.backoff.ms").define("replica.fetch.min.bytes", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.HIGH, "Minimum bytes expected for each fetch response. If not enough bytes, wait up to <code>replica.fetch.wait.max.ms</code> (broker config).").define("replica.fetch.response.max.bytes", ConfigDef.Type.INT, (Object)0xA00000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "Maximum bytes expected for the entire fetch response. Records are fetched in batches, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. As such, this is not an absolute maximum. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("num.replica.fetchers", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.HIGH, "Number of fetcher threads used to replicate records from each source broker. The total number of fetchers on each broker is bound by <code>num.replica.fetchers</code> multiplied by the number of brokers in the cluster.Increasing this value can increase the degree of I/O parallelism in the follower and leader broker at the cost of higher CPU and memory utilization.").define("replica.high.watermark.checkpoint.interval.ms", ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.HIGH, "The frequency with which the high watermark is saved out to disk").define("fetch.purgatory.purge.interval.requests", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, "The purge interval (in number of requests) of the fetch request purgatory").define("producer.purgatory.purge.interval.requests", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, "The purge interval (in number of requests) of the producer request purgatory").define("delete.records.purgatory.purge.interval.requests", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, "The purge interval (in number of requests) of the delete records request purgatory").define("auto.leader.rebalance.enable", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, AUTO_LEADER_REBALANCE_ENABLE_DOC).define("leader.imbalance.check.interval.seconds", ConfigDef.Type.LONG, (Object)300, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The frequency with which the partition rebalance check is triggered by the controller").defineInternal("unclean.leader.election.interval.ms", ConfigDef.Type.LONG, (Object)UNCLEAN_LEADER_ELECTION_INTERVAL_MS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The frequency with which the controller checks if it should perform an unclean leader election for leaderless partitions.").define(UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Indicates whether to enable replicas not in the ISR set to be elected as leader as a last resort, even though doing so may result in data loss<p>Note: In KRaft mode, when enabling this config dynamically, it needs to wait for the unclean leader election thread to trigger election periodically (default is 5 minutes). Please run `kafka-leader-election.sh` with `unclean` option to trigger the unclean leader election immediately if needed.</p>").define("security.inter.broker.protocol", ConfigDef.Type.STRING, (Object)INTER_BROKER_SECURITY_PROTOCOL_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])Utils.enumOptions(SecurityProtocol.class)), ConfigDef.Importance.MEDIUM, "Security protocol used to communicate between brokers. It is an error to set this and inter.broker.listener.name properties at the same time.").define("inter.broker.listener.name", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Name of listener used for communication between brokers. If this is unset, the listener name is defined by security.inter.broker.protocol. It is an error to set this and security.inter.broker.protocol properties at the same time.").define("replica.selector.class", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The fully qualified class name that implements ReplicaSelector. This is used by the broker to find the preferred read replica. By default, we use an implementation that returns the leader.");
}

