/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumStoreFile
implements ChecksumStoreReaderWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumStoreFile.class);
    private final String storeDir;
    private final String storeFileName;
    private final String tempFileName;

    public ChecksumStoreFile(String storeDir, String fileName) {
        this.storeDir = storeDir;
        this.storeFileName = fileName;
        this.tempFileName = fileName + ".tmp";
    }

    @Override
    public synchronized ByteBuffer read() throws IOException {
        File storeFile = new File(this.storeDir, this.storeFileName);
        if (!storeFile.exists()) {
            LOG.warn("checksum store file : {} doesn't exit", (Object)storeFile.getAbsoluteFile());
            return ByteBuffer.allocate(0);
        }
        try (FileChannel channel = FileChannel.open(storeFile.toPath(), StandardOpenOption.READ);){
            LOG.info("reading checksum store file : {} , with size : {}", (Object)storeFile.getAbsoluteFile(), (Object)channel.size());
            long storeSize = channel.size();
            ByteBuffer buffer = ByteBuffer.allocate((int)storeSize).order(ByteOrder.LITTLE_ENDIAN);
            Utils.readFully((FileChannel)channel, (ByteBuffer)buffer, (long)0L);
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    @Override
    public synchronized void write(ByteBuffer buffer) throws IOException {
        File storeFile = new File(this.storeDir, this.storeFileName);
        File tempFile = new File(this.storeDir, this.tempFileName);
        try (FileChannel channel = FileChannel.open(tempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            Utils.writeFully((FileChannel)channel, (long)0L, (ByteBuffer)buffer);
            channel.force(true);
            Utils.atomicMoveWithFallback((Path)tempFile.toPath(), (Path)storeFile.toPath());
            LOG.debug("written {} bytes to checksum store file ", (Object)channel.size());
        }
    }

    @Override
    public synchronized void deleteIfExists() throws IOException {
        FilesWrapper.deleteIfExists((Path)Paths.get(this.storeDir, this.storeFileName));
    }
}

