/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.storage.internals.log.FollowerRestorePoint;
import org.apache.kafka.storage.internals.log.MaybeResolvedTimestampAndOffset;

public final class FetchedTimestampAndOffset
implements MaybeResolvedTimestampAndOffset {
    private final long timestamp;
    private final long offset;
    private final Optional<Integer> leaderEpoch;
    private final Optional<FollowerRestorePoint> followerRestorePoint;
    private final Optional<Exception> responseException;

    public FetchedTimestampAndOffset(long timestamp, long offset, Optional<Integer> leaderEpoch) {
        this(timestamp, offset, leaderEpoch, Optional.empty(), Optional.empty());
    }

    public FetchedTimestampAndOffset(long offset, Optional<Integer> leaderEpoch, FollowerRestorePoint followerRestorePoint) {
        this(-10000L, offset, leaderEpoch, Optional.of(followerRestorePoint), Optional.empty());
    }

    public FetchedTimestampAndOffset(Exception responseException) {
        this(0L, 0L, Optional.empty(), Optional.empty(), Optional.of(responseException));
    }

    private FetchedTimestampAndOffset(long timestamp, long offset, Optional<Integer> leaderEpoch, Optional<FollowerRestorePoint> followerRestorePoint, Optional<Exception> responseException) {
        Objects.requireNonNull(leaderEpoch, "leaderEpoch should not be null");
        Objects.requireNonNull(followerRestorePoint, "followerRestorePoint should not be null");
        Objects.requireNonNull(responseException, "responseException should not be null");
        this.timestamp = timestamp;
        this.offset = offset;
        this.leaderEpoch = leaderEpoch;
        this.followerRestorePoint = followerRestorePoint;
        this.responseException = responseException;
    }

    public long offset() {
        return this.offset;
    }

    public Optional<Integer> leaderEpoch() {
        return this.leaderEpoch;
    }

    public Optional<Exception> responseException() {
        return this.responseException;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Optional<FollowerRestorePoint> followerRestorePoint() {
        return this.followerRestorePoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchedTimestampAndOffset that = (FetchedTimestampAndOffset)o;
        return this.timestamp == that.timestamp && this.offset == that.offset && this.leaderEpoch.equals(that.leaderEpoch) && this.followerRestorePoint.equals(that.followerRestorePoint) && this.responseException.equals(that.responseException);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.offset, this.leaderEpoch, this.followerRestorePoint, this.responseException);
    }

    public String toString() {
        return "FetchedTimestampAndOffset(timestamp=" + this.timestamp + ", offset=" + this.offset + ", leaderEpoch=" + String.valueOf(this.leaderEpoch) + ", followerRestorePoint=" + String.valueOf(this.followerRestorePoint) + ", responseException=" + String.valueOf(this.responseException) + ")";
    }
}

