/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;

public class UnlimitedWindows
extends Windows<UnlimitedWindow> {
    private static final long DEFAULT_START_TIMESTAMP = 0L;
    public final long start;

    private UnlimitedWindows(String name, long start) {
        super(name);
        if (start < 0L) {
            throw new IllegalArgumentException("start must be > 0 (you provided " + start + ")");
        }
        this.start = start;
    }

    public static UnlimitedWindows of(String name) {
        return new UnlimitedWindows(name, 0L);
    }

    public UnlimitedWindows startOn(long start) {
        return new UnlimitedWindows(this.name, start);
    }

    @Override
    public Map<Long, UnlimitedWindow> windowsFor(long timestamp) {
        HashMap<Long, UnlimitedWindow> windows = new HashMap<Long, UnlimitedWindow>();
        if (timestamp >= this.start) {
            windows.put(this.start, new UnlimitedWindow(this.start));
        }
        return windows;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnlimitedWindows)) {
            return false;
        }
        UnlimitedWindows other = (UnlimitedWindows)o;
        return this.start == other.start;
    }

    public int hashCode() {
        return (int)(this.start ^ this.start >>> 32);
    }
}

