/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.streams.kstream.Window;

public abstract class Windows<W extends Window> {
    private static final int DEFAULT_NUM_SEGMENTS = 3;
    private static final long DEFAULT_MAINTAIN_DURATION = 86400000L;
    protected String name;
    private long maintainDurationMs;
    public int segments;

    protected Windows(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this.name = name;
        this.segments = 3;
        this.maintainDurationMs = 86400000L;
    }

    public String name() {
        return this.name;
    }

    public Windows<W> until(long durationMs) {
        this.maintainDurationMs = durationMs;
        return this;
    }

    protected Windows<W> segments(int segments) {
        this.segments = segments;
        return this;
    }

    public long maintainMs() {
        return this.maintainDurationMs;
    }

    public abstract Map<Long, W> windowsFor(long var1);
}

