/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.ValueJoiner;

public abstract class AbstractStream<K> {
    protected final KStreamBuilder topology;
    protected final String name;
    protected final Set<String> sourceNodes;

    public AbstractStream(AbstractStream<K> stream) {
        this.topology = stream.topology;
        this.name = stream.name;
        this.sourceNodes = stream.sourceNodes;
    }

    public AbstractStream(KStreamBuilder topology, String name, Set<String> sourceNodes) {
        this.topology = topology;
        this.name = name;
        this.sourceNodes = sourceNodes;
    }

    protected Set<String> ensureJoinableWith(AbstractStream<K> other) {
        Set<String> thisSourceNodes = this.sourceNodes;
        Set<String> otherSourceNodes = other.sourceNodes;
        if (thisSourceNodes == null || otherSourceNodes == null) {
            throw new TopologyBuilderException(this.name + " and " + other.name + " are not joinable");
        }
        HashSet<String> allSourceNodes = new HashSet<String>();
        allSourceNodes.addAll(thisSourceNodes);
        allSourceNodes.addAll(otherSourceNodes);
        this.topology.copartitionSources(allSourceNodes);
        return allSourceNodes;
    }

    public static <T2, T1, R> ValueJoiner<T2, T1, R> reverseJoiner(final ValueJoiner<T1, T2, R> joiner) {
        return new ValueJoiner<T2, T1, R>(){

            @Override
            public R apply(T2 value2, T1 value1) {
                return joiner.apply(value1, value2);
            }
        };
    }
}

