/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

public class KStreamReduce<K, V>
implements KStreamAggProcessorSupplier<K, K, V, V> {
    private final String storeName;
    private final Reducer<V> reducer;
    private boolean sendOldValues = false;

    public KStreamReduce(String storeName, Reducer<V> reducer) {
        this.storeName = storeName;
        this.reducer = reducer;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamReduceProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return new KStreamReduceValueGetter();
            }
        };
    }

    private class KStreamReduceValueGetter
    implements KTableValueGetter<K, V> {
        private KeyValueStore<K, V> store;

        private KStreamReduceValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (KeyValueStore)context.getStateStore(KStreamReduce.this.storeName);
        }

        @Override
        public V get(K key) {
            return this.store.get(key);
        }
    }

    private class KStreamReduceProcessor
    extends AbstractProcessor<K, V> {
        private KeyValueStore<K, V> store;

        private KStreamReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KStreamReduce.this.storeName);
        }

        @Override
        public void process(K key, V value) {
            Object oldAgg;
            if (key == null) {
                throw new StreamsException("Record key for KStream reduce operator with state " + KStreamReduce.this.storeName + " should not be null.");
            }
            Object newAgg = oldAgg = this.store.get(key);
            if (value != null) {
                newAgg = newAgg == null ? value : KStreamReduce.this.reducer.apply(newAgg, value);
            }
            this.store.put(key, newAgg);
            if (KStreamReduce.this.sendOldValues) {
                this.context().forward(key, new Change(newAgg, oldAgg));
            } else {
                this.context().forward(key, new Change<Object>(newAgg, null));
            }
        }
    }
}

