/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.QuickUnion;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.processor.internals.SourceNode;

public class TopologyBuilder {
    private final LinkedHashMap<String, NodeFactory> nodeFactories = new LinkedHashMap();
    private final Map<String, StateStoreFactory> stateFactories = new HashMap<String, StateStoreFactory>();
    private final Set<String> sourceTopicNames = new HashSet<String>();
    private final Set<String> internalTopicNames = new HashSet<String>();
    private final QuickUnion<String> nodeGrouper = new QuickUnion();
    private final List<Set<String>> copartitionSourceGroups = new ArrayList<Set<String>>();
    private final HashMap<String, String[]> nodeToSourceTopics = new HashMap();
    private final HashMap<String, String> nodeToSinkTopic = new HashMap();
    private Map<Integer, Set<String>> nodeGroups = null;
    private String applicationId = null;

    public final synchronized TopologyBuilder setApplicationId(String applicationId) {
        Objects.requireNonNull(applicationId, "applicationId can't be null");
        this.applicationId = applicationId;
        return this;
    }

    public final synchronized TopologyBuilder addSource(String name, String ... topics) {
        return this.addSource(name, (Deserializer)null, (Deserializer)null, topics);
    }

    public final synchronized TopologyBuilder addSource(String name, Deserializer keyDeserializer, Deserializer valDeserializer, String ... topics) {
        if (this.nodeFactories.containsKey(name)) {
            throw new TopologyBuilderException("Processor " + name + " is already added.");
        }
        for (String topic : topics) {
            if (this.sourceTopicNames.contains(topic)) {
                throw new TopologyBuilderException("Topic " + topic + " has already been registered by another source.");
            }
            this.sourceTopicNames.add(topic);
        }
        this.nodeFactories.put(name, new SourceNodeFactory(name, topics, keyDeserializer, valDeserializer));
        this.nodeToSourceTopics.put(name, (String[])topics.clone());
        this.nodeGrouper.add(name);
        return this;
    }

    public final synchronized TopologyBuilder addSink(String name, String topic, String ... parentNames) {
        return this.addSink(name, topic, (Serializer)null, (Serializer)null, parentNames);
    }

    public final synchronized TopologyBuilder addSink(String name, String topic, StreamPartitioner partitioner, String ... parentNames) {
        return this.addSink(name, topic, (Serializer)null, (Serializer)null, partitioner, parentNames);
    }

    public final synchronized TopologyBuilder addSink(String name, String topic, Serializer keySerializer, Serializer valSerializer, String ... parentNames) {
        return this.addSink(name, topic, keySerializer, valSerializer, (StreamPartitioner)null, parentNames);
    }

    public final synchronized <K, V> TopologyBuilder addSink(String name, String topic, Serializer<K> keySerializer, Serializer<V> valSerializer, StreamPartitioner<K, V> partitioner, String ... parentNames) {
        if (this.nodeFactories.containsKey(name)) {
            throw new TopologyBuilderException("Processor " + name + " is already added.");
        }
        if (parentNames != null) {
            for (String parent : parentNames) {
                if (parent.equals(name)) {
                    throw new TopologyBuilderException("Processor " + name + " cannot be a parent of itself.");
                }
                if (this.nodeFactories.containsKey(parent)) continue;
                throw new TopologyBuilderException("Parent processor " + parent + " is not added yet.");
            }
        }
        this.nodeFactories.put(name, new SinkNodeFactory(name, parentNames, topic, keySerializer, valSerializer, partitioner));
        this.nodeToSinkTopic.put(name, topic);
        this.nodeGrouper.add(name);
        this.nodeGrouper.unite(name, (String[])parentNames);
        return this;
    }

    public final synchronized TopologyBuilder addProcessor(String name, ProcessorSupplier supplier, String ... parentNames) {
        if (this.nodeFactories.containsKey(name)) {
            throw new TopologyBuilderException("Processor " + name + " is already added.");
        }
        if (parentNames != null) {
            for (String parent : parentNames) {
                if (parent.equals(name)) {
                    throw new TopologyBuilderException("Processor " + name + " cannot be a parent of itself.");
                }
                if (this.nodeFactories.containsKey(parent)) continue;
                throw new TopologyBuilderException("Parent processor " + parent + " is not added yet.");
            }
        }
        this.nodeFactories.put(name, new ProcessorNodeFactory(name, parentNames, supplier));
        this.nodeGrouper.add(name);
        this.nodeGrouper.unite(name, (String[])parentNames);
        return this;
    }

    public final synchronized TopologyBuilder addStateStore(StateStoreSupplier supplier, boolean isInternal, String ... processorNames) {
        if (this.stateFactories.containsKey(supplier.name())) {
            throw new TopologyBuilderException("StateStore " + supplier.name() + " is already added.");
        }
        this.stateFactories.put(supplier.name(), new StateStoreFactory(isInternal, supplier));
        if (processorNames != null) {
            for (String processorName : processorNames) {
                this.connectProcessorAndStateStore(processorName, supplier.name());
            }
        }
        return this;
    }

    public final synchronized TopologyBuilder addStateStore(StateStoreSupplier supplier, String ... processorNames) {
        return this.addStateStore(supplier, true, processorNames);
    }

    public final synchronized TopologyBuilder connectProcessorAndStateStores(String processorName, String ... stateStoreNames) {
        if (stateStoreNames != null) {
            for (String stateStoreName : stateStoreNames) {
                this.connectProcessorAndStateStore(processorName, stateStoreName);
            }
        }
        return this;
    }

    public final synchronized TopologyBuilder connectProcessors(String ... processorNames) {
        if (processorNames.length < 2) {
            throw new TopologyBuilderException("At least two processors need to participate in the connection.");
        }
        for (String processorName : processorNames) {
            if (this.nodeFactories.containsKey(processorName)) continue;
            throw new TopologyBuilderException("Processor " + processorName + " is not added yet.");
        }
        String firstProcessorName = processorNames[0];
        this.nodeGrouper.unite(firstProcessorName, (String[])Arrays.copyOfRange(processorNames, 1, processorNames.length));
        return this;
    }

    public final synchronized TopologyBuilder addInternalTopic(String topicName) {
        this.internalTopicNames.add(topicName);
        return this;
    }

    private void connectProcessorAndStateStore(String processorName, String stateStoreName) {
        if (!this.stateFactories.containsKey(stateStoreName)) {
            throw new TopologyBuilderException("StateStore " + stateStoreName + " is not added yet.");
        }
        if (!this.nodeFactories.containsKey(processorName)) {
            throw new TopologyBuilderException("Processor " + processorName + " is not added yet.");
        }
        StateStoreFactory stateStoreFactory = this.stateFactories.get(stateStoreName);
        Iterator<String> iter = stateStoreFactory.users.iterator();
        if (iter.hasNext()) {
            String user = iter.next();
            this.nodeGrouper.unite(user, (String[])new String[]{processorName});
        }
        stateStoreFactory.users.add(processorName);
        NodeFactory nodeFactory = this.nodeFactories.get(processorName);
        if (!(nodeFactory instanceof ProcessorNodeFactory)) {
            throw new TopologyBuilderException("cannot connect a state store " + stateStoreName + " to a source node or a sink node.");
        }
        ((ProcessorNodeFactory)nodeFactory).addStateStore(stateStoreName);
    }

    public synchronized Map<Integer, TopicsInfo> topicGroups() {
        HashMap<Integer, TopicsInfo> topicGroups = new HashMap<Integer, TopicsInfo>();
        if (this.nodeGroups == null) {
            this.nodeGroups = this.makeNodeGroups();
        }
        for (Map.Entry<Integer, Set<String>> entry : this.nodeGroups.entrySet()) {
            HashSet<String> sinkTopics = new HashSet<String>();
            HashSet<String> sourceTopics = new HashSet<String>();
            HashSet<String> internalSourceTopics = new HashSet<String>();
            HashSet<String> stateChangelogTopics = new HashSet<String>();
            for (String node : entry.getValue()) {
                String topic;
                String[] topics = this.nodeToSourceTopics.get(node);
                if (topics != null) {
                    for (String topic2 : topics) {
                        if (this.internalTopicNames.contains(topic2)) {
                            String internalTopic = this.decorateTopic(topic2);
                            internalSourceTopics.add(internalTopic);
                            sourceTopics.add(internalTopic);
                            continue;
                        }
                        sourceTopics.add(topic2);
                    }
                }
                if ((topic = this.nodeToSinkTopic.get(node)) != null) {
                    if (this.internalTopicNames.contains(topic)) {
                        sinkTopics.add(this.decorateTopic(topic));
                    } else {
                        sinkTopics.add(topic);
                    }
                }
                for (StateStoreFactory stateFactory : this.stateFactories.values()) {
                    if (!stateFactory.isInternal || !stateFactory.users.contains(node)) continue;
                    stateChangelogTopics.add(ProcessorStateManager.storeChangelogTopic(this.applicationId, stateFactory.supplier.name()));
                }
            }
            topicGroups.put(entry.getKey(), new TopicsInfo(Collections.unmodifiableSet(sinkTopics), Collections.unmodifiableSet(sourceTopics), Collections.unmodifiableSet(internalSourceTopics), Collections.unmodifiableSet(stateChangelogTopics)));
        }
        return Collections.unmodifiableMap(topicGroups);
    }

    public synchronized Map<Integer, Set<String>> nodeGroups() {
        if (this.nodeGroups == null) {
            this.nodeGroups = this.makeNodeGroups();
        }
        return this.nodeGroups;
    }

    private Map<Integer, Set<String>> makeNodeGroups() {
        Set<String> nodeGroup;
        String root;
        HashMap<Integer, Set<String>> nodeGroups = new HashMap<Integer, Set<String>>();
        HashMap rootToNodeGroup = new HashMap();
        int nodeGroupId = 0;
        for (String nodeName : Utils.sorted(this.nodeToSourceTopics.keySet())) {
            root = this.nodeGrouper.root(nodeName);
            nodeGroup = (HashSet<String>)rootToNodeGroup.get(root);
            if (nodeGroup == null) {
                nodeGroup = new HashSet<String>();
                rootToNodeGroup.put(root, nodeGroup);
                nodeGroups.put(nodeGroupId++, nodeGroup);
            }
            nodeGroup.add(nodeName);
        }
        for (String nodeName : Utils.sorted(this.nodeFactories.keySet())) {
            if (this.nodeToSourceTopics.containsKey(nodeName)) continue;
            root = this.nodeGrouper.root(nodeName);
            nodeGroup = (Set)rootToNodeGroup.get(root);
            if (nodeGroup == null) {
                nodeGroup = new HashSet();
                rootToNodeGroup.put(root, nodeGroup);
                nodeGroups.put(nodeGroupId++, nodeGroup);
            }
            nodeGroup.add(nodeName);
        }
        return nodeGroups;
    }

    public final synchronized TopologyBuilder copartitionSources(Collection<String> sourceNodes) {
        this.copartitionSourceGroups.add(Collections.unmodifiableSet(new HashSet<String>(sourceNodes)));
        return this;
    }

    public synchronized Collection<Set<String>> copartitionGroups() {
        ArrayList list = new ArrayList(this.copartitionSourceGroups.size());
        for (Set<String> nodeNames : this.copartitionSourceGroups) {
            HashSet<String> copartitionGroup = new HashSet<String>();
            for (String node : nodeNames) {
                String[] topics = this.nodeToSourceTopics.get(node);
                if (topics == null) continue;
                copartitionGroup.addAll(this.maybeDecorateInternalSourceTopics(topics));
            }
            list.add(Collections.unmodifiableSet(copartitionGroup));
        }
        return Collections.unmodifiableList(list);
    }

    public synchronized ProcessorTopology build(Integer topicGroupId) {
        Set<String> nodeGroup = topicGroupId != null ? this.nodeGroups().get(topicGroupId) : null;
        return this.build(nodeGroup);
    }

    private ProcessorTopology build(Set<String> nodeGroup) {
        ArrayList<ProcessorNode> processorNodes = new ArrayList<ProcessorNode>(this.nodeFactories.size());
        HashMap<String, ProcessorNode> processorMap = new HashMap<String, ProcessorNode>();
        HashMap<String, SourceNode> topicSourceMap = new HashMap<String, SourceNode>();
        HashMap<String, StateStoreSupplier> stateStoreMap = new HashMap<String, StateStoreSupplier>();
        for (NodeFactory factory : this.nodeFactories.values()) {
            if (nodeGroup != null && !nodeGroup.contains(factory.name)) continue;
            ProcessorNode node = factory.build();
            processorNodes.add(node);
            processorMap.put(node.name(), node);
            if (factory instanceof ProcessorNodeFactory) {
                for (String parent : ((ProcessorNodeFactory)factory).parents) {
                    ((ProcessorNode)processorMap.get(parent)).addChild(node);
                }
                for (String stateStoreName : ((ProcessorNodeFactory)factory).stateStoreNames) {
                    if (stateStoreMap.containsKey(stateStoreName)) continue;
                    stateStoreMap.put(stateStoreName, this.stateFactories.get((Object)stateStoreName).supplier);
                }
                continue;
            }
            if (factory instanceof SourceNodeFactory) {
                for (String topic : ((SourceNodeFactory)factory).topics) {
                    if (this.internalTopicNames.contains(topic)) {
                        topicSourceMap.put(this.decorateTopic(topic), (SourceNode)node);
                        continue;
                    }
                    topicSourceMap.put(topic, (SourceNode)node);
                }
                continue;
            }
            if (factory instanceof SinkNodeFactory) {
                for (String parent : ((SinkNodeFactory)factory).parents) {
                    ((ProcessorNode)processorMap.get(parent)).addChild(node);
                }
                continue;
            }
            throw new TopologyBuilderException("Unknown definition class: " + factory.getClass().getName());
        }
        return new ProcessorTopology(processorNodes, topicSourceMap, new ArrayList<StateStoreSupplier>(stateStoreMap.values()));
    }

    public synchronized Set<String> sourceTopics() {
        Set<String> topics = this.maybeDecorateInternalSourceTopics(this.sourceTopicNames);
        return Collections.unmodifiableSet(topics);
    }

    private Set<String> maybeDecorateInternalSourceTopics(Set<String> sourceTopics) {
        return this.maybeDecorateInternalSourceTopics(sourceTopics.toArray(new String[sourceTopics.size()]));
    }

    private Set<String> maybeDecorateInternalSourceTopics(String ... sourceTopics) {
        HashSet<String> decoratedTopics = new HashSet<String>();
        for (String topic : sourceTopics) {
            if (this.internalTopicNames.contains(topic)) {
                decoratedTopics.add(this.decorateTopic(topic));
                continue;
            }
            decoratedTopics.add(topic);
        }
        return decoratedTopics;
    }

    private String decorateTopic(String topic) {
        if (this.applicationId == null) {
            throw new TopologyBuilderException("there are internal topics and applicationId hasn't been set. Call setApplicationId first");
        }
        return this.applicationId + "-" + topic;
    }

    public static class TopicsInfo {
        public Set<String> sinkTopics;
        public Set<String> sourceTopics;
        public Set<String> interSourceTopics;
        public Set<String> stateChangelogTopics;

        public TopicsInfo(Set<String> sinkTopics, Set<String> sourceTopics, Set<String> interSourceTopics, Set<String> stateChangelogTopics) {
            this.sinkTopics = sinkTopics;
            this.sourceTopics = sourceTopics;
            this.interSourceTopics = interSourceTopics;
            this.stateChangelogTopics = stateChangelogTopics;
        }

        public boolean equals(Object o) {
            if (o instanceof TopicsInfo) {
                TopicsInfo other = (TopicsInfo)o;
                return other.sourceTopics.equals(this.sourceTopics) && other.stateChangelogTopics.equals(this.stateChangelogTopics);
            }
            return false;
        }

        public int hashCode() {
            long n = (long)this.sourceTopics.hashCode() << 32 | (long)this.stateChangelogTopics.hashCode();
            return (int)(n % 0xFFFFFFFFL);
        }
    }

    private class SinkNodeFactory
    extends NodeFactory {
        public final String[] parents;
        public final String topic;
        private Serializer keySerializer;
        private Serializer valSerializer;
        private final StreamPartitioner partitioner;

        private SinkNodeFactory(String name, String[] parents, String topic, Serializer keySerializer, Serializer valSerializer, StreamPartitioner partitioner) {
            super(name);
            this.parents = (String[])parents.clone();
            this.topic = topic;
            this.keySerializer = keySerializer;
            this.valSerializer = valSerializer;
            this.partitioner = partitioner;
        }

        @Override
        public ProcessorNode build() {
            if (TopologyBuilder.this.internalTopicNames.contains(this.topic)) {
                return new SinkNode(this.name, TopologyBuilder.this.decorateTopic(this.topic), this.keySerializer, this.valSerializer, this.partitioner);
            }
            return new SinkNode(this.name, this.topic, this.keySerializer, this.valSerializer, this.partitioner);
        }
    }

    private static class SourceNodeFactory
    extends NodeFactory {
        public final String[] topics;
        private Deserializer keyDeserializer;
        private Deserializer valDeserializer;

        private SourceNodeFactory(String name, String[] topics, Deserializer keyDeserializer, Deserializer valDeserializer) {
            super(name);
            this.topics = (String[])topics.clone();
            this.keyDeserializer = keyDeserializer;
            this.valDeserializer = valDeserializer;
        }

        @Override
        public ProcessorNode build() {
            return new SourceNode(this.name, this.keyDeserializer, this.valDeserializer);
        }
    }

    private static class ProcessorNodeFactory
    extends NodeFactory {
        public final String[] parents;
        private final ProcessorSupplier supplier;
        private final Set<String> stateStoreNames = new HashSet<String>();

        public ProcessorNodeFactory(String name, String[] parents, ProcessorSupplier supplier) {
            super(name);
            this.parents = (String[])parents.clone();
            this.supplier = supplier;
        }

        public void addStateStore(String stateStoreName) {
            this.stateStoreNames.add(stateStoreName);
        }

        @Override
        public ProcessorNode build() {
            return new ProcessorNode(this.name, this.supplier.get(), this.stateStoreNames);
        }
    }

    private static abstract class NodeFactory {
        public final String name;

        NodeFactory(String name) {
            this.name = name;
        }

        public abstract ProcessorNode build();
    }

    private static class StateStoreFactory {
        public final Set<String> users;
        public final boolean isInternal;
        public final StateStoreSupplier supplier;

        StateStoreFactory(boolean isInternal, StateStoreSupplier supplier) {
            this.isInternal = isInternal;
            this.supplier = supplier;
            this.users = new HashSet<String>();
        }
    }
}

