/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;

class KStreamMap<K, V, K1, V1>
implements ProcessorSupplier<K, V> {
    private final KeyValueMapper<K, V, KeyValue<K1, V1>> mapper;

    public KStreamMap(KeyValueMapper<K, V, KeyValue<K1, V1>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamMapProcessor();
    }

    private class KStreamMapProcessor
    extends AbstractProcessor<K, V> {
        private KStreamMapProcessor() {
        }

        @Override
        public void process(K key, V value) {
            KeyValue newPair = (KeyValue)KStreamMap.this.mapper.apply(key, value);
            this.context().forward(newPair.key, newPair.value);
        }
    }
}

