/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public class KStreamTransformValues<K, V, R>
implements ProcessorSupplier<K, V> {
    private final ValueTransformerSupplier<V, R> valueTransformerSupplier;

    public KStreamTransformValues(ValueTransformerSupplier<V, R> valueTransformerSupplier) {
        this.valueTransformerSupplier = valueTransformerSupplier;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamTransformValuesProcessor(this.valueTransformerSupplier.get());
    }

    public static class KStreamTransformValuesProcessor<K, V, R>
    implements Processor<K, V> {
        private final ValueTransformer<V, R> valueTransformer;
        private ProcessorContext context;

        public KStreamTransformValuesProcessor(ValueTransformer<V, R> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void init(ProcessorContext context) {
            this.valueTransformer.init(context);
            this.context = context;
        }

        @Override
        public void process(K key, V value) {
            this.context.forward(key, this.valueTransformer.transform(value));
        }

        @Override
        public void punctuate(long timestamp) {
            R ret = this.valueTransformer.punctuate(timestamp);
            if (ret != null) {
                this.context.forward(null, ret);
            }
        }

        @Override
        public void close() {
            this.valueTransformer.close();
        }
    }
}

