/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CachedStateStore;

public class KTableAggregate<K, V, T>
implements KTableProcessorSupplier<K, V, T> {
    private final String storeName;
    private final Initializer<T> initializer;
    private final Aggregator<K, V, T> add;
    private final Aggregator<K, V, T> remove;
    private boolean sendOldValues = false;

    public KTableAggregate(String storeName, Initializer<T> initializer, Aggregator<K, V, T> add, Aggregator<K, V, T> remove) {
        this.storeName = storeName;
        this.initializer = initializer;
        this.add = add;
        this.remove = remove;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableAggregateProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, T> view() {
        return new KTableValueGetterSupplier<K, T>(){

            @Override
            public KTableValueGetter<K, T> get() {
                return new KTableAggregateValueGetter();
            }
        };
    }

    private class KTableAggregateValueGetter
    implements KTableValueGetter<K, T> {
        private KeyValueStore<K, T> store;

        private KTableAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.store = (KeyValueStore)context.getStateStore(KTableAggregate.this.storeName);
        }

        @Override
        public T get(K key) {
            return this.store.get(key);
        }
    }

    private class KTableAggregateProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KeyValueStore<K, T> store;

        private KTableAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KTableAggregate.this.storeName);
            ((CachedStateStore)((Object)this.store)).setFlushListener(new ForwardingCacheFlushListener(context, KTableAggregate.this.sendOldValues));
        }

        @Override
        public void process(K key, Change<V> value) {
            if (key == null) {
                throw new StreamsException("Record key for KTable aggregate operator with state " + KTableAggregate.this.storeName + " should not be null.");
            }
            Object oldAgg = this.store.get(key);
            if (oldAgg == null) {
                oldAgg = KTableAggregate.this.initializer.apply();
            }
            Object newAgg = oldAgg;
            if (value.oldValue != null) {
                newAgg = KTableAggregate.this.remove.apply(key, value.oldValue, newAgg);
            }
            if (value.newValue != null) {
                newAgg = KTableAggregate.this.add.apply(key, value.newValue, newAgg);
            }
            this.store.put(key, newAgg);
        }
    }
}

