/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class QueryableStoreTypes {
    public static <K, V> QueryableStoreType<ReadOnlyKeyValueStore<K, V>> keyValueStore() {
        return new KeyValueStoreType();
    }

    public static <K, V> QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStore() {
        return new WindowStoreType();
    }

    private static class WindowStoreType<K, V>
    extends QueryableStoreTypeMatcher<ReadOnlyWindowStore<K, V>> {
        WindowStoreType() {
            super(ReadOnlyWindowStore.class);
        }

        @Override
        public ReadOnlyWindowStore<K, V> create(StateStoreProvider storeProvider, String storeName) {
            return new CompositeReadOnlyWindowStore(storeProvider, this, storeName);
        }
    }

    private static class KeyValueStoreType<K, V>
    extends QueryableStoreTypeMatcher<ReadOnlyKeyValueStore<K, V>> {
        KeyValueStoreType() {
            super(ReadOnlyKeyValueStore.class);
        }

        @Override
        public ReadOnlyKeyValueStore<K, V> create(StateStoreProvider storeProvider, String storeName) {
            return new CompositeReadOnlyKeyValueStore(storeProvider, this, storeName);
        }
    }

    private static abstract class QueryableStoreTypeMatcher<T>
    implements QueryableStoreType<T> {
        private final Class matchTo;

        QueryableStoreTypeMatcher(Class matchTo) {
            this.matchTo = matchTo;
        }

        @Override
        public boolean accepts(StateStore stateStore) {
            return this.matchTo.isAssignableFrom(stateStore.getClass());
        }
    }
}

