/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;

class DelegatingPeekingKeyValueIterator<K, V>
implements PeekingKeyValueIterator<K, V> {
    private final KeyValueIterator<K, V> underlying;
    private KeyValue<K, V> next;

    public DelegatingPeekingKeyValueIterator(KeyValueIterator<K, V> underlying) {
        this.underlying = underlying;
    }

    @Override
    public K peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next.key;
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (!this.underlying.hasNext()) {
            return false;
        }
        this.next = (KeyValue)this.underlying.next();
        return true;
    }

    @Override
    public KeyValue<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyValue<K, V> result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

