/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.ProducedInternal;
import org.apache.kafka.streams.kstream.internals.StreamsGraphNode;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

class StreamSinkNode<K, V>
extends StreamsGraphNode {
    private final String topic;
    private final ProducedInternal<K, V> producedInternal;

    StreamSinkNode(String parentProcessorNodeName, String processorNodeName, String topic, ProducedInternal<K, V> producedInternal) {
        super(parentProcessorNodeName, processorNodeName, false);
        this.topic = topic;
        this.producedInternal = producedInternal;
    }

    String topic() {
        return this.topic;
    }

    Serde<K> keySerde() {
        return this.producedInternal.keySerde();
    }

    Serializer<K> keySerializer() {
        return this.producedInternal.keySerde() != null ? this.producedInternal.keySerde().serializer() : null;
    }

    Serde<V> valueSerde() {
        return this.producedInternal.valueSerde();
    }

    Serializer<V> valueSerializer() {
        return this.producedInternal.valueSerde() != null ? this.producedInternal.valueSerde().serializer() : null;
    }

    StreamPartitioner<? super K, ? super V> streamPartitioner() {
        return this.producedInternal.streamPartitioner();
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }
}

