/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;

public class QueryableStoreProvider {
    private final Map<String, StreamThreadStateStoreProvider> storeProviders = new HashMap<String, StreamThreadStateStoreProvider>();
    private final GlobalStateStoreProvider globalStoreProvider;

    public QueryableStoreProvider(GlobalStateStoreProvider globalStateStoreProvider) {
        this.globalStoreProvider = globalStateStoreProvider;
    }

    public <T> T getStore(StoreQueryParameters<T> storeQueryParameters) {
        QueryableStoreType<T> queryableStoreType;
        String storeName = storeQueryParameters.storeName();
        List<T> globalStore = this.globalStoreProvider.stores(storeName, queryableStoreType = storeQueryParameters.queryableStoreType());
        if (!globalStore.isEmpty()) {
            return queryableStoreType.create(this.globalStoreProvider, storeName);
        }
        return queryableStoreType.create(new WrappingStoreProvider(this.storeProviders.values(), storeQueryParameters), storeName);
    }

    public void addStoreProviderForThread(String threadName, StreamThreadStateStoreProvider streamThreadStateStoreProvider) {
        this.storeProviders.put(threadName, streamThreadStateStoreProvider);
    }

    public void removeStoreProviderForThread(String threadName) {
        this.storeProviders.remove(threadName);
    }
}

