/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import java.io.InputStream;
import java.util.Properties;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMetrics {
    private static final Logger log = LoggerFactory.getLogger(ClientMetrics.class);
    private static final String VERSION = "version";
    private static final String COMMIT_ID = "commit-id";
    private static final String APPLICATION_ID = "application-id";
    private static final String TOPOLOGY_DESCRIPTION = "topology-description";
    private static final String STATE = "state";
    private static final String VERSION_FROM_FILE;
    private static final String COMMIT_ID_FROM_FILE;
    private static final String DEFAULT_VALUE = "unknown";
    private static final String VERSION_DESCRIPTION = "The version of the Kafka Streams client";
    private static final String COMMIT_ID_DESCRIPTION = "The version control commit ID of the Kafka Streams client";
    private static final String APPLICATION_ID_DESCRIPTION = "The application ID of the Kafka Streams client";
    private static final String TOPOLOGY_DESCRIPTION_DESCRIPTION = "The description of the topology executed in the Kafka Streams client";
    private static final String STATE_DESCRIPTION = "The state of the Kafka Streams client";

    private ClientMetrics() {
    }

    public static String version() {
        return VERSION_FROM_FILE;
    }

    public static String commitId() {
        return COMMIT_ID_FROM_FILE;
    }

    public static void addVersionMetric(StreamsMetricsImpl streamsMetrics) {
        streamsMetrics.addClientLevelImmutableMetric(VERSION, VERSION_DESCRIPTION, Sensor.RecordingLevel.INFO, VERSION_FROM_FILE);
    }

    public static void addCommitIdMetric(StreamsMetricsImpl streamsMetrics) {
        streamsMetrics.addClientLevelImmutableMetric(COMMIT_ID, COMMIT_ID_DESCRIPTION, Sensor.RecordingLevel.INFO, COMMIT_ID_FROM_FILE);
    }

    public static void addApplicationIdMetric(StreamsMetricsImpl streamsMetrics, String applicationId) {
        streamsMetrics.addClientLevelImmutableMetric(APPLICATION_ID, APPLICATION_ID_DESCRIPTION, Sensor.RecordingLevel.INFO, applicationId);
    }

    public static void addTopologyDescriptionMetric(StreamsMetricsImpl streamsMetrics, String topologyDescription) {
        streamsMetrics.addClientLevelImmutableMetric(TOPOLOGY_DESCRIPTION, TOPOLOGY_DESCRIPTION_DESCRIPTION, Sensor.RecordingLevel.INFO, topologyDescription);
    }

    public static void addStateMetric(StreamsMetricsImpl streamsMetrics, Gauge<KafkaStreams.State> stateProvider) {
        streamsMetrics.addClientLevelMutableMetric(STATE, STATE_DESCRIPTION, Sensor.RecordingLevel.INFO, stateProvider);
    }

    static {
        Properties props = new Properties();
        try (InputStream resourceStream = ClientMetrics.class.getResourceAsStream("/kafka/kafka-streams-version.properties");){
            props.load(resourceStream);
        }
        catch (Exception exception) {
            log.warn("Error while loading kafka-streams-version.properties", (Throwable)exception);
        }
        VERSION_FROM_FILE = props.getProperty(VERSION, DEFAULT_VALUE).trim();
        COMMIT_ID_FROM_FILE = props.getProperty("commitId", DEFAULT_VALUE).trim();
    }
}

