/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreSupplier;

public class MaterializedInternal<K, V, S extends StateStore>
extends Materialized<K, V, S> {
    private final boolean queriable;

    public MaterializedInternal(Materialized<K, V, S> materialized) {
        this(materialized, null, null);
    }

    public MaterializedInternal(Materialized<K, V, S> materialized, InternalNameProvider nameProvider, String generatedStorePrefix) {
        super(materialized);
        boolean bl = this.queriable = this.storeName() != null;
        if (!this.queriable && nameProvider != null) {
            this.storeName = nameProvider.newStoreName(generatedStorePrefix);
        }
    }

    public String queryableStoreName() {
        return this.queriable ? this.storeName() : null;
    }

    public String storeName() {
        if (this.storeSupplier != null) {
            return this.storeSupplier.name();
        }
        return this.storeName;
    }

    public StoreSupplier<S> storeSupplier() {
        return this.storeSupplier;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    Map<String, String> logConfig() {
        return this.topicConfig;
    }

    public boolean cachingEnabled() {
        return this.cachingEnabled;
    }

    Duration retention() {
        return this.retention;
    }
}

