/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;

public class SubscriptionWrapperSerde<K>
implements Serde<SubscriptionWrapper<K>> {
    private final SubscriptionWrapperSerializer<K> serializer;
    private final SubscriptionWrapperDeserializer<K> deserializer;

    public SubscriptionWrapperSerde(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Serde<K> primaryKeySerde) {
        this.serializer = new SubscriptionWrapperSerializer(primaryKeySerializationPseudoTopicSupplier, primaryKeySerde == null ? null : primaryKeySerde.serializer());
        this.deserializer = new SubscriptionWrapperDeserializer(primaryKeySerializationPseudoTopicSupplier, primaryKeySerde == null ? null : primaryKeySerde.deserializer());
    }

    public Serializer<SubscriptionWrapper<K>> serializer() {
        return this.serializer;
    }

    public Deserializer<SubscriptionWrapper<K>> deserializer() {
        return this.deserializer;
    }

    private static class SubscriptionWrapperDeserializer<K>
    implements Deserializer<SubscriptionWrapper<K>>,
    WrappingNullableDeserializer<SubscriptionWrapper<K>, K> {
        private final Supplier<String> primaryKeySerializationPseudoTopicSupplier;
        private String primaryKeySerializationPseudoTopic = null;
        private Deserializer<K> primaryKeyDeserializer;

        SubscriptionWrapperDeserializer(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Deserializer<K> primaryKeyDeserializer) {
            this.primaryKeySerializationPseudoTopicSupplier = primaryKeySerializationPseudoTopicSupplier;
            this.primaryKeyDeserializer = primaryKeyDeserializer;
        }

        @Override
        public void setIfUnset(Deserializer<K> defaultDeserializer) {
            if (this.primaryKeyDeserializer == null) {
                this.primaryKeyDeserializer = Objects.requireNonNull(defaultDeserializer, "defaultDeserializer cannot be null");
            }
        }

        public SubscriptionWrapper<K> deserialize(String ignored, byte[] data) {
            long[] hash;
            ByteBuffer buf = ByteBuffer.wrap(data);
            byte versionAndIsHashNull = buf.get();
            byte version = (byte)(0x7F & versionAndIsHashNull);
            boolean isHashNull = (0x80 & versionAndIsHashNull) == 128;
            SubscriptionWrapper.Instruction inst = SubscriptionWrapper.Instruction.fromValue(buf.get());
            int lengthSum = 2;
            if (isHashNull) {
                hash = null;
            } else {
                hash = new long[]{buf.getLong(), buf.getLong()};
                lengthSum += 16;
            }
            byte[] primaryKeyRaw = new byte[data.length - lengthSum];
            buf.get(primaryKeyRaw, 0, primaryKeyRaw.length);
            if (this.primaryKeySerializationPseudoTopic == null) {
                this.primaryKeySerializationPseudoTopic = this.primaryKeySerializationPseudoTopicSupplier.get();
            }
            Object primaryKey = this.primaryKeyDeserializer.deserialize(this.primaryKeySerializationPseudoTopic, primaryKeyRaw);
            return new SubscriptionWrapper<Object>(hash, inst, primaryKey, version);
        }
    }

    private static class SubscriptionWrapperSerializer<K>
    implements Serializer<SubscriptionWrapper<K>>,
    WrappingNullableSerializer<SubscriptionWrapper<K>, K> {
        private final Supplier<String> primaryKeySerializationPseudoTopicSupplier;
        private String primaryKeySerializationPseudoTopic = null;
        private Serializer<K> primaryKeySerializer;

        SubscriptionWrapperSerializer(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Serializer<K> primaryKeySerializer) {
            this.primaryKeySerializationPseudoTopicSupplier = primaryKeySerializationPseudoTopicSupplier;
            this.primaryKeySerializer = primaryKeySerializer;
        }

        @Override
        public void setIfUnset(Serializer<K> defaultSerializer) {
            if (this.primaryKeySerializer == null) {
                this.primaryKeySerializer = Objects.requireNonNull(defaultSerializer, "defaultSerializer cannot be null");
            }
        }

        public byte[] serialize(String ignored, SubscriptionWrapper<K> data) {
            ByteBuffer buf;
            if (Byte.compare((byte)127, data.getVersion()) < 0) {
                throw new UnsupportedVersionException("SubscriptionWrapper version is larger than maximum supported 0x7F");
            }
            if (this.primaryKeySerializationPseudoTopic == null) {
                this.primaryKeySerializationPseudoTopic = this.primaryKeySerializationPseudoTopicSupplier.get();
            }
            byte[] primaryKeySerializedData = this.primaryKeySerializer.serialize(this.primaryKeySerializationPseudoTopic, data.getPrimaryKey());
            if (data.getHash() != null) {
                buf = ByteBuffer.allocate(18 + primaryKeySerializedData.length);
                buf.put(data.getVersion());
            } else {
                buf = ByteBuffer.allocate(2 + primaryKeySerializedData.length);
                buf.put((byte)(data.getVersion() | 0xFFFFFF80));
            }
            buf.put(data.getInstruction().getValue());
            long[] elem = data.getHash();
            if (data.getHash() != null) {
                buf.putLong(elem[0]);
                buf.putLong(elem[1]);
            }
            buf.put(primaryKeySerializedData);
            return buf.array();
        }
    }
}

