/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.graph.StateStoreNode;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

public class GlobalStoreNode
extends StateStoreNode {
    private final String sourceName;
    private final String topic;
    private final ConsumedInternal consumed;
    private final String processorName;
    private final ProcessorSupplier stateUpdateSupplier;

    public GlobalStoreNode(StoreBuilder<KeyValueStore> storeBuilder, String sourceName, String topic, ConsumedInternal consumed, String processorName, ProcessorSupplier stateUpdateSupplier) {
        super(storeBuilder);
        this.sourceName = sourceName;
        this.topic = topic;
        this.consumed = consumed;
        this.processorName = processorName;
        this.stateUpdateSupplier = stateUpdateSupplier;
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        this.storeBuilder.withLoggingDisabled();
        topologyBuilder.addGlobalStore(this.storeBuilder, this.sourceName, this.consumed.timestampExtractor(), this.consumed.keyDeserializer(), this.consumed.valueDeserializer(), this.topic, this.processorName, this.stateUpdateSupplier);
    }

    @Override
    public String toString() {
        return "GlobalStoreNode{sourceName='" + this.sourceName + '\'' + ", topic='" + this.topic + '\'' + ", processorName='" + this.processorName + '\'' + "} ";
    }
}

